/*
 * Decompiled with CFR 0.152.
 */
package io.autodidact.rnmathview;

import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableArray;
import java.util.ArrayList;

class SVGLength {
    final double value;
    final UnitType unit;

    private SVGLength() {
        this.value = 0.0;
        this.unit = UnitType.UNKNOWN;
    }

    SVGLength(double number) {
        this.value = number;
        this.unit = UnitType.NUMBER;
    }

    public SVGLength(String length) {
        length = length.trim();
        int stringLength = length.length();
        int percentIndex = stringLength - 1;
        if (stringLength == 0 || length.equals("normal")) {
            this.unit = UnitType.UNKNOWN;
            this.value = 0.0;
        } else if (length.codePointAt(percentIndex) == 37) {
            this.unit = UnitType.PERCENTAGE;
            this.value = Double.valueOf(length.substring(0, percentIndex));
        } else {
            int twoLetterUnitIndex = stringLength - 2;
            if (twoLetterUnitIndex > 0) {
                String lastTwo = length.substring(twoLetterUnitIndex);
                int end = twoLetterUnitIndex;
                switch (lastTwo) {
                    case "px": {
                        this.unit = UnitType.NUMBER;
                        break;
                    }
                    case "em": {
                        this.unit = UnitType.EMS;
                        break;
                    }
                    case "ex": {
                        this.unit = UnitType.EXS;
                        break;
                    }
                    case "pt": {
                        this.unit = UnitType.PT;
                        break;
                    }
                    case "pc": {
                        this.unit = UnitType.PC;
                        break;
                    }
                    case "mm": {
                        this.unit = UnitType.MM;
                        break;
                    }
                    case "cm": {
                        this.unit = UnitType.CM;
                        break;
                    }
                    case "in": {
                        this.unit = UnitType.IN;
                        break;
                    }
                    default: {
                        this.unit = UnitType.NUMBER;
                        end = stringLength;
                    }
                }
                this.value = Double.valueOf(length.substring(0, end));
            } else {
                this.unit = UnitType.NUMBER;
                this.value = Double.valueOf(length);
            }
        }
    }

    static SVGLength from(Dynamic dynamic) {
        switch (dynamic.getType()) {
            case Number: {
                return new SVGLength(dynamic.asDouble());
            }
            case String: {
                return new SVGLength(dynamic.asString());
            }
        }
        return new SVGLength();
    }

    static String toString(Dynamic dynamic) {
        switch (dynamic.getType()) {
            case Number: {
                return String.valueOf(dynamic.asDouble());
            }
            case String: {
                return dynamic.asString();
            }
        }
        return null;
    }

    static ArrayList<SVGLength> arrayFrom(Dynamic dynamic) {
        switch (dynamic.getType()) {
            case Number: {
                ArrayList<SVGLength> list = new ArrayList<SVGLength>(1);
                list.add(new SVGLength(dynamic.asDouble()));
                return list;
            }
            case Array: {
                ReadableArray arr = dynamic.asArray();
                int size = arr.size();
                ArrayList<SVGLength> list = new ArrayList<SVGLength>(size);
                for (int i = 0; i < size; ++i) {
                    Dynamic val = arr.getDynamic(i);
                    list.add(SVGLength.from(val));
                }
                return list;
            }
            case String: {
                ArrayList<SVGLength> list = new ArrayList<SVGLength>(1);
                list.add(new SVGLength(dynamic.asString()));
                return list;
            }
        }
        return null;
    }

    public static enum UnitType {
        UNKNOWN,
        NUMBER,
        PERCENTAGE,
        EMS,
        EXS,
        PX,
        CM,
        MM,
        IN,
        PT,
        PC;

    }
}

