/*
 * Decompiled with CFR 0.152.
 */
package io.autodidact.rnmathview;

import android.content.Context;
import android.util.Log;
import android.view.ViewGroup;
import com.caverock.androidsvg.PreserveAspectRatio;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGImageView;
import com.caverock.androidsvg.SVGParseException;
import com.facebook.react.uimanager.ThemedReactContext;
import io.autodidact.rnmathview.SVGAttributes;

public class SVGMathView
extends SVGImageView {
    private static String TAG = "RNSVGMathView";
    private String mSVGString;
    private boolean mIsDirty;
    private SVG mSVG;
    private SVGAttributes mSVGAttributes;
    private PreserveAspectRatio mPreserveAspectRatio = PreserveAspectRatio.LETTERBOX;
    private String mCSS = "";
    private String mColor;
    private String mColorCSS = "";

    public SVGMathView(ThemedReactContext context) {
        super((Context)context);
        this.mSVGAttributes = new SVGAttributes();
        this.setLayerType(2, null);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
    }

    public SVGAttributes getSVGAttributes() {
        return this.mSVGAttributes;
    }

    private void setDocumentDimensions() {
        this.setDocumentDimensions(this.mSVGAttributes.width, this.mSVGAttributes.height);
    }

    private void setDocumentDimensions(float width, float height) {
    }

    public void setSVGString(String svg) {
        if (this.mSVGString == null || this.mSVGString != svg) {
            this.mIsDirty = true;
        }
        this.mSVGString = svg;
    }

    public void updateView() {
        if (this.mIsDirty) {
            this.loadSVG();
        }
        this.mIsDirty = false;
    }

    private void loadSVG(String svg) {
        this.setSVGString(svg);
        this.loadSVG();
    }

    private void loadSVG() {
        try {
            this.mSVG = SVG.getFromString((String)this.mSVGString);
            this.mSVGAttributes.setSVG(this.mSVGString);
            this.mSVG.setRenderDPI(this.getResources().getDisplayMetrics().xdpi);
            this.mSVG.setDocumentPreserveAspectRatio(this.mPreserveAspectRatio);
            this.mSVG.setDocumentWidth("100%");
            this.mSVG.setDocumentHeight("100%");
            this.setSVG(this.mSVG);
        }
        catch (SVGParseException err) {
            Log.e((String)TAG, (String)"Failed to parse svg", (Throwable)err);
        }
    }

    public void setColor(int color) {
        int A = color >> 24 & 0xFF;
        int R = color >> 16 & 0xFF;
        int G = color >> 8 & 0xFF;
        int B = color & 0xFF;
        this.setColor("rgba(" + R + ", " + G + ", " + B + ", " + A + ")");
    }

    private void setColor(String color) {
        this.mColor = color;
        this.mColorCSS = "* { fill: " + color + "; stroke: " + color + "; } ";
        this.postCSS(this.mColorCSS);
    }

    private void postCSS(String css) {
        super.setCSS(css);
    }

    public void setCSS(String css) {
        css = css + this.mColorCSS;
        this.postCSS(css);
    }

    public void addCSS(String css) {
        this.mCSS = this.mCSS + css;
        this.setCSS(css);
    }

    public void clearCSS() {
        this.mCSS = "";
        this.setColor(this.mColor);
    }

    public void setPreserveAspectRatio(String preserveAspectRatio) {
        this.mPreserveAspectRatio = PreserveAspectRatio.of((String)preserveAspectRatio);
        if (this.mSVG != null) {
            this.mSVG.setDocumentPreserveAspectRatio(this.mPreserveAspectRatio);
        }
    }
}

