/*
 * Decompiled with CFR 0.152.
 */
package io.autodidact.mathjaxprovider;

import android.content.Context;
import android.util.Log;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.uimanager.ThemedReactContext;
import io.autodidact.mathjaxprovider.JavaScriptUtility;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class MathJaxProvider
extends WebView {
    public static String TAG = "MathJaxProvider";
    private ThemedReactContext mContext;
    private boolean loadingCompleted = false;
    private ArrayList<OnMessageListener> messageListeners = new ArrayList();
    private ArrayList<String> pendingScripts = new ArrayList();

    public MathJaxProvider(ThemedReactContext context) {
        super((Context)context);
        this.mContext = context;
        String html = this.evaluteFile("index.html");
        final String javascript = this.evaluteFile("dist/bundle.js");
        if (html != null) {
            this.getSettings().setJavaScriptEnabled(true);
            this.loadDataWithBaseURL("file://", html, "text/html", null, null);
            this.setWebViewClient(new WebViewClient(){

                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);
                    MathJaxProvider.this.evaluateJavascript(javascript, (ValueCallback)new ValueCallback<String>(){

                        public void onReceiveValue(String s) {
                            MathJaxProvider.this.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    MathJaxProvider.this.loadingCompleted = true;
                                    for (String script : MathJaxProvider.this.pendingScripts) {
                                        MathJaxProvider.this.evaluateJavascript(script, null);
                                    }
                                    MathJaxProvider.this.pendingScripts.clear();
                                }
                            }, 2000L);
                        }
                    });
                }
            });
            this.addJavascriptInterface(new JavaScriptUtility.WebViewBridge(this), "ReactNativeWebView");
        }
    }

    private String evaluteFile(String fileName) {
        try {
            String line;
            InputStream inputStream = this.mContext.getResources().getAssets().open(fileName);
            BufferedReader r = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder total = new StringBuilder(inputStream.available());
            while ((line = r.readLine()) != null) {
                total.append(line).append('\n');
            }
            return total.toString();
        }
        catch (IOException err) {
            Log.e((String)TAG, (String)("error loading file " + fileName));
            return null;
        }
    }

    public void postRequest(String math) {
        this.postRequest(math, new MathJaxOptions());
    }

    public void postRequest(String math, @NonNull MathJaxOptions options) {
        JSONObject o = options.toJSON();
        try {
            o.put("math", (Object)math);
        }
        catch (JSONException err) {
            Log.e((String)TAG, (String)"postRequest: ", (Throwable)err);
            return;
        }
        String script = "window.MathJaxProvider(" + o.toString() + ")";
        if (!this.loadingCompleted) {
            this.pendingScripts.add(script);
        } else {
            this.evaluateJavascript(script, null);
        }
    }

    protected void onMessage(String message) {
        try {
            JSONObject o = new JSONObject(message);
            if (o.has("error")) {
                this.throwError(o.get("error"));
                return;
            }
            String math = o.getString("speakText");
            String svg = o.getString("svg").replaceAll("xlink:xlink", "xlink");
            Double width = o.getDouble("measuredWidth");
            Double height = o.getDouble("measuredHeight");
            Double apprxWidth = o.getDouble("apprxWidth");
            Double apprxHeight = o.getDouble("apprxHeight");
            for (OnMessageListener listener : this.cloneMessageListeners()) {
                listener.invoke(math, svg, width, height, apprxWidth, apprxHeight);
            }
        }
        catch (JSONException err) {
            for (OnMessageListener listener : this.cloneMessageListeners()) {
                listener.reject(err);
            }
        }
    }

    private ArrayList<OnMessageListener> cloneMessageListeners() {
        ArrayList<OnMessageListener> copy = new ArrayList<OnMessageListener>();
        copy.addAll(this.messageListeners);
        return copy;
    }

    public void addOnMessageListener(OnMessageListener listener) {
        this.messageListeners.add(listener);
    }

    public void removeOnMessageListener(OnMessageListener listener) {
        this.messageListeners.remove(listener);
    }

    public void removeAllListeners() {
        for (OnMessageListener listener : this.messageListeners) {
            listener.reject();
        }
        this.messageListeners.clear();
    }

    public void throwError(Object error) {
        for (OnMessageListener listener : this.cloneMessageListeners()) {
            Exception e = new Exception(error.toString());
            e.fillInStackTrace();
            listener.reject(error);
        }
    }

    public OnMessageListener getOnMessageListener(int i) {
        return this.messageListeners.get(i);
    }

    public class MathJaxOptions {
        public boolean excludeTitle = true;
        public boolean parseSize = true;

        protected JSONObject toJSON() {
            JSONObject map = new JSONObject();
            try {
                map.put("excludeTitle", this.excludeTitle);
                map.put("parseSize", this.parseSize);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return map;
        }
    }

    public static interface OnMessageListener {
        public void invoke(String var1, String var2, double var3, double var5, @Nullable double var7, @Nullable double var9);

        public void reject();

        public void reject(Object var1);

        public void reject(Throwable var1);
    }
}

