/*
 * Decompiled with CFR 0.152.
 */
package io.autodidact.rnmathview;

import android.view.View;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;
import io.autodidact.rnmathview.SVGAttributes;
import javax.annotation.Nullable;

public class SVGShadowNode
extends LayoutShadowNode
implements YogaMeasureFunction {
    private String svg;
    private SVGAttributes svgAttributes = new SVGAttributes();

    SVGShadowNode() {
        this.initMeasureFunction();
    }

    private void initMeasureFunction() {
        this.setMeasureFunction(this);
    }

    @Deprecated
    private void invalidate() {
        UIManagerModule uiManager = (UIManagerModule)this.getThemedContext().getNativeModule(UIManagerModule.class);
        int tag = this.getReactTag();
        uiManager.invalidateNodeLayout(tag);
    }

    @ReactProp(name="svg")
    public void setSVG(String svg) {
        this.svg = svg;
        this.svgAttributes.setSVG(svg);
    }

    @ReactProp(name="config")
    public void setConfig(@Nullable ReadableMap config) {
        if (config == null) {
            return;
        }
        if (config.hasKey("ex")) {
            this.svgAttributes.setEX(config.getInt("ex"));
        }
    }

    public long measure(YogaNode node, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)((int)this.svgAttributes.width), (int)Integer.MIN_VALUE);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)((int)this.svgAttributes.height), (int)Integer.MIN_VALUE);
        int measuredWidth = View.resolveSize((int)((int)this.svgAttributes.width), (int)widthSpec);
        int measuredHeight = View.resolveSize((int)((int)this.svgAttributes.height), (int)heightSpec);
        return YogaMeasureOutput.make((int)measuredWidth, (int)measuredHeight);
    }
}

