/*
 * Decompiled with CFR 0.152.
 */
package com.paymentgateway;

import android.content.Context;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.midtrans.sdk.corekit.callback.TransactionFinishedCallback;
import com.midtrans.sdk.corekit.core.LocalDataHandler;
import com.midtrans.sdk.corekit.core.MidtransSDK;
import com.midtrans.sdk.corekit.core.SdkCoreFlowBuilder;
import com.midtrans.sdk.corekit.core.TransactionRequest;
import com.midtrans.sdk.corekit.core.themes.CustomColorTheme;
import com.midtrans.sdk.corekit.models.ItemDetails;
import com.midtrans.sdk.corekit.models.UserAddress;
import com.midtrans.sdk.corekit.models.UserDetail;
import com.midtrans.sdk.corekit.models.snap.CreditCard;
import com.midtrans.sdk.corekit.models.snap.TransactionResult;
import com.midtrans.sdk.uikit.SdkUIFlowBuilder;
import com.paymentgateway.TransactionCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MidtransModule
extends ReactContextBaseJavaModule {
    private static final int CORE_FLOW = 1;
    private static final int UI_FLOW = 2;
    private int mysdkFlow = 2;
    private String DEFAULT_TEXT = "open_sans_regular.ttf";
    private String SEMI_BOLD_TEXT = "open_sans_semibold.ttf";
    private String BOLD_TEXT = "open_sans_bold.ttf";
    private final ReactApplicationContext reactContext;

    public MidtransModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
    }

    public String getName() {
        return "MidtransModule";
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("card_click_normal", "Normal");
        constants.put("card_click_two_click", "Two Click");
        constants.put("card_click_one_click", "One Click");
        return constants;
    }

    @ReactMethod
    private void initSDK(String clientkey, String baseUrl) {
        if (this.mysdkFlow == 1) {
            SdkCoreFlowBuilder.init().setContext((Context)this.reactContext).setClientKey(clientkey).setMerchantBaseUrl(baseUrl).enableLog(true).buildSDK();
        } else {
            SdkUIFlowBuilder.init().setContext((Context)this.reactContext).setClientKey(clientkey).setMerchantBaseUrl(baseUrl).setTransactionFinishedCallback(new TransactionFinishedCallback(){

                public void onTransactionFinished(TransactionResult transactionResult) {
                }
            }).enableLog(true).buildSDK();
        }
    }

    @ReactMethod
    public void checkOut(ReadableMap optionConect, ReadableMap transRequest, ReadableArray itemDetails, ReadableMap creditCardOptions, ReadableMap mapUserDetail, ReadableMap optionColorTheme, ReadableMap optionFont, Callback resultCheckOut) {
        UserDetail userDetail = new UserDetail();
        userDetail.setUserFullName(mapUserDetail.getString("fullName"));
        userDetail.setEmail(mapUserDetail.getString("email"));
        userDetail.setPhoneNumber(mapUserDetail.getString("phoneNumber"));
        userDetail.setUserId(mapUserDetail.getString("userId"));
        ArrayList<UserAddress> userAddresses = new ArrayList<UserAddress>();
        UserAddress userAddress = new UserAddress();
        userAddress.setAddress(mapUserDetail.getString("address"));
        userAddress.setCity(mapUserDetail.getString("city"));
        userAddress.setCountry(mapUserDetail.getString("country"));
        userAddress.setZipcode(mapUserDetail.getString("zipCode"));
        userAddress.setAddressType(3);
        userAddresses.add(userAddress);
        CustomColorTheme colorTheme = new CustomColorTheme(optionColorTheme.getString("primary"), optionColorTheme.getString("primaryDark"), optionColorTheme.getString("secondary"));
        String defaultText = optionFont == null ? optionFont.getString("defaultText") : this.DEFAULT_TEXT;
        String semiBoldText = optionFont == null ? optionFont.getString("semiBoldText") : this.SEMI_BOLD_TEXT;
        String boldText = optionFont == null ? optionFont.getString("boldText") : this.BOLD_TEXT;
        SdkUIFlowBuilder.init().setContext((Context)this.reactContext).setClientKey(optionConect.getString("clientKey")).setMerchantBaseUrl(optionConect.getString("urlMerchant")).setTransactionFinishedCallback((TransactionFinishedCallback)new TransactionCallback(resultCheckOut)).enableLog(true).setDefaultText(defaultText).setSemiBoldText(semiBoldText).setBoldText(boldText).setColorTheme(colorTheme).buildSDK();
        userDetail.setUserAddresses(userAddresses);
        LocalDataHandler.saveObject((String)"user_details", (Object)userDetail);
        TransactionRequest transactionRequest = new TransactionRequest(transRequest.getString("transactionId"), (double)transRequest.getInt("totalAmount"));
        this.setItemDetail(itemDetails, transactionRequest);
        CreditCard ccOptions = new CreditCard();
        ccOptions.setSaveCard(creditCardOptions.getBoolean("saveCard"));
        ccOptions.setAuthentication("3ds");
        transactionRequest.setCreditCard(ccOptions);
        transactionRequest.setCardPaymentInfo(creditCardOptions.getString("paymentMode"), creditCardOptions.getBoolean("secure"));
        MidtransSDK.getInstance().setTransactionRequest(transactionRequest);
        MidtransSDK.getInstance().startPaymentUiFlow((Context)this.getCurrentActivity());
    }

    private void setItemDetail(ReadableArray itemDetails, TransactionRequest transactionRequest) {
        ArrayList<ItemDetails> itemDetailsList = new ArrayList<ItemDetails>();
        for (int a = 0; a < itemDetails.size(); ++a) {
            ReadableMap rmItem = itemDetails.getMap(a);
            String id = rmItem.getString("id");
            int price = rmItem.getInt("price");
            int qty = rmItem.getInt("qty");
            String name = rmItem.getString("name");
            itemDetailsList.add(new ItemDetails(id, (double)price, qty, name));
        }
        transactionRequest.setItemDetails(itemDetailsList);
    }
}

