/*
 * Decompiled with CFR 0.152.
 */
package com.hendrysetiadi.reactnative.mika;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.SparseArray;
import com.facebook.react.bridge.ActivityEventListener;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableNativeMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class RNMikaModule
extends ReactContextBaseJavaModule
implements ActivityEventListener {
    private final ReactApplicationContext reactContext;
    final SparseArray<Promise> mPromises;
    private String MIKA_PAYMENT_PACKAGE = "id.mikaapp.mika.charge";
    private String MIKA_VOID_PACKAGE = "id.mikaapp.mika.void";
    private String MIKA_PRINT_PACKAGE = "id.mikaapp.mika.print";
    private String MIKA_SETTLEMENT_PACKAGE = "id.mikaapp.mika.settlement";

    public RNMikaModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
        this.mPromises = new SparseArray();
    }

    public String getName() {
        return "RNMika";
    }

    @Nullable
    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("OK", -1);
        constants.put("CANCELED", 0);
        return constants;
    }

    public void initialize() {
        super.initialize();
        this.getReactApplicationContext().addActivityEventListener((ActivityEventListener)this);
    }

    public void onCatalystInstanceDestroy() {
        super.onCatalystInstanceDestroy();
        this.getReactApplicationContext().removeActivityEventListener((ActivityEventListener)this);
    }

    @ReactMethod
    public void startMikaPayment(int requestCode, String username, String password, String acquirerId, int amount, Promise promise) {
        Activity activity = this.getCurrentActivity();
        Intent intent = new Intent(this.MIKA_PAYMENT_PACKAGE);
        intent.putExtra("USERNAME", username);
        intent.putExtra("PASSWORD", password);
        intent.putExtra("AMOUNT", amount);
        intent.putExtra("ACQUIRER_ID", acquirerId);
        activity.startActivityForResult(intent, requestCode);
        this.mPromises.put(requestCode, (Object)promise);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Promise promise = (Promise)this.mPromises.get(requestCode);
        if (promise != null) {
            WritableNativeMap result = new WritableNativeMap();
            result.putInt("resultCode", resultCode);
            if (data != null && data.getExtras() != null) {
                result.putMap("data", Arguments.fromBundle((Bundle)data.getExtras()));
            }
            promise.resolve((Object)result);
        }
    }
}

