/*
 * Decompiled with CFR 0.152.
 */
package com.reactlibrary;

import android.util.Log;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.zgkxzx.modbus4And.requset.ModbusParam;
import com.zgkxzx.modbus4And.requset.ModbusReq;
import com.zgkxzx.modbus4And.requset.OnRequestBack;
import java.util.Arrays;

public class ModbusTcpModule
extends ReactContextBaseJavaModule {
    private final ReactApplicationContext reactContext;

    public ModbusTcpModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
    }

    public String getName() {
        return "ModbusTcp";
    }

    @ReactMethod
    public void sampleMethod(String stringArgument, int numberArgument, Callback callback) {
        callback.invoke(new Object[]{"Received numberArgument: " + numberArgument + " stringArgument: " + stringArgument});
    }

    @ReactMethod
    public void connectToModbusMaster(String ip, int port, final Callback cb) {
        ModbusReq.getInstance().setParam(new ModbusParam().setHost(ip).setPort(port).setEncapsulated(false).setKeepAlive(true).setTimeout(2000).setRetries(0)).init((OnRequestBack)new OnRequestBack<String>(){

            public void onSuccess(String s) {
                Log.d((String)"ContentValues", (String)("onSuccess " + s));
                cb.invoke(new Object[]{s.toString(), null});
            }

            public void onFailed(String msg) {
                Log.d((String)"ContentValues", (String)("onFailed " + msg));
                cb.invoke(new Object[]{msg.toString(), null});
            }
        });
    }

    @ReactMethod
    public void readCoil(int slaveid, int start, int len, final Callback cb) {
        ModbusReq.getInstance().readCoil((OnRequestBack)new OnRequestBack<boolean[]>(){

            public void onSuccess(boolean[] booleen) {
                Log.d((String)"ContentValues", (String)("readCoil onSuccess " + Arrays.toString(booleen)));
                cb.invoke(new Object[]{Arrays.toString(booleen), null});
            }

            public void onFailed(String msg) {
                Log.e((String)"ContentValues", (String)("readCoil onFailed " + msg));
                cb.invoke(new Object[]{msg, null});
            }
        }, slaveid, start, len);
    }

    @ReactMethod
    public void readDiscreteInput(int slaveid, int start, int len, final Callback cb) {
        ModbusReq.getInstance().readDiscreteInput((OnRequestBack)new OnRequestBack<boolean[]>(){

            public void onSuccess(boolean[] booleen) {
                Log.d((String)"ContentValues", (String)("readDiscreteInput onSuccess " + Arrays.toString(booleen)));
                cb.invoke(new Object[]{Arrays.toString(booleen), null});
            }

            public void onFailed(String msg) {
                Log.e((String)"ContentValues", (String)("readDiscreteInput onFailed " + msg));
                cb.invoke(new Object[]{msg, null});
            }
        }, slaveid, start, len);
    }

    @ReactMethod
    public void readHoldingRegisters(int slaveid, int start, int len, final Callback cb) {
        ModbusReq.getInstance().readHoldingRegisters((OnRequestBack)new OnRequestBack<short[]>(){

            public void onSuccess(short[] data) {
                Log.d((String)"ContentValues", (String)("readHoldingRegisters onSuccess " + Arrays.toString(data)));
                cb.invoke(new Object[]{Arrays.toString(data), null});
            }

            public void onFailed(String msg) {
                Log.e((String)"ContentValues", (String)("readHoldingRegisters onFailed " + msg));
                cb.invoke(new Object[]{msg, null});
            }
        }, slaveid, start, len);
    }

    @ReactMethod
    public void readInputRegisters(int slaveid, int start, int len, final Callback cb) {
        ModbusReq.getInstance().readInputRegisters((OnRequestBack)new OnRequestBack<short[]>(){

            public void onSuccess(short[] data) {
                Log.d((String)"ContentValues", (String)("readInputRegisters onSuccess " + Arrays.toString(data)));
                cb.invoke(new Object[]{Arrays.toString(data), null});
            }

            public void onFailed(String msg) {
                Log.e((String)"ContentValues", (String)("readInputRegisters onFailed " + msg));
                cb.invoke(new Object[]{msg, null});
            }
        }, slaveid, start, len);
    }

    @ReactMethod
    public void writeCoil(int slaveid, int offset, boolean value, final Callback cb) {
        ModbusReq.getInstance().writeCoil((OnRequestBack)new OnRequestBack<String>(){

            public void onSuccess(String s) {
                Log.e((String)"ContentValues", (String)("writeCoil onSuccess " + s));
                cb.invoke(new Object[]{s, null});
            }

            public void onFailed(String msg) {
                Log.e((String)"ContentValues", (String)("writeCoil onFailed " + msg));
                cb.invoke(new Object[]{msg, null});
            }
        }, slaveid, offset, value);
    }

    @ReactMethod
    public void writeCoils(int slaveid, int start, ReadableArray booleanArray, final Callback cb) {
        boolean[] values = new boolean[booleanArray.size()];
        for (int i = 0; i < booleanArray.size(); ++i) {
            values[i] = booleanArray.getBoolean(i);
        }
        ModbusReq.getInstance().writeCoils((OnRequestBack)new OnRequestBack<String>(){

            public void onSuccess(String s) {
                Log.e((String)"ContentValues", (String)("writeCoil onSuccess " + s));
                cb.invoke(new Object[]{s, null});
            }

            public void onFailed(String msg) {
                Log.e((String)"ContentValues", (String)("writeCoil onFailed " + msg));
                cb.invoke(new Object[]{msg, null});
            }
        }, slaveid, start, values);
    }

    @ReactMethod
    public void writeRegister(int slaveid, int offset, int value, final Callback cb) {
        ModbusReq.getInstance().writeRegister((OnRequestBack)new OnRequestBack<String>(){

            public void onSuccess(String s) {
                Log.e((String)"ContentValues", (String)("writeRegister onSuccess " + s));
                cb.invoke(new Object[]{s, null});
            }

            public void onFailed(String msg) {
                Log.e((String)"ContentValues", (String)("writeRegister onFailed " + msg));
                cb.invoke(new Object[]{msg, null});
            }
        }, slaveid, offset, value);
    }

    @ReactMethod
    public void writeRegisters(int slaveid, int start, ReadableArray readableMap, final Callback cb) {
        short[] inShort = new short[readableMap.size()];
        for (int i = 0; i < readableMap.size(); ++i) {
            inShort[i] = (short)readableMap.getInt(i);
        }
        ModbusReq.getInstance().writeRegisters((OnRequestBack)new OnRequestBack<String>(){

            public void onSuccess(String s) {
                Log.e((String)"ContentValues", (String)("writeRegisters onSuccess " + s));
                cb.invoke(new Object[]{s, null});
            }

            public void onFailed(String msg) {
                Log.e((String)"ContentValues", (String)("writeRegisters onFailed " + msg));
                cb.invoke(new Object[]{msg, null});
            }
        }, slaveid, start, inShort);
    }

    @ReactMethod
    public void destroyConnection(Callback cb) {
        ModbusReq.getInstance().destory();
        cb.invoke(new Object[]{"Connection destroyed"});
    }
}

