/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.payment;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.samsung.android.sdk.samsungpay.payment.CardInfo;
import com.samsung.android.sdk.samsungpay.payment.ISPaymentCallback;
import com.samsung.android.sdk.samsungpay.payment.PaymentInfo;
import java.util.ArrayList;
import java.util.List;

public interface ISPaymentManager
extends IInterface {
    public void initiateSession(String var1, String var2, PaymentInfo var3, ISPaymentCallback var4, IBinder var5) throws RemoteException;

    public void terminateSession() throws RemoteException;

    public int updateAmount(PaymentInfo.Amount var1) throws RemoteException;

    public int invalidAddress(int var1) throws RemoteException;

    public List<CardInfo> requestCardType() throws RemoteException;

    public boolean isSamsungPaySetupCompleted() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISPaymentManager {
        private static final String DESCRIPTOR = "com.samsung.android.sdk.samsungpay.payment.ISPaymentManager";
        static final int TRANSACTION_initiateSession = 1;
        static final int TRANSACTION_terminateSession = 2;
        static final int TRANSACTION_updateAmount = 3;
        static final int TRANSACTION_invalidAddress = 4;
        static final int TRANSACTION_requestCardType = 5;
        static final int TRANSACTION_isSamsungPaySetupCompleted = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISPaymentManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISPaymentManager) {
                return (ISPaymentManager)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    PaymentInfo _arg2 = 0 != data.readInt() ? (PaymentInfo)PaymentInfo.CREATOR.createFromParcel(data) : null;
                    ISPaymentCallback _arg3 = ISPaymentCallback.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg4 = data.readStrongBinder();
                    this.initiateSession(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.terminateSession();
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    PaymentInfo.Amount _arg0 = 0 != data.readInt() ? (PaymentInfo.Amount)PaymentInfo.Amount.CREATOR.createFromParcel(data) : null;
                    int _result = this.updateAmount(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.invalidAddress(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    List _result = this.requestCardType();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isSamsungPaySetupCompleted();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ISPaymentManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ISPaymentManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ISPaymentManager {
            private IBinder mRemote;
            public static ISPaymentManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initiateSession(String version, String pid, PaymentInfo request, ISPaymentCallback callback, IBinder binder) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(version);
                    _data.writeString(pid);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeStrongBinder(binder);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().initiateSession(version, pid, request, callback, binder);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void terminateSession() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().terminateSession();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int updateAmount(PaymentInfo.Amount amount) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (amount != null) {
                        _data.writeInt(1);
                        amount.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().updateAmount(amount);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int invalidAddress(int errorcode) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(errorcode);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().invalidAddress(errorcode);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<CardInfo> requestCardType() throws RemoteException {
                ArrayList _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<CardInfo> list = Stub.getDefaultImpl().requestCardType();
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(CardInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSamsungPaySetupCompleted() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isSamsungPaySetupCompleted();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ISPaymentManager {
        @Override
        public void initiateSession(String version, String pid, PaymentInfo request, ISPaymentCallback callback, IBinder binder) throws RemoteException {
        }

        @Override
        public void terminateSession() throws RemoteException {
        }

        @Override
        public int updateAmount(PaymentInfo.Amount amount) throws RemoteException {
            return 0;
        }

        @Override
        public int invalidAddress(int errorcode) throws RemoteException {
            return 0;
        }

        @Override
        public List<CardInfo> requestCardType() throws RemoteException {
            return null;
        }

        @Override
        public boolean isSamsungPaySetupCompleted() throws RemoteException {
            return false;
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

