/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.payment;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.payment.CardInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@Deprecated
public class PaymentInfo
implements Parcelable {
    private static final String VERSION_V1 = "1.0.03";
    private String version = "1.0.03";
    private Amount amount;
    private Address shippingAddress;
    private String merchantId;
    private String merchantName;
    private String orderNumber;
    private PaymentProtocol paymentProtocol;
    private AddressInPaymentSheet addressInPaymentSheet = AddressInPaymentSheet.DO_NOT_SHOW;
    private List<CardInfo.Brand> allowedCardBrand;
    private boolean isGiftCardPurchase = false;
    private CardInfo.Brand cardBrand;
    private boolean isCardHolderNameRequired = false;
    private boolean isRecurring = false;
    private String merchantCountryCode;
    public static final Parcelable.Creator<PaymentInfo> CREATOR = new Parcelable.Creator<PaymentInfo>(){

        @NonNull
        public PaymentInfo createFromParcel(@NonNull Parcel source) {
            return new PaymentInfo(source);
        }

        @NonNull
        public PaymentInfo[] newArray(int size) {
            return new PaymentInfo[size];
        }
    };

    private PaymentInfo(@NonNull Builder builder) {
        this.amount = builder.amount;
        this.shippingAddress = builder.shippingAddress;
        this.merchantId = builder.merchantId;
        this.merchantName = builder.merchantName;
        this.orderNumber = builder.orderNumber;
        this.paymentProtocol = builder.paymentProtocol;
        this.addressInPaymentSheet = builder.addressInPaymentSheet;
        this.allowedCardBrand = builder.allowedCardBrand;
        this.isGiftCardPurchase = builder.isGiftCardPurchase;
        this.cardBrand = builder.cardBrand;
        this.isCardHolderNameRequired = builder.isCardHolderNameRequired;
        this.isRecurring = builder.isRecurring;
        this.merchantCountryCode = builder.merchantCountryCode;
    }

    public PaymentInfo(@NonNull Parcel source) {
        this.version = (String)source.readValue(String.class.getClassLoader());
        this.amount = (Amount)source.readParcelable(Amount.class.getClassLoader());
        this.shippingAddress = (Address)source.readParcelable(Address.class.getClassLoader());
        this.merchantId = (String)source.readValue(String.class.getClassLoader());
        this.merchantName = (String)source.readValue(String.class.getClassLoader());
        this.orderNumber = (String)source.readValue(String.class.getClassLoader());
        this.paymentProtocol = (PaymentProtocol)((Object)source.readValue(PaymentProtocol.class.getClassLoader()));
        this.addressInPaymentSheet = (AddressInPaymentSheet)((Object)source.readValue(AddressInPaymentSheet.class.getClassLoader()));
        this.allowedCardBrand = new ArrayList<CardInfo.Brand>();
        source.readTypedList(this.allowedCardBrand, CardInfo.Brand.CREATOR);
        this.isGiftCardPurchase = (Boolean)source.readValue(Boolean.class.getClassLoader());
        this.cardBrand = (CardInfo.Brand)((Object)source.readValue(CardInfo.Brand.class.getClassLoader()));
        this.isCardHolderNameRequired = (Boolean)source.readValue(Boolean.class.getClassLoader());
        this.isRecurring = (Boolean)source.readValue(Boolean.class.getClassLoader());
        this.merchantCountryCode = (String)source.readValue(String.class.getClassLoader());
    }

    public Amount getAmount() {
        return this.amount;
    }

    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    @Deprecated
    public PaymentProtocol getPaymentProtocol() {
        return this.paymentProtocol;
    }

    public AddressInPaymentSheet getAddressInPaymentSheet() {
        return this.addressInPaymentSheet;
    }

    public List<CardInfo.Brand> getAllowedCardBrands() {
        return this.allowedCardBrand;
    }

    public CardInfo.Brand getCardBrand() {
        return this.cardBrand;
    }

    public boolean getIsGiftCardPurchase() {
        return this.isGiftCardPurchase;
    }

    public boolean getIsCardHolderNameRequired() {
        return this.isCardHolderNameRequired;
    }

    public boolean getIsRecurring() {
        return this.isRecurring;
    }

    public String getMerchantCountryCode() {
        return this.merchantCountryCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeValue((Object)this.version);
        dest.writeParcelable((Parcelable)this.amount, 0);
        dest.writeParcelable((Parcelable)this.shippingAddress, 0);
        dest.writeValue((Object)this.merchantId);
        dest.writeValue((Object)this.merchantName);
        dest.writeValue((Object)this.orderNumber);
        dest.writeValue((Object)this.paymentProtocol);
        dest.writeValue((Object)this.addressInPaymentSheet);
        dest.writeTypedList(this.allowedCardBrand);
        dest.writeValue((Object)this.isGiftCardPurchase);
        dest.writeValue((Object)this.cardBrand);
        dest.writeValue((Object)this.isCardHolderNameRequired);
        dest.writeValue((Object)this.isRecurring);
        dest.writeValue((Object)this.merchantCountryCode);
    }

    @Deprecated
    public static class Builder {
        private Amount amount;
        private Address shippingAddress;
        private String merchantId;
        private String merchantName;
        private String orderNumber;
        private PaymentProtocol paymentProtocol;
        private AddressInPaymentSheet addressInPaymentSheet;
        private List<CardInfo.Brand> allowedCardBrand = new ArrayList<CardInfo.Brand>();
        private boolean isGiftCardPurchase;
        private CardInfo.Brand cardBrand;
        private boolean isCardHolderNameRequired;
        private boolean isRecurring;
        private String merchantCountryCode;

        @NonNull
        public Builder setAmount(Amount amount) {
            this.amount = amount;
            return this;
        }

        @NonNull
        public Builder setShippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        @NonNull
        public Builder setMerchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        @NonNull
        public Builder setMerchantName(String merchantName) {
            this.merchantName = merchantName;
            return this;
        }

        @NonNull
        public Builder setOrderNumber(String orderNumber) {
            this.orderNumber = orderNumber;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setPaymentProtocol(PaymentProtocol paymentProtocol) {
            this.paymentProtocol = paymentProtocol;
            return this;
        }

        @NonNull
        public Builder setAddressInPaymentSheet(AddressInPaymentSheet addressInPaymentSheet) {
            this.addressInPaymentSheet = addressInPaymentSheet;
            return this;
        }

        @NonNull
        public Builder setAllowedCardBrands(List<CardInfo.Brand> brands) {
            this.allowedCardBrand = brands;
            return this;
        }

        @NonNull
        public Builder cardBrand(CardInfo.Brand cardBrand) {
            this.cardBrand = cardBrand;
            return this;
        }

        @NonNull
        public PaymentInfo build() {
            return new PaymentInfo(this);
        }
    }

    @Deprecated
    public static enum AddressInPaymentSheet implements Parcelable
    {
        DO_NOT_SHOW,
        NEED_BILLING_SPAY,
        NEED_SHIPPING_SPAY,
        SEND_SHIPPING,
        NEED_BILLING_SEND_SHIPPING,
        NEED_BILLING_AND_SHIPPING;

        public static final Parcelable.Creator<AddressInPaymentSheet> CREATOR;

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<AddressInPaymentSheet>(){

                public AddressInPaymentSheet createFromParcel(@NonNull Parcel in) {
                    return AddressInPaymentSheet.values()[in.readInt()];
                }

                @Nullable
                public AddressInPaymentSheet[] newArray(int size) {
                    return null;
                }
            };
        }
    }

    @Deprecated
    public static class Amount
    implements Parcelable {
        private String version;
        private String currencyCode;
        private String itemTotalPrice;
        private String tax;
        private String shippingPrice;
        private String totalPrice;
        public static final Parcelable.Creator<Amount> CREATOR = new Parcelable.Creator<Amount>(){

            @NonNull
            public Amount createFromParcel(@NonNull Parcel source) {
                return new Amount(source);
            }

            @NonNull
            public Amount[] newArray(int size) {
                return new Amount[size];
            }
        };

        public Amount(@NonNull Parcel source) {
            this.version = (String)source.readValue(String.class.getClassLoader());
            this.currencyCode = (String)source.readValue(String.class.getClassLoader());
            this.itemTotalPrice = (String)source.readValue(String.class.getClassLoader());
            this.tax = (String)source.readValue(String.class.getClassLoader());
            this.shippingPrice = (String)source.readValue(String.class.getClassLoader());
            this.totalPrice = (String)source.readValue(String.class.getClassLoader());
        }

        public String getCurrencyCode() {
            return this.currencyCode;
        }

        public String getItemTotalPrice() {
            return this.itemTotalPrice;
        }

        public String getTax() {
            return this.tax;
        }

        public String getShippingPrice() {
            return this.shippingPrice;
        }

        public String getTotalPrice() {
            return this.totalPrice;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeValue((Object)this.version);
            dest.writeValue((Object)this.currencyCode);
            dest.writeValue((Object)this.itemTotalPrice);
            dest.writeValue((Object)this.tax);
            dest.writeValue((Object)this.shippingPrice);
            dest.writeValue((Object)this.totalPrice);
        }
    }

    @Deprecated
    public static class Address
    implements Parcelable {
        private String version;
        private String addressee;
        private String addressLine1;
        private String addressLine2;
        private String city;
        private String state;
        private String countryCode;
        private String postalCode;
        public static final Parcelable.Creator<Address> CREATOR = new Parcelable.Creator<Address>(){

            @NonNull
            public Address createFromParcel(@NonNull Parcel source) {
                return new Address(source);
            }

            @NonNull
            public Address[] newArray(int size) {
                return new Address[size];
            }
        };

        private Address(@NonNull Builder builder) {
            this.version = PaymentInfo.VERSION_V1;
            this.addressee = builder.addressee;
            this.addressLine1 = builder.addressLine1;
            this.addressLine2 = builder.addressLine2;
            this.city = builder.city;
            this.state = builder.state;
            this.countryCode = builder.countryCode;
            this.postalCode = builder.postalCode;
        }

        public Address(@NonNull Parcel source) {
            this.version = (String)source.readValue(String.class.getClassLoader());
            this.addressee = (String)source.readValue(String.class.getClassLoader());
            this.addressLine1 = (String)source.readValue(String.class.getClassLoader());
            this.addressLine2 = (String)source.readValue(String.class.getClassLoader());
            this.city = (String)source.readValue(String.class.getClassLoader());
            this.state = (String)source.readValue(String.class.getClassLoader());
            this.countryCode = (String)source.readValue(String.class.getClassLoader());
            this.postalCode = (String)source.readValue(String.class.getClassLoader());
        }

        public String getAddressee() {
            return this.addressee;
        }

        public String getAddressLine1() {
            return this.addressLine1;
        }

        public String getAddressLine2() {
            return this.addressLine2;
        }

        public String getCity() {
            return this.city;
        }

        public String getState() {
            return this.state;
        }

        public String getCountryCode() {
            return this.countryCode;
        }

        public String getPostalCode() {
            return this.postalCode;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeValue((Object)this.version);
            dest.writeValue((Object)this.addressee);
            dest.writeValue((Object)this.addressLine1);
            dest.writeValue((Object)this.addressLine2);
            dest.writeValue((Object)this.city);
            dest.writeValue((Object)this.state);
            dest.writeValue((Object)this.countryCode);
            dest.writeValue((Object)this.postalCode);
        }

        @Deprecated
        public static class Builder {
            private String addressee;
            private String addressLine1;
            private String addressLine2;
            private String city;
            private String state;
            private String countryCode;
            private String postalCode;

            @NonNull
            public Builder setAddressee(String addressee) {
                this.addressee = addressee;
                return this;
            }

            @NonNull
            public Builder setAddressLine1(String addressLine1) {
                this.addressLine1 = addressLine1;
                return this;
            }

            @NonNull
            public Builder setAddressLine2(String addressLine2) {
                this.addressLine2 = addressLine2;
                return this;
            }

            @NonNull
            public Builder setCity(String city) {
                this.city = city;
                return this;
            }

            @NonNull
            public Builder setState(String state) {
                this.state = state;
                return this;
            }

            public Builder setCountryCode(String countryCode) {
                Locale[] localeList;
                if (countryCode == null) {
                    throw new NullPointerException("countryCode is null");
                }
                if (countryCode.isEmpty()) {
                    throw new IllegalArgumentException("countryCode is empty");
                }
                for (Locale locale : localeList = Locale.getAvailableLocales()) {
                    try {
                        if (!locale.getDisplayCountry().equals(countryCode)) continue;
                        this.countryCode = countryCode;
                        return this;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new IllegalArgumentException(countryCode + "countryCode is invalid ");
            }

            @NonNull
            public Builder setPostalCode(String postalCode) {
                this.postalCode = postalCode;
                return this;
            }

            @NonNull
            public Address build() {
                return new Address(this);
            }
        }
    }

    @Deprecated
    public static enum PaymentProtocol implements Parcelable
    {
        PROTOCOL_3DS,
        PROTOCOL_EMV,
        PROTOCOL_COF,
        PROTOCOL_OTHER;

        public static final Parcelable.Creator<PaymentProtocol> CREATOR;

        @NonNull
        public static PaymentProtocol convert(String type) {
            if ((type = type.toUpperCase(Locale.US)).contains("3DS")) {
                return PROTOCOL_3DS;
            }
            if (type.contains("EMV")) {
                return PROTOCOL_EMV;
            }
            return PROTOCOL_OTHER;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<PaymentProtocol>(){

                public PaymentProtocol createFromParcel(@NonNull Parcel in) {
                    return PaymentProtocol.values()[in.readInt()];
                }

                @NonNull
                public PaymentProtocol[] newArray(int size) {
                    return new PaymentProtocol[size];
                }
            };
        }
    }
}

