/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2;

import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.CheckApiLevel;
import com.samsung.android.sdk.samsungpay.v2.ParamInfo;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;
import com.samsung.android.sdk.samsungpay.v2.WatchManager;
import com.samsung.android.sdk.samsungpay.v2.card.AddCardInfo;
import com.samsung.android.sdk.samsungpay.v2.card.Card;
import com.samsung.android.sdk.samsungpay.v2.card.IdvVerifyInfo;
import com.samsung.android.sdk.samsungpay.v2.card.TransitCard;
import com.samsung.android.sdk.samsungpay.v2.payment.PaymentManager;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.AmountConstants;
import com.samsung.android.sdk.samsungpay.v2.service.RequestType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;

public class ApiLevelTable {
    public static final String TAG = "SPAYSDK:ApiLevelTable";
    private static ApiLevelTable sInstance;
    @NonNull
    private HashMap<String, FieldInfo> mStaticFieldTable = new HashMap();
    @NonNull
    private HashMap<String, ArrayList<String>> mClassVariableTable = new HashMap();
    private SpaySdk.SdkApiLevel mPartnerDefinedApiLevel = SpaySdk.SdkApiLevel.LEVEL_UNKNOWN;
    private static final Class[] STATIC_FIELD_MAPPING_CLASS;
    private static final Class[] VARIABLE_CHECKING_CLASS;

    private ApiLevelTable() {
        for (Class sdkClass : STATIC_FIELD_MAPPING_CLASS) {
            this.createStaticFieldTable(sdkClass);
        }
        for (Class checkingClass : VARIABLE_CHECKING_CLASS) {
            this.createClassVariableTable(checkingClass);
        }
    }

    @NonNull
    public static synchronized ApiLevelTable getInstance() {
        if (sInstance == null) {
            sInstance = new ApiLevelTable();
        }
        return sInstance;
    }

    public void setPartnerDefinedApiLevel(SpaySdk.SdkApiLevel apiLevel) {
        this.mPartnerDefinedApiLevel = apiLevel;
    }

    public SpaySdk.SdkApiLevel getPartnerDefinedApiLevel() {
        return this.mPartnerDefinedApiLevel;
    }

    private void createStaticFieldTable(@NonNull Class c) {
        Field[] fields;
        for (Field fld : fields = c.getDeclaredFields()) {
            ParamInfo parameterInfo = fld.getAnnotation(ParamInfo.class);
            if (parameterInfo == null) continue;
            try {
                String fieldVal;
                if (fld.getType() == String.class) {
                    fieldVal = fld.get(c).toString();
                } else {
                    if (!fld.getType().isEnum()) continue;
                    fieldVal = this.createStringKeyForEnum(fld.get(c));
                }
                FieldInfo fieldInfo = new FieldInfo(fld.getName(), parameterInfo);
                if (this.mStaticFieldTable.containsKey(fieldVal)) {
                    this.throwException("Field " + fieldInfo + " with value '" + fieldVal + "' is defined twice");
                    continue;
                }
                this.mStaticFieldTable.put(fieldVal, fieldInfo);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void createClassVariableTable(@NonNull Class c) {
        Field[] fields = c.getDeclaredFields();
        ArrayList<String> list = new ArrayList<String>();
        try {
            for (Field fld : fields) {
                fld.setAccessible(true);
                if (fld.getAnnotation(CheckApiLevel.class) == null) continue;
                Log.v((String)TAG, (String)("createClassVariableTable - " + c.getSimpleName() + ": field: " + fld.getName()));
                if (fld.getType() != String.class && fld.getType() != Bundle.class) {
                    this.throwException("Only String and Bundle variable are supported");
                    continue;
                }
                list.add(fld.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!list.isEmpty()) {
            this.mClassVariableTable.put(c.getSimpleName(), list);
        }
    }

    public boolean valueNotDefinedInPartnerApiLevel(@Nullable Object targetObj) {
        if (targetObj == null) {
            return false;
        }
        if (targetObj.getClass().isEnum()) {
            targetObj = this.createStringKeyForEnum(targetObj);
        }
        if (targetObj instanceof String) {
            String key = (String)targetObj;
            if (!TextUtils.isEmpty((CharSequence)key) && this.mStaticFieldTable.containsKey(key)) {
                FieldInfo fieldInfo = this.mStaticFieldTable.get(key);
                if (fieldInfo.apiLevel.compareTo(this.mPartnerDefinedApiLevel) > 0) {
                    Log.e((String)TAG, (String)("Parameter: " + fieldInfo.toString() + " is not defined in " + (Object)((Object)this.mPartnerDefinedApiLevel)));
                    return true;
                }
            }
        } else if (targetObj instanceof Bundle) {
            Bundle bundle = (Bundle)targetObj;
            for (String key : bundle.keySet()) {
                FieldInfo fieldInfo = this.mStaticFieldTable.get(key);
                if (fieldInfo == null) continue;
                if (this.valueNotDefinedInPartnerApiLevel(key)) {
                    return true;
                }
                if (!fieldInfo.checkValue) continue;
                Log.v((String)TAG, (String)("Checking value for " + fieldInfo));
                String val = bundle.getString(key, null);
                if (!this.valueNotDefinedInPartnerApiLevel(val)) continue;
                return true;
            }
        } else {
            this.throwException("Not checking support for " + targetObj.getClass());
        }
        return false;
    }

    public boolean findFieldContainsNotDefinedValue(@Nullable Object targetObj) {
        if (targetObj == null) {
            Log.e((String)TAG, (String)"findFieldContainsNotDefinedValue - param is NULL");
            return false;
        }
        if (!this.mClassVariableTable.containsKey(targetObj.getClass().getSimpleName())) {
            this.throwException("Not checking support for " + targetObj.getClass());
            return false;
        }
        Class<?> cls = targetObj.getClass();
        ArrayList<String> list = this.mClassVariableTable.get(cls.getSimpleName());
        try {
            for (String checkingField : list) {
                Field fld = cls.getDeclaredField(checkingField);
                fld.setAccessible(true);
                if (fld.getType() != String.class && fld.getType() != Bundle.class || !this.valueNotDefinedInPartnerApiLevel(fld.get(targetObj))) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void throwException(String msg) {
        Log.e((String)TAG, (String)msg);
    }

    @NonNull
    private String createStringKeyForEnum(@Nullable Object enumField) {
        if (enumField == null || !enumField.getClass().isEnum()) {
            this.throwException(enumField + "is not an enum");
            return "";
        }
        return enumField.getClass().getSimpleName() + "." + enumField.toString();
    }

    static {
        STATIC_FIELD_MAPPING_CLASS = new Class[]{SpaySdk.class, PaymentManager.class, WatchManager.class, AddCardInfo.class, Card.class, TransitCard.class, IdvVerifyInfo.class, AmountConstants.class, ((Object)((Object)RequestType.ALL)).getClass()};
        VARIABLE_CHECKING_CLASS = new Class[]{AddCardInfo.class};
    }

    private static class FieldInfo {
        SpaySdk.SdkApiLevel apiLevel;
        boolean checkValue;
        String name;

        public FieldInfo(String fieldName, @NonNull ParamInfo paramInfo) {
            this.apiLevel = paramInfo.since();
            this.checkValue = paramInfo.checkValue();
            this.name = fieldName;
        }

        @NonNull
        public String toString() {
            return this.name + " (since: " + (Object)((Object)this.apiLevel) + ")";
        }
    }
}

