/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2;

import android.util.Log;
import java.util.Timer;
import java.util.TimerTask;

abstract class BindRetry {
    private static final String TAG = "SPAYSDK:BindRetry";
    private long SPAY_BIND_TIMEOUT = 30000L;
    private static final int BIND_COUNTER_MAX = 4;
    protected boolean isScheduled;
    private final Object scheduleLock = new Object();
    private int mBindCounter;
    private BindRetryTimerTask bindRetryTimerTask;

    abstract void runTimer();

    protected BindRetry(long timeOut) {
        if (timeOut > 0L) {
            this.SPAY_BIND_TIMEOUT = timeOut;
        }
        this.init();
    }

    protected BindRetry() {
        this.init();
    }

    private void init() {
        this.isScheduled = false;
        this.mBindCounter = 4;
    }

    protected boolean isOverCounter() {
        return this.getBindCounter() <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getBindCounter() {
        Object object = this.scheduleLock;
        synchronized (object) {
            return this.mBindCounter;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Cannot clone instance of this class");
    }

    private void setIsScheduled(boolean scheduled) {
        this.isScheduled = scheduled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isScheduled() {
        Object object = this.scheduleLock;
        synchronized (object) {
            return this.isScheduled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean scheduleBindTimer() {
        Log.d((String)TAG, (String)"scheduleBindTimer: scheduling bind timer");
        Object object = this.scheduleLock;
        synchronized (object) {
            if (this.isOverCounter()) {
                this.releaseBindTimerTask();
                return false;
            }
            --this.mBindCounter;
            Log.d((String)TAG, (String)("scheduleBindTimer: count = " + this.mBindCounter));
            try {
                this.bindRetryTimerTask = new BindRetryTimerTask();
                new Timer().schedule((TimerTask)this.bindRetryTimerTask, this.SPAY_BIND_TIMEOUT);
                this.setIsScheduled(true);
                return true;
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)"scheduleBindTimer: Exception in scheduling bind timer ");
                e.printStackTrace();
                this.setIsScheduled(false);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseBindTimerTask() {
        Log.d((String)TAG, (String)"releaseBindTimerTask: cleanup binder timer");
        Object object = this.scheduleLock;
        synchronized (object) {
            try {
                if (this.bindRetryTimerTask.cancel()) {
                    Log.d((String)TAG, (String)"releaseBindTimerTask: timerTask cancel return true ");
                } else {
                    Log.d((String)TAG, (String)"releaseBindTimerTask: timerTask cancel return false ");
                }
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)"releaseBindTimerTask: Exception in canceling bind timer ");
                e.printStackTrace();
            }
            finally {
                this.init();
            }
        }
    }

    protected class BindRetryTimerTask
    extends TimerTask {
        protected BindRetryTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Log.d((String)BindRetry.TAG, (String)"run : BindRetryTimerTask");
            Object object = BindRetry.this.scheduleLock;
            synchronized (object) {
                BindRetry.this.isScheduled = false;
            }
            BindRetry.this.runTimer();
        }
    }
}

