/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2;

import android.content.ActivityNotFoundException;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import com.samsung.android.sdk.samsungpay.v2.ErrorType;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;
import com.samsung.android.sdk.samsungpay.v2.StubBase;
import com.samsung.android.sdk.samsungpay.v2.WatchManager;

public class PartnerRequest {
    private final String TAG = "SPAYSDK:PartnerRequest";
    public int operation;
    public Object obj1;
    public Object obj2;
    public Object obj3;
    public Object callbackObj;
    public Object[] checkApiLevelParams;
    private PartnerRequestState mState;
    public boolean needStub = true;
    public boolean checkDuplication = false;
    public String name = "unknown";
    public boolean isWatch = false;
    public SpaySdk owner;
    public SpaySdk.SdkApiLevel apiLevel = SpaySdk.SdkApiLevel.LEVEL_UNKNOWN;
    public boolean isCancelled = false;
    private ErrorCatcher mErrorCatcher;
    private RequestExecutor mRequestExecutor;
    @NonNull
    private static Handler sMainThreadHandler = new Handler(Looper.getMainLooper());

    public PartnerRequest(int operation, Object callbackObj) {
        this.operation = operation;
        this.callbackObj = callbackObj;
        this.mState = PartnerRequestState.NONE;
    }

    public PartnerRequest(int operation, Object obj1, Object callbackObj) {
        this.operation = operation;
        this.obj1 = obj1;
        this.callbackObj = callbackObj;
        this.mState = PartnerRequestState.NONE;
    }

    public PartnerRequest(int operation, Object obj1, Object obj2, Object callbackObj) {
        this.operation = operation;
        this.obj1 = obj1;
        this.obj2 = obj2;
        this.callbackObj = callbackObj;
        this.mState = PartnerRequestState.NONE;
    }

    public PartnerRequest(int operation, Object obj1, Object obj2, Object obj3, Object callbackObj) {
        this.operation = operation;
        this.obj1 = obj1;
        this.obj2 = obj2;
        this.obj3 = obj3;
        this.callbackObj = callbackObj;
        this.mState = PartnerRequestState.NONE;
    }

    public void setState(PartnerRequestState state) {
        this.mState = state;
    }

    public PartnerRequestState getState() {
        return this.mState;
    }

    public boolean isPartnerRequestProcessing() {
        return this.mState == PartnerRequestState.PROCESSING;
    }

    public void execute(@NonNull StubBase stubBase) {
        if (this.mRequestExecutor != null) {
            Runnable requestExecuteRunnable = () -> {
                try {
                    Log.d((String)"SPAYSDK:PartnerRequest", (String)("Processing request:  " + this.name));
                    Object stubInterface = stubBase.getStub();
                    if (stubInterface == null && this.needStub) {
                        Log.e((String)"SPAYSDK:PartnerRequest", (String)"Can't execute request because Stub is null");
                        throw new RemoteException();
                    }
                    this.setDefinedApiLevelToPartnerInfo();
                    this.mRequestExecutor.handleRequest((IInterface)stubInterface, this);
                }
                catch (RemoteException e) {
                    Log.e((String)"SPAYSDK:PartnerRequest", (String)("RemoteException while executing request: " + e.toString()));
                    this.catchError(ErrorType.REMOTE_EXCEPTION, -103, new Bundle());
                    stubBase.nextRequest();
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e((String)"SPAYSDK:PartnerRequest", (String)("NameNotFoundException while executing request: " + e.toString()));
                    this.catchError(ErrorType.NAME_NOT_FOUND_EXCEPTION, -103, new Bundle());
                    stubBase.nextRequest();
                }
                catch (Exception e) {
                    Log.e((String)"SPAYSDK:PartnerRequest", (String)"Unknown exception while executing request: ");
                    e.printStackTrace();
                    this.catchError(ErrorType.REMOTE_EXCEPTION, -103, new Bundle());
                    stubBase.nextRequest();
                }
            };
            if (Looper.myLooper() == Looper.getMainLooper()) {
                requestExecuteRunnable.run();
            } else {
                sMainThreadHandler.post(requestExecuteRunnable);
            }
        } else {
            Log.e((String)"SPAYSDK:PartnerRequest", (String)"No request handler");
        }
    }

    public void catchError(ErrorType errorType, int errorCode, Bundle extraError) {
        this.printErrorLog(errorType, errorCode);
        if (this.mErrorCatcher != null) {
            sMainThreadHandler.post(() -> this.mErrorCatcher.onError(errorType, errorCode, extraError));
        } else {
            Log.e((String)"SPAYSDK:PartnerRequest", (String)("No error catcher: errorType: " + (Object)((Object)errorType) + " - errorCode: " + errorCode));
        }
    }

    private void setDefinedApiLevelToPartnerInfo() {
        Bundle pInfoBundle = this.owner.partnerInfo.getData();
        if (pInfoBundle == null) {
            pInfoBundle = new Bundle();
            this.owner.partnerInfo.setData(pInfoBundle);
        }
        if (this.apiLevel == SpaySdk.SdkApiLevel.LEVEL_UNKNOWN) {
            throw new IllegalArgumentException("Api Level defined in manifest is empty");
        }
        pInfoBundle.putString("PartnerSdkApiLevel", this.apiLevel.getLevel());
    }

    private void printErrorLog(ErrorType errorType, int errorCode) {
        Log.e((String)"SPAYSDK:PartnerRequest", (String)(this.name + " - error: " + (Object)((Object)errorType) + ", " + errorCode));
    }

    public static interface RequestExecutor {
        public void handleRequest(IInterface var1, PartnerRequest var2) throws RemoteException, ActivityNotFoundException, PackageManager.NameNotFoundException;
    }

    public static interface ErrorCatcher {
        public void onError(ErrorType var1, int var2, Bundle var3);
    }

    public static enum PartnerRequestState {
        NONE,
        PROCESSING,
        SESSION;

    }

    public static class Builder {
        private PartnerRequest partnerRequest;

        public Builder(SpaySdk owner, int operation, Object callbackObj) {
            this.partnerRequest = new PartnerRequest(operation, callbackObj);
            this.partnerRequest.owner = owner;
            if (owner instanceof WatchManager) {
                this.partnerRequest.isWatch = true;
            }
        }

        @NonNull
        public Builder setObj1(Object obj) {
            this.partnerRequest.obj1 = obj;
            return this;
        }

        @NonNull
        public Builder setObj2(Object obj) {
            this.partnerRequest.obj2 = obj;
            return this;
        }

        @NonNull
        public Builder setName(String name) {
            this.partnerRequest.name = name;
            return this;
        }

        @NonNull
        public Builder checkApiLevelFor(Object ... parameters) {
            this.partnerRequest.checkApiLevelParams = parameters;
            return this;
        }

        @NonNull
        public Builder needStub(boolean needStub) {
            this.partnerRequest.needStub = needStub;
            return this;
        }

        @NonNull
        public Builder checkDuplication(boolean check) {
            this.partnerRequest.checkDuplication = check;
            return this;
        }

        @NonNull
        public Builder onError(ErrorCatcher errorCatcher) {
            this.partnerRequest.mErrorCatcher = errorCatcher;
            return this;
        }

        @NonNull
        public Builder onExecute(RequestExecutor requestExecutor) {
            this.partnerRequest.mRequestExecutor = requestExecutor;
            return this;
        }

        public PartnerRequest create() {
            return this.partnerRequest;
        }
    }
}

