/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.IInterface;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.ISSamsungPay;
import com.samsung.android.sdk.samsungpay.v2.PartnerInfo;
import com.samsung.android.sdk.samsungpay.v2.PartnerRequest;
import com.samsung.android.sdk.samsungpay.v2.SamsungPayBase;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;
import com.samsung.android.sdk.samsungpay.v2.Status;
import com.samsung.android.sdk.samsungpay.v2.StatusListener;
import com.samsung.android.sdk.samsungpay.v2.StubBase;
import java.util.List;

public final class SamsungPay
extends SamsungPayBase {
    public SamsungPay(Context context, PartnerInfo partnerInfo) {
        super(context, partnerInfo, "com.samsung.android.spay");
        TAG = "SPAYSDK:SamsungPay";
    }

    @Override
    protected StubBase<IInterface> createStub(Context context) {
        return new StubBase.Creator<IInterface>().createStub(context, "com.samsung.android.spay.sdk.v2.service.CommonAppService", ISSamsungPay.Stub::asInterface);
    }

    public void getSamsungPayStatus(StatusListener listener) {
        super.getSamsungPayStatus(listener, MANDATORY_SDK_API_LEVEL);
    }

    public void goToUpdatePage() {
        super.goToUpdatePage(SpaySdk.SdkApiLevel.LEVEL_1_2);
    }

    @Override
    protected void checkValidListener(@Nullable StatusListener listener) {
        if (listener == null) {
            String reason = "Cb is null.You should set first.";
            Log.e((String)TAG, (String)("checkValidListener: " + reason));
            throw new NullPointerException(reason);
        }
    }

    public void activateSamsungPay() {
        super.activateSamsungPay(SpaySdk.SdkApiLevel.LEVEL_1_1);
    }

    public void getWalletInfo(List<String> keys, StatusListener listener) {
        super.getWalletInfo(keys, listener, SpaySdk.SdkApiLevel.LEVEL_1_2);
    }

    @Override
    protected void doGetWalletInfo(@NonNull IInterface stub, @NonNull PartnerRequest request) throws RemoteException {
        SamsungPayBase.StatusListenerInternal statusListenerInternal = (SamsungPayBase.StatusListenerInternal)request.obj2;
        List keys = (List)request.obj1;
        ((ISSamsungPay)stub).getWalletInfo(this.getPartnerInfo(), keys, statusListenerInternal.getStatusListener());
    }

    @Override
    protected void doGetSamsungPayStatus(@NonNull IInterface stub, @NonNull PartnerRequest request) throws RemoteException {
        Status st = ((ISSamsungPay)stub).getSamsungPayStatus(this.getPartnerInfo());
        if (st != null) {
            int status = st.getStatus();
            switch (status) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    ((StatusListener)request.callbackObj).onSuccess(status, st.getData());
                    break;
                }
                default: {
                    ((StatusListener)request.callbackObj).onFail(status, st.getData());
                }
            }
        }
        this.mSamsungPayBaseStub.nextRequest();
    }

    @Override
    protected void doGoToUpdatePage() throws PackageManager.NameNotFoundException {
        Log.d((String)TAG, (String)"goToUpdatePage");
        Context liveContext = (Context)this.contextRef.get();
        if (liveContext != null) {
            PackageInfo packageInfo = liveContext.getPackageManager().getPackageInfo(this.mPackageName, 0);
            int CurrentSpayVersionCode = packageInfo.versionCode / 100000;
            Intent intent = new Intent();
            if (CurrentSpayVersionCode >= 2100) {
                String uriString = "samsungpay://launch?action=aboutsamsungpay";
                intent.setAction("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)uriString));
            } else {
                Intent samsungPayLauncherActivity = liveContext.getPackageManager().getLaunchIntentForPackage(this.mPackageName);
                String className = samsungPayLauncherActivity.getComponent().getClassName();
                intent.setComponent(new ComponentName(this.mPackageName, className));
            }
            intent.addFlags(0x10008000);
            liveContext.startActivity(intent);
        } else {
            Log.e((String)TAG, (String)"doGoToUpdatePage - Context is null");
        }
        this.mSamsungPayBaseStub.nextRequest();
    }

    public void getSamsungPayTransitStatus(@NonNull StatusListener listener) {
        Log.d((String)TAG, (String)"getSamsungPayTransitStatus()");
        this.assertNotNull(listener);
        SamsungPayBase.StatusListenerInternal listenerInternal = new SamsungPayBase.StatusListenerInternal(this);
        PartnerRequest pReq = new PartnerRequest.Builder(this, 21, listener).setName("getSamsungPayTransitStatus").setObj1(listenerInternal).onExecute(this::doGetSamsungPayTransitStatus).onError((errorType, errorCode, errorExtra) -> listener.onFail(errorCode, errorExtra)).create();
        this.mSamsungPayBaseStub.postRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_2_8);
        listenerInternal.set(pReq);
    }

    private void doGetSamsungPayTransitStatus(@NonNull IInterface stub, @NonNull PartnerRequest request) throws RemoteException {
        SamsungPayBase.StatusListenerInternal statusListenerInternal = (SamsungPayBase.StatusListenerInternal)request.obj1;
        ((ISSamsungPay)stub).getSamsungPayTransitStatus(this.getPartnerInfo(), statusListenerInternal.getStatusListener());
    }
}

