/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.ErrorType;
import com.samsung.android.sdk.samsungpay.v2.ISStatusListener;
import com.samsung.android.sdk.samsungpay.v2.PartnerInfo;
import com.samsung.android.sdk.samsungpay.v2.PartnerRequest;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;
import com.samsung.android.sdk.samsungpay.v2.StatusListener;
import com.samsung.android.sdk.samsungpay.v2.StubBase;
import java.lang.ref.WeakReference;
import java.util.List;

public abstract class SamsungPayBase
extends SpaySdk {
    @NonNull
    protected static String TAG = "SPAYSDK:SamsungPayBase";
    private static final int OPT_GET_SPAY_STATUS = 0;
    private static final int OPT_ACTIVATE_SPAY = 1;
    private static final int OPT_GET_WALLET_INFO = 2;
    private static final int OPT_GO_TO_UPDATE_PAGE = 3;
    static final int OPT_GET_ALL_CARDS = 10;
    static final int OPT_ADD_CARD = 11;
    static final int OPT_GET_TRANSIT_STATUS = 21;
    protected StubBase<IInterface> mSamsungPayBaseStub;
    protected String mPackageName;
    @NonNull
    private Handler mHandlerForInternalListener = new Handler(Looper.getMainLooper()){

        public void handleMessage(@NonNull Message msg) {
            switch (msg.what) {
                case 0: {
                    ((StatusListener)msg.obj).onSuccess(msg.arg1, msg.getData());
                    break;
                }
                case 1: {
                    ((StatusListener)msg.obj).onFail(msg.arg1, msg.getData());
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    Log.e((String)TAG, (String)"sdk can not catch listener from SPay.");
                }
            }
        }
    };

    protected SamsungPayBase(Context context, PartnerInfo partnerInfo, String packageName) {
        super(context, partnerInfo);
        Log.d((String)TAG, (String)("Partner SDK version : " + SamsungPayBase.getVersionName()));
        if (!this.isValidContextAndServiceId(partnerInfo)) {
            throw new NullPointerException("Context and PartnerInfo.serviceId have to be set.");
        }
        this.mSamsungPayBaseStub = this.createStub(context);
        this.mPackageName = packageName;
    }

    protected abstract StubBase<IInterface> createStub(Context var1);

    protected void getSamsungPayStatus(@NonNull StatusListener listener, SpaySdk.SdkApiLevel apiLevel) {
        Log.d((String)TAG, (String)"getSamsungPayStatus()");
        this.assertNotNull(listener);
        PartnerRequest pReq = new PartnerRequest.Builder(this, 0, listener).setName("getSamsungPayStatus").onExecute((stub, request) -> this.doGetSamsungPayStatus(stub, request)).onError((errorType, errorCode, errorExtra) -> {
            if (errorType == ErrorType.SPAY_VALIDITY_FAIL) {
                listener.onSuccess(errorCode, errorExtra);
            } else if (errorType == ErrorType.PARTNER_INFO_INVALID) {
                listener.onFail(-99, errorExtra);
            } else {
                listener.onFail(-103, errorExtra);
            }
        }).create();
        this.mSamsungPayBaseStub.postRequest(pReq, apiLevel);
    }

    protected abstract void doGetSamsungPayStatus(IInterface var1, PartnerRequest var2) throws RemoteException;

    protected void goToUpdatePage(SpaySdk.SdkApiLevel apiLevel) {
        Log.d((String)TAG, (String)"goToUpdatePage()");
        PartnerRequest pReq = new PartnerRequest.Builder(this, 3, null).setName("goToUpdatePage").needStub(false).onExecute((stub, request) -> this.doGoToUpdatePage()).create();
        this.mSamsungPayBaseStub.postRequest(pReq, apiLevel);
    }

    protected void activateSamsungPay(SpaySdk.SdkApiLevel apiLevel) {
        Log.d((String)TAG, (String)"activateSamsungPay()");
        PartnerRequest pReq = new PartnerRequest.Builder(this, 1, null).setName("activateSamsungPay").needStub(false).onExecute((stub, request) -> this.doActivateSamsungPay()).create();
        this.mSamsungPayBaseStub.postRequest(pReq, apiLevel);
    }

    protected void getWalletInfo(List<String> keys, @NonNull StatusListener listener, SpaySdk.SdkApiLevel apiLevel) {
        Log.d((String)TAG, (String)"getWalletInfo()");
        this.assertNotNull(listener);
        this.assertNotNull(keys);
        StatusListenerInternal listenerInternal = new StatusListenerInternal();
        PartnerRequest pReq = new PartnerRequest.Builder(this, 2, listener).setName("getWalletInfo").setObj1(keys).setObj2(listenerInternal).onExecute(this::doGetWalletInfo).onError((errorType, errorCode, errorExtra) -> listener.onFail(errorCode, errorExtra)).create();
        this.mSamsungPayBaseStub.postRequest(pReq, apiLevel);
        listenerInternal.set(pReq);
    }

    protected abstract void doGetWalletInfo(IInterface var1, PartnerRequest var2) throws RemoteException;

    private void sendMsgForStatusListener(@Nullable WeakReference<PartnerRequest> requestRef, int result, int arg1, Bundle data) {
        PartnerRequest request;
        if (requestRef == null || (request = (PartnerRequest)requestRef.get()) == null) {
            Log.e((String)TAG, (String)"sendMsgForStatusListener - request is NULL");
            return;
        }
        Message message = Message.obtain((Handler)this.mHandlerForInternalListener);
        message.obj = request.callbackObj;
        message.what = result;
        message.arg1 = arg1;
        message.setData(data);
        this.mHandlerForInternalListener.sendMessage(message);
    }

    private void doActivateSamsungPay() {
        Intent intent = new Intent();
        Context liveContext = (Context)this.contextRef.get();
        if (liveContext != null) {
            Intent samsungPayLauncherActivity = liveContext.getPackageManager().getLaunchIntentForPackage(this.mPackageName);
            String className = samsungPayLauncherActivity.getComponent().getClassName();
            intent.setComponent(new ComponentName(this.mPackageName, className));
            intent.setFlags(0x10000000);
            intent.putExtra("activate_sp_from_sdk", true);
            Log.d((String)TAG, (String)"ACTIVATE_SP_FROM_SDK");
            liveContext.startActivity(intent);
        } else {
            Log.e((String)TAG, (String)"doActivateSamsungPay - Context is null");
        }
        this.mSamsungPayBaseStub.nextRequest();
    }

    protected abstract void doGoToUpdatePage() throws PackageManager.NameNotFoundException;

    protected void setServicePackage(String servicePackage) {
        this.mSamsungPayBaseStub.setServicePackage(servicePackage);
    }

    protected void checkValidListener(@Nullable StatusListener listener) {
        if (listener == null) {
            String reason = "Cb is null.You should set first.";
            Log.e((String)TAG, (String)("checkValidListener: " + reason));
            throw new NullPointerException(reason);
        }
    }

    protected class StatusListenerInternal {
        private static final String TAG = "StatusListenerInternal";
        @Nullable
        private WeakReference<PartnerRequest> pReqRef = null;
        @NonNull
        private SpayStatusListener spayStatusListener = new SpayStatusListener();

        protected StatusListenerInternal() {
        }

        public void set(PartnerRequest pReq) {
            this.pReqRef = new WeakReference<PartnerRequest>(pReq);
        }

        public ISStatusListener getStatusListener() {
            return this.spayStatusListener;
        }

        private class SpayStatusListener
        extends ISStatusListener.Stub {
            private SpayStatusListener() {
            }

            @Override
            public void onSuccess(PartnerInfo pInfo, int status, Bundle data) throws RemoteException {
                Log.d((String)StatusListenerInternal.TAG, (String)("onSuccess: status: " + status));
                SamsungPayBase.this.sendMsgForStatusListener(StatusListenerInternal.this.pReqRef, 0, status, data);
                SamsungPayBase.this.mSamsungPayBaseStub.nextRequest();
            }

            @Override
            public void onFail(PartnerInfo pInfo, int errorCode, Bundle errorData) throws RemoteException {
                Log.e((String)StatusListenerInternal.TAG, (String)("onFail: errorCode: " + errorCode));
                SamsungPayBase.this.sendMsgForStatusListener(StatusListenerInternal.this.pReqRef, 1, errorCode, errorData);
                SamsungPayBase.this.mSamsungPayBaseStub.nextRequest();
            }
        }
    }
}

