/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.BindRetry;
import com.samsung.android.sdk.samsungpay.v2.ISPartnerAppDeathDetector;

public class ServiceHelper {
    private static final String TAG = "SPAYSDK:ServiceHelper";
    private Context context;
    private ServiceCallback serviceCallback;
    private String servicePackage = "";
    @Nullable
    private IBinder serviceBinder = null;
    @NonNull
    private String serviceAction = "";
    protected BindRetry bindRetry;
    private long bindTimeOut = 0L;
    @NonNull
    private ServiceConnection serviceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, @NonNull IBinder binder) {
            if (!ServiceHelper.this.bindRetry.isOverCounter()) {
                Log.i((String)ServiceHelper.TAG, (String)("service connected : " + binder.toString()));
                ServiceHelper.this.setServiceBinder(binder);
                ServiceHelper.this.serviceCallback.onReceived(binder);
            } else {
                Log.e((String)ServiceHelper.TAG, (String)"service timeouted");
            }
            ServiceHelper.this.bindRetry.releaseBindTimerTask();
        }

        public void onServiceDisconnected(ComponentName name) {
            Log.i((String)ServiceHelper.TAG, (String)"service disconnected");
            ServiceHelper.this.releaseServiceBinder();
            ServiceHelper.this.bindRetry.releaseBindTimerTask();
            ServiceHelper.this.serviceCallback.onDisconnected();
        }
    };

    protected ServiceHelper(@NonNull Context context) {
        this.init(context);
    }

    protected void init(@NonNull Context context) {
        this.context = context.getApplicationContext();
        this.servicePackage = "com.samsung.android.spay";
    }

    public IBinder getServiceBinder() {
        return this.serviceBinder;
    }

    public void setServiceBinder(IBinder serviceBinder) {
        this.serviceBinder = serviceBinder;
    }

    protected void setServicePackage(String servicePackage) {
        this.servicePackage = servicePackage;
    }

    protected void createService(@NonNull ServiceCallback callback, @NonNull String action) {
        this.serviceCallback = callback;
        this.serviceAction = action;
        this.bindRetry = new BindRetry(this.bindTimeOut){

            @Override
            void runTimer() {
                if (this.isOverCounter()) {
                    Log.i((String)ServiceHelper.TAG, (String)"Samsung Pay bind timeout and max retry is reached. Quit");
                    ServiceHelper.this.serviceCallback.onFailed(BindingResult.CANNOT_BIND);
                } else {
                    Log.i((String)ServiceHelper.TAG, (String)"Samsung Pay bind timeout. Binder not available. trying again.");
                    BindingResult result = ServiceHelper.this.bindService();
                    ServiceHelper.this.callbackBindingResult(ServiceHelper.this.serviceCallback, result);
                }
            }
        };
        BindingResult result = this.bindService();
        this.callbackBindingResult(this.serviceCallback, result);
    }

    protected void callbackBindingResult(@NonNull ServiceCallback callback, @NonNull BindingResult result) {
        switch (result) {
            case BINDING_SERVICE: {
                Log.d((String)TAG, (String)"request to bind");
                break;
            }
            case BINDING_SERVICE_ALREADY: {
                Log.i((String)TAG, (String)"request to bind already");
                break;
            }
            case CANNOT_BIND: {
                Log.e((String)TAG, (String)"pay app service is not available");
                callback.onFailed(result);
                break;
            }
            case EXIST_BINDER: {
                Log.i((String)TAG, (String)"exist binder.");
                callback.onReceived(this.getServiceBinder());
                break;
            }
            default: {
                Log.e((String)TAG, (String)"must not come into here.");
                callback.onFailed(result);
            }
        }
    }

    protected synchronized boolean isValidServiceBinder() {
        IBinder binder = this.getServiceBinder();
        if (binder != null && binder.isBinderAlive()) {
            return true;
        }
        this.releaseServiceBinder();
        return false;
    }

    @NonNull
    private synchronized BindingResult bindService() {
        if (this.isValidServiceBinder()) {
            this.bindRetry.releaseBindTimerTask();
            return BindingResult.EXIST_BINDER;
        }
        if (this.bindRetry.isScheduled()) {
            Log.d((String)TAG, (String)"bindService already attempted, waiting.");
            return BindingResult.BINDING_SERVICE_ALREADY;
        }
        if (this.isValidAction()) {
            Log.w((String)TAG, (String)"action is null, need to call createService before it.");
            return BindingResult.CANNOT_BIND;
        }
        Intent i = new Intent(this.serviceAction);
        i.setPackage(this.servicePackage);
        ISPartnerAppDeathDetector.Stub mDeathDetectorBinder = new ISPartnerAppDeathDetector.Stub(){};
        Bundle b = new Bundle();
        b.putBinder("deathDetectorBinder", (IBinder)mDeathDetectorBinder);
        i.putExtras(b);
        if (this.bindRetry.scheduleBindTimer()) {
            boolean ret = this.context.bindService(i, this.serviceConnection, 65);
            if (ret) {
                Log.d((String)TAG, (String)("Service bind attempted and waiting for onConnect, from " + this.context));
                return BindingResult.BINDING_SERVICE;
            }
            this.bindRetry.releaseBindTimerTask();
        }
        return BindingResult.CANNOT_BIND;
    }

    protected synchronized void unbindService() {
        if (this.isValidServiceBinder()) {
            Log.d((String)TAG, (String)("! unbindService from " + this.context));
            try {
                this.context.unbindService(this.serviceConnection);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("unbindService - e : " + e.getMessage()));
            }
        }
        this.releaseServiceBinder();
    }

    protected void releaseServiceBinder() {
        this.serviceBinder = null;
    }

    private boolean isValidAction() {
        return "".equals(this.serviceAction);
    }

    protected void setBindTimeOut(long timeOut) {
        Log.w((String)TAG, (String)"setBindTimeOut is for instrument testcases");
        this.bindTimeOut = timeOut;
    }

    public Context getContext() {
        return this.context;
    }

    public static enum BindingResult {
        EXIST_BINDER,
        BINDING_SERVICE,
        BINDING_SERVICE_ALREADY,
        CANNOT_BIND,
        DISCONNECTED_SERVICE;

    }

    public static interface ServiceCallback {
        public void onReceived(IBinder var1);

        public void onFailed(BindingResult var1);

        public void onDisconnected();
    }
}

