/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.ApiLevelTable;
import com.samsung.android.sdk.samsungpay.v2.PartnerInfo;
import com.samsung.android.sdk.samsungpay.v2.PartnerRequest;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;
import com.samsung.android.sdk.samsungpay.v2.StatusListener;
import com.samsung.android.sdk.samsungpay.v2.VersionChecker;
import com.samsung.android.sdk.samsungpay.v2.card.GetCardListener;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.AmountBoxControl;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.CustomSheet;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetControl;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetItem;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

public final class SpayValidity {
    private static final String TAG = "SPAYSDK:SpayValidity";
    private final int MIN_SUPPORTED_CA_VERSION = 203710006;
    public static final int ERROR_NONE_INTERNAL = -999;
    private Context context;
    private String mBrand;
    private String mManufacture;
    private String mSpayPackageName;
    private String mSpayServiceName;
    private boolean mIsWatch = false;
    protected SpaySdk.SdkApiLevel mPartnerDefinedSdkApiLevel = SpaySdk.SdkApiLevel.LEVEL_UNKNOWN;
    protected static SpaySdk.SdkApiLevel sPartnerManifestApiLevel = SpaySdk.SdkApiLevel.LEVEL_UNKNOWN;
    protected PackageInfo spayPackageInfo = new PackageInfo();

    protected void setSpayPackageInfo(PackageInfo pInfo) {
        this.spayPackageInfo = pInfo;
    }

    protected PackageInfo getSpayPackageInfo() {
        return this.spayPackageInfo;
    }

    public SpayValidity(Context context) {
        this.init(context);
    }

    public SpayValidity(Context context, boolean isWatch) {
        this.mIsWatch = isWatch;
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.mBrand = Build.BRAND;
        this.mManufacture = Build.MANUFACTURER;
        this.loadDefinedSdkApiLevelInManifest();
        this.mSpayPackageName = this.mIsWatch ? "com.samsung.android.samsungpay.gear" : "com.samsung.android.spay";
        this.mSpayServiceName = this.mIsWatch ? "com.samsung.android.samsungpay.gear.sdk.v2.service.SPaySDKV2Service" : "com.samsung.android.spay.sdk.v2.service.SPaySDKV2Service";
    }

    protected String getSpayPackageName() {
        return this.mSpayPackageName;
    }

    protected void setSpayPackageName(String packageName) {
        this.mSpayPackageName = packageName;
    }

    protected String getSpayServiceName() {
        return this.mSpayServiceName;
    }

    protected void setSpayServiceName(String serviceName) {
        this.mSpayServiceName = serviceName;
    }

    public int getSpayValidity(@NonNull PartnerInfo pInfo, SpaySdk.SdkApiLevel usingSdkApiLevel, @NonNull PartnerRequest request) {
        String country;
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method methods = clazz.getMethod("get", String.class);
            Object value = methods.invoke(clazz, "ro.csc.countryiso_code");
            country = (String)value;
        }
        catch (Exception e) {
            e.printStackTrace();
            country = "";
        }
        country = country.toUpperCase(Locale.US);
        if (!this.isSupportedSpay()) {
            Log.i((String)TAG, (String)"[FAIL] Spay Local validity check");
            return this.getSpayLocalValidity();
        }
        Log.i((String)TAG, (String)"[PASS] Spay Local validity check");
        if (this.mIsWatch && !this.isSupportedCA()) {
            Log.i((String)TAG, (String)"[FAIL] CA version validity check");
            return -357;
        }
        Log.i((String)TAG, (String)"[PASS] CA version validity check");
        if (!this.isIntactSpay()) {
            Log.i((String)TAG, (String)"[FAIL] Spay integrity check");
            return -360;
        }
        Log.i((String)TAG, (String)"[PASS] Spay integrity check");
        if (this.isNeedUpgradeSpay(country, this.getSpayPackageInfo().versionCode / 100000)) {
            Log.i((String)TAG, (String)"[FAIL] Minimum Spay app version check");
            return -357;
        }
        Log.i((String)TAG, (String)"[PASS] Minimum Spay app version check");
        if (!this.canFindSdkService(this.getSpayPackageName(), this.getSpayServiceName())) {
            Log.i((String)TAG, (String)"[FAIL] Spay SDK service check");
            return -356;
        }
        Log.i((String)TAG, (String)"[PASS] Spay SDK service check");
        if (!this.isValidPartnerServiceType(pInfo.getData())) {
            Log.i((String)TAG, (String)"[FAIL] Defined Service Type check");
            return -11;
        }
        Log.i((String)TAG, (String)"[PASS] Defined Service Type check");
        if (!this.isSupportedAndroidPlatform(country, pInfo.getData())) {
            Log.i((String)TAG, (String)"[FAIL] Minimum Android Platform version check");
            return -361;
        }
        Log.i((String)TAG, (String)"[PASS] Minimum Android Platform version check");
        if (!this.isValidPartnerSdkApiLevel()) {
            Log.i((String)TAG, (String)"[FAIL] Defined SDK API Level check");
            return -10;
        }
        Log.i((String)TAG, (String)"[PASS] Defined SDK API Level check");
        if (!this.isValidUsingSdkApiLevel(usingSdkApiLevel)) {
            Log.i((String)TAG, (String)"[FAIL] Using SDK API Level check");
            return -10;
        }
        Log.i((String)TAG, (String)"[PASS] Using SDK API Level check");
        if (this.containsNotDefinedField(request)) {
            Log.i((String)TAG, (String)"[FAIL] Using parameters Level check");
            return -10;
        }
        Log.i((String)TAG, (String)"[PASS] Using parameters Level check");
        return -999;
    }

    protected int errorCodeToReadyStatus(int errorCode) {
        int readyStatus = 0;
        switch (errorCode) {
            case -361: 
            case -360: 
            case -352: 
            case -351: 
            case -350: {
                readyStatus = 0;
                break;
            }
            case -357: 
            case -356: {
                readyStatus = 1;
                break;
            }
            case -358: 
            case -11: 
            case -10: {
                readyStatus = -99;
                break;
            }
            case -999: {
                readyStatus = 2;
                break;
            }
            default: {
                Log.e((String)TAG, (String)("sdk can not catch spay status. " + this.getSpayLocalValidity()));
            }
        }
        return readyStatus;
    }

    protected void callbackResult(Object callback, int errorCode) {
        int readyStatus = this.errorCodeToReadyStatus(errorCode);
        Bundle extraErrorData = new Bundle();
        extraErrorData.putInt("errorReason", errorCode);
        if (callback instanceof StatusListener) {
            StatusListener mStatusListener = (StatusListener)callback;
            mStatusListener.onSuccess(readyStatus, extraErrorData);
        } else if (callback instanceof GetCardListener) {
            GetCardListener mGetCardListener = (GetCardListener)callback;
            mGetCardListener.onFail(readyStatus, extraErrorData);
        } else {
            Log.e((String)TAG, (String)"sdk can not catch result callback.");
        }
    }

    protected void setBuildBrand(String brand) {
        this.mBrand = brand;
    }

    protected String getBuildBrand() {
        return this.mBrand;
    }

    protected void setBuildManufacture(String manufacture) {
        this.mManufacture = manufacture;
    }

    protected String getBuildManufacture() {
        return this.mManufacture;
    }

    protected boolean isSamsungDevice() {
        String strBrand = this.getBuildBrand();
        String strManufacturer = this.getBuildManufacture();
        return "Samsung".compareToIgnoreCase(strBrand) == 0 || "Samsung".compareToIgnoreCase(strManufacturer) == 0;
    }

    protected int getSpayLocalValidity() {
        if (!this.mIsWatch && !this.isSamsungDevice()) {
            Log.i((String)TAG, (String)"This is not Samsung device.");
            return -350;
        }
        if (this.canFindSpayPackage(this.getSpayPackageName())) {
            return 999;
        }
        Log.i((String)TAG, (String)"SamsungPay package is not exist.");
        return -351;
    }

    protected boolean canFindSpayPackage(String packageName) {
        PackageManager pm = this.context.getPackageManager();
        try {
            this.setSpayPackageInfo(pm.getPackageInfo(packageName, 1));
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.i((String)TAG, (String)"Unable to find Samsung Pay application on the device");
            return false;
        }
        return true;
    }

    protected boolean isSupportedSpay() {
        return this.getSpayLocalValidity() == 999;
    }

    protected boolean canFindSdkService(@NonNull String packageName, @NonNull String serviceName) {
        try {
            PackageManager pm = this.context.getPackageManager();
            ComponentName componentName = new ComponentName(packageName, serviceName);
            pm.getServiceInfo(componentName, 4);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"can not find spay app or service");
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    protected boolean isNeedUpgradeSpay(String countryAlpha2, int versionCode) {
        if (this.mIsWatch) {
            if (173000006 < this.getSpayPackageInfo().versionCode) {
                return false;
            }
        } else {
            VersionChecker verCheck = new VersionChecker();
            if (!verCheck.wasReleasedSpayAppExcludeVersionCheck(countryAlpha2)) {
                return false;
            }
            if (verCheck.isIncludeVersionCheckingRule(countryAlpha2, versionCode)) {
                return false;
            }
        }
        Log.w((String)TAG, (String)"SamsungPay App is old version. SamsungPay App needs to be updated.");
        return true;
    }

    private boolean isIntactSpay() {
        boolean platformSigned;
        if (this.mIsWatch) {
            return this.isValidWatchPlugInSignature();
        }
        PackageManager pm = this.context.getPackageManager();
        boolean bl = platformSigned = pm.checkSignatures("android", "com.samsung.android.spay") == 0;
        if (!platformSigned) {
            Log.e((String)TAG, (String)"Spay has no integrity.");
        }
        return platformSigned;
    }

    private boolean isSupportedCA() {
        boolean result = false;
        if (this.spayPackageInfo != null) {
            Log.d((String)TAG, (String)("CA versionCode = " + this.spayPackageInfo.versionCode));
            result = this.spayPackageInfo.versionCode >= 203710006;
        }
        Log.d((String)TAG, (String)("isSupportedCA = " + result));
        return result;
    }

    protected boolean isValidPartnerServiceType(@NonNull Bundle pInfoBundle) {
        try {
            String partnerServiceType = pInfoBundle.getString("PartnerServiceType", "");
            Log.i((String)TAG, (String)("Partner defined Service Type : " + partnerServiceType));
            for (SpaySdk.ServiceType type : SpaySdk.ServiceType.values()) {
                if (!partnerServiceType.equals(type.toString())) continue;
                return true;
            }
            Log.e((String)TAG, (String)"Partner service type is not valid. Refer SpaySdk.ServiceType enum.");
            return false;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"Fail to validate Partner service type.");
            return false;
        }
    }

    protected boolean isSupportedAndroidPlatform(String countryAlpha2, @NonNull Bundle pInfoData) {
        int androidVersionCode = Build.VERSION.SDK_INT;
        String parterServiceType = pInfoData.getString("PartnerServiceType", "");
        Log.d((String)TAG, (String)("[isAndroidPlaformAvailable] Device country code : " + countryAlpha2));
        Log.d((String)TAG, (String)("[isAndroidPlaformAvailable] Android Platform API Level : " + androidVersionCode));
        Log.d((String)TAG, (String)("[isAndroidPlaformAvailable] Partner Service Type : " + parterServiceType));
        if (!"KR".equalsIgnoreCase(countryAlpha2) && !"CN".equalsIgnoreCase(countryAlpha2) && androidVersionCode < 23 && SpaySdk.ServiceType.INAPP_PAYMENT.toString().equals(parterServiceType)) {
            Log.e((String)TAG, (String)"Android Platform M is minimum for SamsungPay SDK.");
            return false;
        }
        if (androidVersionCode < 21) {
            Log.e((String)TAG, (String)"Android Platform L is minimum for SamsungPay SDK.");
            return false;
        }
        return true;
    }

    protected boolean isValidPartnerSdkApiLevel() {
        try {
            SpaySdk.SdkApiLevel partnerDefinedApiLevel = this.mPartnerDefinedSdkApiLevel;
            SpaySdk.SdkApiLevel maxSdkApiLevel = SpaySdk.SdkApiLevel.findSdkApiLevel("2.22.00".substring(0, "2.22.00".lastIndexOf(".")));
            VersionChecker verCheck = new VersionChecker();
            if (!verCheck.isValidSdkApiLevel(partnerDefinedApiLevel, maxSdkApiLevel)) {
                return false;
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"Fail to validate SDK API Level.");
            return false;
        }
        return true;
    }

    protected boolean isValidUsingSdkApiLevel(SpaySdk.SdkApiLevel usingSdkApiLevel) {
        try {
            VersionChecker verCheck = new VersionChecker();
            if (!verCheck.isValidSdkApiLevel(usingSdkApiLevel, this.mPartnerDefinedSdkApiLevel)) {
                return false;
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"Fail to validate SDK API Level.");
            return false;
        }
        return true;
    }

    protected boolean containsNotDefinedField(@NonNull PartnerRequest request) {
        if (request.checkApiLevelParams == null) {
            return false;
        }
        for (Object parameter : request.checkApiLevelParams) {
            if (parameter == null || !this.notDefinedInPartnerApiLevel(parameter)) continue;
            return true;
        }
        return false;
    }

    private boolean notDefinedInPartnerApiLevel(Object parameter) {
        if (parameter instanceof String || parameter instanceof Bundle || parameter.getClass().isEnum()) {
            if (ApiLevelTable.getInstance().valueNotDefinedInPartnerApiLevel(parameter)) {
                return true;
            }
        } else if (parameter instanceof CustomSheet) {
            for (SheetControl sheetControl : ((CustomSheet)parameter).getSheetControls()) {
                if (!(sheetControl instanceof AmountBoxControl)) continue;
                for (SheetItem item : ((AmountBoxControl)sheetControl).getItems()) {
                    if (!ApiLevelTable.getInstance().valueNotDefinedInPartnerApiLevel(item.getSValue())) continue;
                    return true;
                }
            }
        } else if (parameter.getClass().isArray()) {
            for (Object subParam : (Object[])parameter) {
                if (!this.notDefinedInPartnerApiLevel(subParam)) continue;
                return true;
            }
        } else if (ApiLevelTable.getInstance().findFieldContainsNotDefinedValue(parameter)) {
            return true;
        }
        return false;
    }

    public SpaySdk.SdkApiLevel getSdkApiLevelInManifest() {
        return this.mPartnerDefinedSdkApiLevel;
    }

    private void loadDefinedSdkApiLevelInManifest() {
        this.mPartnerDefinedSdkApiLevel = SpayValidity.readPartnerApiLevelInManifest(this.context);
        ApiLevelTable.getInstance().setPartnerDefinedApiLevel(this.mPartnerDefinedSdkApiLevel);
        Log.i((String)TAG, (String)("Partner defined SDK API Level : " + (Object)((Object)this.mPartnerDefinedSdkApiLevel)));
    }

    public static SpaySdk.SdkApiLevel readPartnerApiLevelInManifest(@NonNull Context context) {
        if (sPartnerManifestApiLevel != SpaySdk.SdkApiLevel.LEVEL_UNKNOWN) {
            return sPartnerManifestApiLevel;
        }
        PackageManager mPackageManager = context.getPackageManager();
        String pkgName = context.getPackageName();
        try {
            ApplicationInfo ai = mPackageManager.getApplicationInfo(pkgName, 128);
            String apiLevel = String.valueOf(ai.metaData.getFloat("spay_sdk_api_level"));
            sPartnerManifestApiLevel = SpaySdk.SdkApiLevel.findSdkApiLevel(apiLevel);
            return sPartnerManifestApiLevel;
        }
        catch (PackageManager.NameNotFoundException | NullPointerException e) {
            throw new IllegalStateException("Failed to load SDK API Level in Application Manifest" + e.toString());
        }
    }

    private boolean isValidWatchPlugInSignature() {
        try {
            if (TextUtils.equals((CharSequence)"34df0e7a9f1cf1892e45c056b4973cd81ccf148a4050d11aea4ac5a65f900a42", (CharSequence)this.getWatchPlugInSignature())) {
                return true;
            }
            Log.e((String)TAG, (String)"Signature of Samsung Pay(Watch Plugin) is not matched");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
        }
        return false;
    }

    @Nullable
    private String getWatchPlugInSignature() {
        try {
            Signature[] signatures = this.context.getPackageManager().getPackageInfo((String)"com.samsung.android.samsungpay.gear", (int)64).signatures;
            return SpayValidity.getSHA256Encode(signatures[0].toByteArray());
        }
        catch (PackageManager.NameNotFoundException | NoSuchAlgorithmException e) {
            Log.e((String)TAG, (String)e.toString());
            return null;
        }
    }

    @NonNull
    private static String getSHA256Encode(@NonNull byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(data, 0, data.length);
        byte[] sha1hash = md.digest();
        return SpayValidity.convertToHex(sha1hash);
    }

    @NonNull
    private static String convertToHex(@NonNull byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (byte b : data) {
            int halfbyte = b >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                buf.append(0 <= halfbyte && halfbyte <= 9 ? (char)(48 + halfbyte) : (char)(97 + (halfbyte - 10)));
                halfbyte = b & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }
}

