/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.IInterface;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.ErrorType;
import com.samsung.android.sdk.samsungpay.v2.PartnerRequest;
import com.samsung.android.sdk.samsungpay.v2.ServiceHelper;
import com.samsung.android.sdk.samsungpay.v2.ServiceStub;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;
import com.samsung.android.sdk.samsungpay.v2.SpayValidity;
import com.samsung.android.sdk.samsungpay.v2.StubConnector;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public final class StubBase<T extends IInterface>
extends ServiceHelper
implements ServiceStub {
    private static final String TAG = "SPAYSDK:StubBase";
    @Nullable
    private T mBoundStub = null;
    @NonNull
    private Queue<StubConnector> mCallerStubConnectors = new LinkedList<StubConnector>();
    private StubCaster<T> mStubCaster;
    private String mServiceAction;
    @Nullable
    private HandlerThread mHandlerThread;
    @Nullable
    private Handler mRequestHandler;
    private final Queue<PartnerRequest> mRequestList = new LinkedList<PartnerRequest>();
    @NonNull
    private Semaphore mWaitUntilRequestDone = new Semaphore(0);
    @NonNull
    private Semaphore mWaitForNewRequest = new Semaphore(0);
    private final Object[] mSyncObj = new Object[0];
    @NonNull
    private static HashMap<String, WeakReference<StubBase>> mStubMap = new HashMap(5);
    @NonNull
    private ServiceHelper.ServiceCallback mServiceCallback = new ServiceHelper.ServiceCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceived(IBinder binder) {
            StubBase.this.createHandlerThread();
            StubBase.this.createStub(binder);
            Object[] objectArray = StubBase.this.mSyncObj;
            synchronized (objectArray) {
                while (!StubBase.this.mCallerStubConnectors.isEmpty()) {
                    StubConnector stubConnector = (StubConnector)StubBase.this.mCallerStubConnectors.poll();
                    stubConnector.onReceivedStub(StubBase.this.mBoundStub);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailed(ServiceHelper.BindingResult result) {
            Object[] objectArray = StubBase.this.mSyncObj;
            synchronized (objectArray) {
                while (!StubBase.this.mCallerStubConnectors.isEmpty()) {
                    StubConnector stubConnector = (StubConnector)StubBase.this.mCallerStubConnectors.poll();
                    stubConnector.onFailed(result);
                }
            }
            StubBase.this.destroyHandlerThread();
        }

        @Override
        public void onDisconnected() {
            Log.e((String)StubBase.TAG, (String)"Service is disconnected");
            StubBase.this.destroyHandlerThread();
        }
    };
    @NonNull
    private Handler.Callback onRequestHandler = msg -> {
        Object[] objectArray = this.mSyncObj;
        synchronized (this.mSyncObj) {
            PartnerRequest request = this.mRequestList.peek();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (request == null) {
                Log.d((String)TAG, (String)"handleMessage: No request in the list");
                return false;
            }
            this.mWaitUntilRequestDone.release(100);
            this.mWaitUntilRequestDone.drainPermits();
            request.execute(this);
            try {
                this.mWaitUntilRequestDone.acquire();
                Object[] objectArray2 = this.mSyncObj;
                synchronized (this.mSyncObj) {
                    boolean noPendingRequest;
                    if (!this.mRequestList.isEmpty() && this.mRequestList.peek() == request) {
                        this.mRequestList.remove(request);
                    }
                    if (noPendingRequest = this.mRequestList.isEmpty()) {
                        this.mWaitForNewRequest.release(100);
                        this.mWaitForNewRequest.drainPermits();
                    }
                    // ** MonitorExit[var4_7] (shouldn't be in output)
                    if (noPendingRequest) {
                        this.mWaitForNewRequest.tryAcquire(5L, TimeUnit.SECONDS);
                    }
                    objectArray2 = this.mSyncObj;
                    synchronized (this.mSyncObj) {
                        noPendingRequest = this.mRequestList.isEmpty();
                        if (noPendingRequest) {
                            Log.d((String)TAG, (String)"No pending request. Disconnect stub");
                            this.disConnectStub();
                        } else {
                            this.mRequestHandler.sendEmptyMessage(0);
                        }
                        // ** MonitorExit[var4_7] (shouldn't be in output)
                        return false;
                    }
                }
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)("onRequestHandler - " + e.toString()));
            }
            return false;
        }
    };

    private StubBase(@NonNull Context context, String serviceAction, StubCaster<T> stubCaster) {
        super(context);
        this.mServiceAction = serviceAction;
        this.mStubCaster = stubCaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectStub(@NonNull StubConnector connector) {
        Object[] objectArray = this.mSyncObj;
        synchronized (this.mSyncObj) {
            if (this.isValidStub()) {
                connector.onReceivedStub(this.mBoundStub);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.isValidServiceBinder()) {
                this.mBoundStub = this.createStub(this.getServiceBinder());
                if (this.mBoundStub != null) {
                    connector.onReceivedStub(this.mBoundStub);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                Log.e((String)TAG, (String)"connectStub - bound stub is NULL. Retry to connect service");
            }
            this.mCallerStubConnectors.add(connector);
            this.createService(this.mServiceCallback, this.mServiceAction);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void disConnectStub() {
        Log.d((String)TAG, (String)("disConnectStub - service: " + this.mServiceAction));
        this.destroyHandlerThread();
        this.releaseStub();
        this.unbindService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidStub() {
        Object[] objectArray = this.mSyncObj;
        synchronized (this.mSyncObj) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mBoundStub != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseStub() {
        Object[] objectArray = this.mSyncObj;
        synchronized (this.mSyncObj) {
            this.mBoundStub = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private T createStub(@Nullable IBinder binder) {
        Object[] objectArray = this.mSyncObj;
        synchronized (this.mSyncObj) {
            if (binder != null) {
                this.mBoundStub = this.mStubCaster.castStub(binder);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.mBoundStub;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    @Nullable
    public T getStub() {
        return this.mBoundStub;
    }

    @Override
    public void setServicePackage(String servicePackage) {
        super.setServicePackage(servicePackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRequest(final @NonNull PartnerRequest request, SpaySdk.SdkApiLevel apiLevel) {
        Object[] objectArray = this.mSyncObj;
        synchronized (this.mSyncObj) {
            Log.d((String)TAG, (String)("postRequest - " + request.name));
            if (!this.verifyRequest(request, apiLevel)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            if (request.needStub) {
                this.connectStub(new StubConnector(){

                    @Override
                    public void onReceivedStub(Object stub) {
                        StubBase.this.addRequestToList(request);
                    }

                    @Override
                    public void onFailed(ServiceHelper.BindingResult result) {
                        request.catchError(ErrorType.BINDING_FAIL, -103, new Bundle());
                    }
                });
            } else {
                this.addRequestToList(request);
            }
            this.mWaitForNewRequest.release();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void executeRequest(@NonNull PartnerRequest request, @NonNull SpaySdk.SdkApiLevel apiLevel) {
        if (!this.verifyRequest(request, apiLevel)) {
            return;
        }
        request.execute(this);
    }

    public void nextRequest() {
        Log.d((String)TAG, (String)"nextRequest is called");
        this.mWaitUntilRequestDone.release();
    }

    private boolean verifyRequest(@NonNull PartnerRequest request, @NonNull SpaySdk.SdkApiLevel apiLevel) {
        SpaySdk.SdkApiLevel webApiLevel;
        boolean isWebCheckoutRequest;
        boolean spayNotSupport;
        if (request.checkDuplication && this.isRequestInQueue(request.operation)) {
            request.catchError(ErrorType.DUPLICATED_REQUEST, -105, null);
            return false;
        }
        SpayValidity spayValidity = new SpayValidity(this.getContext(), request.isWatch);
        int errorCode = spayValidity.getSpayValidity(request.owner.partnerInfo, apiLevel, request);
        Bundle extraErrorData = new Bundle();
        extraErrorData.putInt("errorReason", errorCode);
        int readyStatus = spayValidity.errorCodeToReadyStatus(errorCode);
        boolean partnerInfoInvalid = readyStatus == -99;
        boolean spayNotReady = request.needStub && 2 != readyStatus;
        boolean bl = spayNotSupport = !request.needStub && 0 == readyStatus;
        if (partnerInfoInvalid) {
            Log.w((String)TAG, (String)"postRequest - partnerInfoInvalid");
            request.catchError(ErrorType.PARTNER_INFO_INVALID, readyStatus, extraErrorData);
            return false;
        }
        if (spayNotReady || spayNotSupport) {
            Log.w((String)TAG, (String)("postRequest - init error " + readyStatus + " -  reason: " + errorCode));
            request.catchError(ErrorType.SPAY_VALIDITY_FAIL, readyStatus, extraErrorData);
            return false;
        }
        request.apiLevel = spayValidity.getSdkApiLevelInManifest();
        Bundle bundle = request.owner.partnerInfo.getData();
        String partnerServiceType = bundle.getString("PartnerServiceType");
        boolean bl2 = isWebCheckoutRequest = SpaySdk.ServiceType.WEB_PAYMENT.toString().equals(partnerServiceType) || SpaySdk.ServiceType.MOBILEWEB_PAYMENT.toString().equals(partnerServiceType);
        if (isWebCheckoutRequest && request.apiLevel.compareTo(webApiLevel = SpaySdk.SdkApiLevel.findSdkApiLevel(bundle.getString("WEB_CHECKOUT_API_LEVEL", ""))) < 0) {
            Log.d((String)TAG, (String)"web checkout api level is higher than manifest.");
            request.apiLevel = webApiLevel;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequestToList(@NonNull PartnerRequest request) {
        Object[] objectArray = this.mSyncObj;
        synchronized (this.mSyncObj) {
            Log.d((String)TAG, (String)("addRequestToList - request: " + request.name));
            this.mRequestList.add(request);
            if (this.mRequestHandler == null) {
                this.createHandlerThread();
                this.mRequestHandler.sendEmptyMessage(0);
            } else {
                this.mRequestHandler.sendEmptyMessage(0);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRequestInQueue(int requestOperation) {
        Object[] objectArray = this.mSyncObj;
        synchronized (this.mSyncObj) {
            for (PartnerRequest pReq : this.mRequestList) {
                if (requestOperation != pReq.operation) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHandlerThread() {
        Object[] objectArray = this.mSyncObj;
        synchronized (this.mSyncObj) {
            if (this.mHandlerThread == null) {
                this.mHandlerThread = new HandlerThread(this.mServiceAction);
                this.mHandlerThread.start();
                this.mRequestHandler = new Handler(this.mHandlerThread.getLooper(), this.onRequestHandler);
                Log.i((String)TAG, (String)("createStub HandlerThread - " + this.mHandlerThread.getName()));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyHandlerThread() {
        Object[] objectArray = this.mSyncObj;
        synchronized (this.mSyncObj) {
            if (this.mHandlerThread != null) {
                Log.d((String)TAG, (String)("destroy HandlerThread - " + this.mHandlerThread.getName()));
                this.mRequestHandler.removeMessages(0);
                this.cancelledPendingTasks(true);
                try {
                    this.mHandlerThread.quit();
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)("destroyHandlerThread - " + ex.toString()));
                }
                this.mRequestHandler = null;
                this.mHandlerThread = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelledPendingTasks(boolean triggerCallback) {
        Object[] objectArray = this.mSyncObj;
        synchronized (this.mSyncObj) {
            if (this.mRequestList.size() > 0) {
                Log.d((String)TAG, (String)("Dismiss " + this.mRequestList.size() + " pending request"));
                while (!this.mRequestList.isEmpty()) {
                    PartnerRequest cancellingRequest = this.mRequestList.poll();
                    cancellingRequest.isCancelled = true;
                    if (!triggerCallback) continue;
                    cancellingRequest.catchError(ErrorType.SERVICE_DISCONNECTED, -1, null);
                }
                this.mRequestList.clear();
            }
            this.mWaitUntilRequestDone.release();
            this.mWaitForNewRequest.release();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static interface StubCaster<K extends IInterface> {
        public K castStub(IBinder var1);
    }

    public static class Creator<T extends IInterface> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StubBase<T> createStub(@NonNull Context context, String serviceAction, StubCaster<T> stubCaster) {
            StubBase stub;
            WeakReference stubRef = (WeakReference)mStubMap.get(serviceAction);
            if (stubRef == null || stubRef.get() == null) {
                stub = new StubBase(context, serviceAction, stubCaster);
                stubRef = new WeakReference(stub);
                mStubMap.put(serviceAction, stubRef);
            } else {
                Log.i((String)StubBase.TAG, (String)("Found stub reference of " + serviceAction));
                stub = (StubBase)stubRef.get();
                if (TextUtils.equals((CharSequence)serviceAction, (CharSequence)"com.samsung.android.spay.sdk.v2.service.AppToAppService")) {
                    Object[] objectArray = stub.mSyncObj;
                    synchronized (objectArray) {
                        if (stub.mRequestList.size() > 0) {
                            Log.i((String)StubBase.TAG, (String)("Clear pending requests of " + serviceAction));
                            stub.cancelledPendingTasks(false);
                        }
                    }
                }
            }
            return stub;
        }
    }
}

