/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;

class VersionChecker {
    private static final String TAG = "SPAYSDK:VersionChecker";
    static final int COUNTRY_COLUMN = 0;
    static final int VERSION_CODE_COLUMN = 1;
    @NonNull
    String[][] countryAndMinimumVer = new String[][]{{"US", "2300"}, {"PR", "2300"}, {"KR", "2250"}, {"BR", "2400"}, {"ES", "2400"}, {"AU", "2400"}, {"SG", "2400"}, {"CN", "2800"}};
    static final int LAST_UNSUPPORTED_VERSION_CODE_FOR_SPAY_WATCH_PLUGIN = 173000006;

    protected boolean wasReleasedSpayAppExcludeVersionCheck(String countryAlpha2) {
        int size = this.countryAndMinimumVer.length;
        for (int i = 0; i < size; ++i) {
            if (!this.countryAndMinimumVer[i][0].equalsIgnoreCase(countryAlpha2)) continue;
            return true;
        }
        return false;
    }

    protected boolean isIncludeVersionCheckingRule(String countryAlpha2, int versionCode) {
        int size = this.countryAndMinimumVer.length;
        for (int i = 0; i < size; ++i) {
            if (!this.countryAndMinimumVer[i][0].equalsIgnoreCase(countryAlpha2)) continue;
            int minVer = Integer.parseInt(this.countryAndMinimumVer[i][1]);
            return minVer <= versionCode;
        }
        return false;
    }

    protected boolean isValidSdkApiLevel(@Nullable SpaySdk.SdkApiLevel usingSdkApiLevel, @Nullable SpaySdk.SdkApiLevel maxSdkApiLevel) {
        if (usingSdkApiLevel == null || usingSdkApiLevel == SpaySdk.SdkApiLevel.LEVEL_UNKNOWN || maxSdkApiLevel == null || maxSdkApiLevel == SpaySdk.SdkApiLevel.LEVEL_UNKNOWN) {
            Log.e((String)TAG, (String)"SDK API Level was not defined.");
            return false;
        }
        if (usingSdkApiLevel.compareTo(maxSdkApiLevel) > 0) {
            Log.e((String)TAG, (String)("API level defined in manifest(" + (Object)((Object)usingSdkApiLevel) + ") must lower than(or same with) SDK api level(" + (Object)((Object)maxSdkApiLevel) + "). You should change your api level in the AndroidManifest"));
            return false;
        }
        return true;
    }
}

