/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.AppToAppConstants;
import com.samsung.android.sdk.samsungpay.v2.ISWatchManager;
import com.samsung.android.sdk.samsungpay.v2.ParamInfo;
import com.samsung.android.sdk.samsungpay.v2.PartnerInfo;
import com.samsung.android.sdk.samsungpay.v2.PartnerRequest;
import com.samsung.android.sdk.samsungpay.v2.SamsungPayBase;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;
import com.samsung.android.sdk.samsungpay.v2.Status;
import com.samsung.android.sdk.samsungpay.v2.StatusListener;
import com.samsung.android.sdk.samsungpay.v2.StubBase;
import com.samsung.android.sdk.samsungpay.v2.card.AddCardInfo;
import com.samsung.android.sdk.samsungpay.v2.card.AddCardListener;
import com.samsung.android.sdk.samsungpay.v2.card.Card;
import com.samsung.android.sdk.samsungpay.v2.card.CardListener;
import com.samsung.android.sdk.samsungpay.v2.card.GetCardListener;
import com.samsung.android.sdk.samsungpay.v2.card.ISAddCardListener;
import com.samsung.android.sdk.samsungpay.v2.card.ISGetCardListener;
import java.lang.ref.WeakReference;
import java.util.List;

public final class WatchManager
extends SamsungPayBase
implements AppToAppConstants {
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_5)
    public static final String DEVICE_SERIAL_NUM = "deviceSerialNum";
    private List<Card> mCards;
    private Card mCard;
    public static final int ERROR_SPAY_PIN_LOCK_SETUP_CANCELED = -701;
    public static final int ERROR_INVALID_PARAMETER = -504;
    public static final int ERROR_SPAY_WATCH_PIN_LOCK_SETUP_CANCELED = -701;
    public static final int SPAY_WATCH_UPDATE_IS_ONGOING = -702;
    public static final int SPAY_WATCH_TAKING_LOG_FOR_REPORT = -703;
    public static final int ERROR_SPAY_WATCH_PAY_PROGRESS = -704;
    public static final int ERROR_SPAY_WATCH_CONNECTION = -705;
    @NonNull
    private Handler mHandlerForInternalListener = new Handler(Looper.getMainLooper()){

        public void handleMessage(@NonNull Message msg) {
            switch (msg.what) {
                case 0: {
                    if (msg.obj instanceof GetCardListener) {
                        ((GetCardListener)msg.obj).onSuccess(WatchManager.this.mCards);
                        break;
                    }
                    if (msg.obj instanceof StatusListener) {
                        ((StatusListener)msg.obj).onSuccess(msg.arg1, msg.getData());
                        break;
                    }
                    if (msg.obj instanceof AddCardListener) {
                        ((AddCardListener)msg.obj).onSuccess(msg.arg1, WatchManager.this.mCard);
                        break;
                    }
                    if (msg.obj instanceof CardListener) {
                        ((CardListener)msg.obj).onSuccess(msg.arg1, msg.getData());
                        break;
                    }
                    Log.e((String)SamsungPayBase.TAG, (String)"[onSuccess] Wrong listener was called");
                    break;
                }
                case 1: {
                    if (msg.obj instanceof GetCardListener) {
                        ((GetCardListener)msg.obj).onFail(msg.arg1, msg.getData());
                        break;
                    }
                    if (msg.obj instanceof StatusListener) {
                        ((StatusListener)msg.obj).onFail(msg.arg1, msg.getData());
                        break;
                    }
                    if (msg.obj instanceof AddCardListener) {
                        ((AddCardListener)msg.obj).onFail(msg.arg1, msg.getData());
                        break;
                    }
                    if (msg.obj instanceof CardListener) {
                        ((CardListener)msg.obj).onFail(msg.arg1, msg.getData());
                        break;
                    }
                    Log.e((String)SamsungPayBase.TAG, (String)"[onFail] Wrong listener was called");
                    break;
                }
                case 2: {
                    if (msg.obj instanceof AddCardListener) {
                        ((AddCardListener)msg.obj).onProgress(msg.arg1, msg.arg2, msg.getData());
                        break;
                    }
                    Log.e((String)SamsungPayBase.TAG, (String)"[onProgress] Wrong listener was called");
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    Log.e((String)SamsungPayBase.TAG, (String)"sdk can not catch listener from SPay.");
                }
            }
        }
    };

    public WatchManager(Context context, PartnerInfo partnerInfo) {
        super(context, partnerInfo, "com.samsung.android.samsungpay.gear");
        TAG = "SPAYSDK:WatchManager";
    }

    @Override
    @NonNull
    protected StubBase<IInterface> createStub(@NonNull Context context) {
        StubBase<IInterface> stubBase = new StubBase.Creator<IInterface>().createStub(context, "com.samsung.android.samsungpay.gear.sdk.v2.service.WatchService", ISWatchManager.Stub::asInterface);
        stubBase.setServicePackage("com.samsung.android.samsungpay.gear");
        return stubBase;
    }

    public void getSamsungPayStatus(@NonNull StatusListener listener) {
        super.getSamsungPayStatus(listener, SpaySdk.SdkApiLevel.LEVEL_2_5);
    }

    public void goToUpdatePage() {
        super.goToUpdatePage(SpaySdk.SdkApiLevel.LEVEL_2_5);
    }

    public void activateSamsungPay() {
        super.activateSamsungPay(SpaySdk.SdkApiLevel.LEVEL_2_5);
    }

    public void getWalletInfo(List<String> keys, @NonNull StatusListener listener) {
        super.getWalletInfo(keys, listener, SpaySdk.SdkApiLevel.LEVEL_2_5);
    }

    public void addCard(@NonNull AddCardInfo addCardInfo, @NonNull AddCardListener listener) {
        Log.d((String)TAG, (String)"addCard()");
        this.assertNotNull(listener);
        this.assertNotNull(addCardInfo);
        this.assertNotNull(addCardInfo.getTokenizationProvider());
        this.assertNotNull(addCardInfo.getCardDetail());
        this.assertNotNull(addCardInfo.getCardDetail().getString("provisionPayload"));
        AddCardInfoListenerInternal listenerInternal = new AddCardInfoListenerInternal();
        PartnerRequest pReq = new PartnerRequest.Builder(this, 11, listener).setName("WatchManager addCard").checkApiLevelFor(addCardInfo).onExecute((stub, request) -> ((ISWatchManager)stub).addCard(this.getPartnerInfo(), addCardInfo, listenerInternal.getAddCardListener())).onError((errorType, errorCode, errorExtra) -> listener.onFail(errorCode, errorExtra)).create();
        listenerInternal.set(pReq);
        this.mSamsungPayBaseStub.postRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_2_17);
    }

    public void getAllCards(@Nullable Bundle cardFilter, @NonNull GetCardListener listener) {
        Log.d((String)TAG, (String)"getAllCards() : SDK API Level = 2.13");
        this.assertNotNull(listener);
        Bundle finalCardFilter = cardFilter == null ? new Bundle() : cardFilter;
        GetCardListenerInternal listenerInternal = new GetCardListenerInternal();
        PartnerRequest pReq = new PartnerRequest.Builder(this, 10, listener).setName("WatchManager getAllCards").onExecute((stub, request) -> ((ISWatchManager)stub).getAllCards(this.getPartnerInfo(), finalCardFilter, listenerInternal.getCardListener())).onError((errorType, errorCode, errorExtra) -> listener.onFail(errorCode, errorExtra)).create();
        listenerInternal.set(pReq);
        this.mSamsungPayBaseStub.postRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_2_13);
    }

    private void sendMsgForGetCardListener(@Nullable WeakReference<PartnerRequest> requestRef, int result, int arg1, Bundle data) {
        PartnerRequest request;
        if (requestRef == null || (request = (PartnerRequest)requestRef.get()) == null) {
            Log.d((String)TAG, (String)"request is NULL");
            return;
        }
        Message message = Message.obtain((Handler)this.mHandlerForInternalListener);
        message.obj = request.callbackObj;
        message.what = result;
        if (result == 1) {
            message.arg1 = arg1;
            message.setData(data);
        }
        this.mHandlerForInternalListener.sendMessage(message);
    }

    private void sendMsgForAddCardListener(@Nullable WeakReference<PartnerRequest> requestRef, int result, int arg1, int arg2, Bundle data) {
        PartnerRequest request;
        if (requestRef == null || (request = (PartnerRequest)requestRef.get()) == null) {
            Log.d((String)TAG, (String)"sendMsgForAddCardListener - request is NULL");
            return;
        }
        Message message = Message.obtain((Handler)this.mHandlerForInternalListener);
        message.obj = request.callbackObj;
        message.what = result;
        message.arg1 = arg1;
        switch (result) {
            case 2: {
                message.arg2 = arg2;
                message.setData(data);
                break;
            }
            case 1: {
                message.setData(data);
            }
        }
        this.mHandlerForInternalListener.sendMessage(message);
    }

    @Override
    protected void doGetWalletInfo(@NonNull IInterface stub, @NonNull PartnerRequest request) throws RemoteException {
        SamsungPayBase.StatusListenerInternal statusListenerInternal = (SamsungPayBase.StatusListenerInternal)request.obj2;
        List keys = (List)request.obj1;
        ((ISWatchManager)stub).getWalletInfo(this.getPartnerInfo(), keys, statusListenerInternal.getStatusListener());
        this.mSamsungPayBaseStub.nextRequest();
    }

    @Override
    protected void doGetSamsungPayStatus(@NonNull IInterface stub, @NonNull PartnerRequest request) throws RemoteException {
        Status st = ((ISWatchManager)stub).getSamsungPayStatus(this.getPartnerInfo());
        if (st != null) {
            int status = st.getStatus();
            switch (status) {
                case 0: 
                case 1: 
                case 2: {
                    ((StatusListener)request.callbackObj).onSuccess(status, st.getData());
                    break;
                }
                default: {
                    ((StatusListener)request.callbackObj).onFail(status, st.getData());
                }
            }
        }
        this.mSamsungPayBaseStub.nextRequest();
    }

    @Override
    protected void doGoToUpdatePage() {
        Log.d((String)TAG, (String)"goToUpdatePage");
        Context liveContext = (Context)this.contextRef.get();
        if (liveContext != null) {
            Intent intent = new Intent();
            String uriString = "gearsamsungpay://launch?action=settings&menu=about_samsung_pay";
            intent.setAction("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)uriString));
            intent.addFlags(0x10008000);
            liveContext.startActivity(intent);
        } else {
            Log.e((String)TAG, (String)"doGoToUpdatePage - Context is null");
        }
        this.mSamsungPayBaseStub.nextRequest();
    }

    private class AddCardInfoListenerInternal {
        private final String TAG = AddCardInfoListenerInternal.class.getSimpleName();
        @Nullable
        private WeakReference<PartnerRequest> pReqRef = null;
        @NonNull
        private SpayAddCardListener spayAddCardListener = new SpayAddCardListener();

        private AddCardInfoListenerInternal() {
        }

        public void set(PartnerRequest pReq) {
            this.pReqRef = new WeakReference<PartnerRequest>(pReq);
        }

        private ISAddCardListener getAddCardListener() {
            return this.spayAddCardListener;
        }

        private class SpayAddCardListener
        extends ISAddCardListener.Stub {
            private SpayAddCardListener() {
            }

            @Override
            public void onSuccess(int status, Card card) throws RemoteException {
                Log.d((String)AddCardInfoListenerInternal.this.TAG, (String)("onSuccess: status: " + status));
                WatchManager.this.mCard = card;
                WatchManager.this.sendMsgForAddCardListener(AddCardInfoListenerInternal.this.pReqRef, 0, status, 0, null);
                WatchManager.this.mSamsungPayBaseStub.nextRequest();
            }

            @Override
            public void onFail(int errorCode, Bundle data) throws RemoteException {
                Log.e((String)AddCardInfoListenerInternal.this.TAG, (String)("onFail: errorCode: " + errorCode));
                WatchManager.this.sendMsgForAddCardListener(AddCardInfoListenerInternal.this.pReqRef, 1, errorCode, 0, data);
                WatchManager.this.mSamsungPayBaseStub.nextRequest();
            }

            @Override
            public void onProgress(int currentCount, int totalCount, Bundle data) {
                Log.e((String)AddCardInfoListenerInternal.this.TAG, (String)("onNotifyProgress: currentCount: " + currentCount + ", totalCount : " + totalCount));
                WatchManager.this.sendMsgForAddCardListener(AddCardInfoListenerInternal.this.pReqRef, 2, currentCount, totalCount, data);
            }
        }
    }

    private class GetCardListenerInternal {
        @NonNull
        private SpayCardListener mSpayGetCardListener = new SpayCardListener();
        @Nullable
        private WeakReference<PartnerRequest> pReqRef = null;
        private final String TAG = GetCardListenerInternal.class.getSimpleName();

        private GetCardListenerInternal() {
        }

        public void set(PartnerRequest pReq) {
            this.pReqRef = new WeakReference<PartnerRequest>(pReq);
        }

        @NonNull
        private ISGetCardListener getCardListener() {
            return this.mSpayGetCardListener;
        }

        private class SpayCardListener
        extends ISGetCardListener.Stub {
            private SpayCardListener() {
            }

            @Override
            public void onSuccess(PartnerInfo pInfo, List<Card> cards) throws RemoteException {
                Log.d((String)GetCardListenerInternal.this.TAG, (String)"onSuccess: ");
                WatchManager.this.mCards = cards;
                WatchManager.this.sendMsgForGetCardListener(GetCardListenerInternal.this.pReqRef, 0, 0, null);
                WatchManager.this.mSamsungPayBaseStub.nextRequest();
            }

            @Override
            public void onFail(PartnerInfo pInfo, int errorCode, Bundle errorData) throws RemoteException {
                Log.d((String)GetCardListenerInternal.this.TAG, (String)("onFail: " + errorCode));
                WatchManager.this.sendMsgForGetCardListener(GetCardListenerInternal.this.pReqRef, 1, errorCode, errorData);
                WatchManager.this.mSamsungPayBaseStub.nextRequest();
            }
        }
    }
}

