/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.card;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.NonNull;
import com.samsung.android.sdk.samsungpay.v2.CheckApiLevel;
import com.samsung.android.sdk.samsungpay.v2.ParamInfo;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;
import java.util.ArrayList;
import java.util.Arrays;

public class AddCardInfo
implements Parcelable {
    private static final String TAG = "AddCardInfo";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_2)
    public static final String EXTRA_PROVISION_PAYLOAD = "provisionPayload";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_2)
    public static final String EXTRA_ISSUER_ID = "issuerId";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_2)
    public static final String PROVIDER_VISA = "VI";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_2)
    public static final String PROVIDER_MASTERCARD = "MC";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_2)
    public static final String PROVIDER_AMEX = "AX";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_2)
    public static final String PROVIDER_DISCOVER = "DS";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_2)
    @Deprecated
    public static final String PROVIDER_GTO = "GTO";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_2)
    public static final String PROVIDER_PLCC = "PL";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_2)
    public static final String PROVIDER_GIFT = "GI";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_2)
    public static final String PROVIDER_LOYALTY = "LO";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_0)
    public static final String PROVIDER_PAYPAL = "PP";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_3)
    public static final String PROVIDER_GEMALTO = "GT";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_3)
    public static final String PROVIDER_NAPAS = "NP";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_3)
    public static final String PROVIDER_MIR = "MI";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_7)
    public static final String PROVIDER_PAGOBANCOMAT = "PB";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_14)
    public static final String EXTRA_SAMSUNG_PAY_CARD = "extra_samsung_pay_card";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_18)
    public static final String PROVIDER_VACCINE_PASS = "VaccinePass";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_17)
    public static final String EXTRA_KEY_MOSCOW_TRANSIT = "extra_transit_card_data";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_22)
    public static final String PROVIDER_MADA = "MADA";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_21)
    public static final String PROVIDER_ELO = "ELO";
    private String cardType;
    @CheckApiLevel
    private String tokenizationProvider;
    @CheckApiLevel
    private Bundle cardDetail;
    private static final ArrayList<String> allowedCardTypes = new ArrayList<String>(Arrays.asList("PAYMENT", "CREDIT", "DEBIT", "VACCINE_PASS"));
    public static final Parcelable.Creator<AddCardInfo> CREATOR = new Parcelable.Creator<AddCardInfo>(){

        @NonNull
        public AddCardInfo createFromParcel(@NonNull Parcel in) {
            return new AddCardInfo(in);
        }

        @NonNull
        public AddCardInfo[] newArray(int size) {
            return new AddCardInfo[size];
        }
    };

    public void setCardDetail(@NonNull Bundle cardDetail) {
        this.assertNotNull(cardDetail);
        this.verifyProvisionPayload(this.tokenizationProvider, cardDetail);
        this.cardDetail = cardDetail;
    }

    public void setTokenizationProvider(@NonNull String tokenizationProvider) {
        this.assertNotNull(tokenizationProvider);
        this.tokenizationProvider = tokenizationProvider;
    }

    public void setCardType(String cardType) {
        this.verifyCardTypeAllowed(cardType);
        this.cardType = cardType;
    }

    public Bundle getCardDetail() {
        return this.cardDetail;
    }

    public String getTokenizationProvider() {
        return this.tokenizationProvider;
    }

    public String getCardType() {
        return this.cardType;
    }

    protected AddCardInfo(@NonNull Parcel in) {
        this.cardType = in.readString();
        this.tokenizationProvider = in.readString();
        this.cardDetail = in.readBundle();
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.cardType);
        dest.writeString(this.tokenizationProvider);
        dest.writeBundle(this.cardDetail);
    }

    public int describeContents() {
        return 0;
    }

    public AddCardInfo(@NonNull String cardType, @NonNull String tokenizationProvider, @NonNull Bundle cardDetail) {
        this.verifyCardTypeAllowed(cardType);
        this.assertNotNull(tokenizationProvider);
        this.assertNotNull(cardDetail);
        this.verifyProvisionPayload(tokenizationProvider, cardDetail);
        this.cardType = cardType;
        this.tokenizationProvider = tokenizationProvider;
        this.cardDetail = cardDetail;
    }

    private void verifyCardTypeAllowed(String cardType) {
        if (!allowedCardTypes.contains(cardType)) {
            throw new IllegalArgumentException("Not allowed card type is used : " + cardType);
        }
    }

    private void verifyProvisionPayload(String tokenizationProvider, @NonNull Bundle bundle) {
        String payload = bundle.getString(EXTRA_PROVISION_PAYLOAD);
        if (TextUtils.isEmpty((CharSequence)payload)) {
            throw new IllegalArgumentException("Provision payload must be provided");
        }
        if (TextUtils.equals((CharSequence)tokenizationProvider, (CharSequence)PROVIDER_MASTERCARD)) {
            try {
                Base64.decode((byte[])payload.getBytes(), (int)0);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("verify provision payload failed : " + e.getMessage()));
                this.throwException("In case of Mastercard, payload should be Base64 encoded. Please double check it");
            }
        }
    }

    private void assertNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException("Input parameter must be set");
        }
    }

    private void throwException(String msg) {
        Log.e((String)TAG, (String)msg);
    }
}

