/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.card;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.samsung.android.sdk.samsungpay.v2.ParamInfo;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;
import com.samsung.android.sdk.samsungpay.v2.card.TransitCard;

public class Card
implements Parcelable {
    public static final String ACTIVE = "ACTIVE";
    public static final String DISPOSED = "DISPOSED";
    public static final String EXPIRED = "EXPIRED";
    public static final String PENDING_ENROLLED = "ENROLLED";
    public static final String PENDING_PROVISION = "PENDING_PROVISION";
    public static final String SUSPENDED = "SUSPENDED";
    public static final String PENDING_ACTIVATION = "PENDING_ACTIVATION";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_8)
    public static final String CARD_TYPE = "CARD_TYPE";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_1)
    public static final String CARD_TYPE_CREDIT_DEBIT = "PAYMENT";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_1)
    public static final String CARD_TYPE_GIFT = "GIFT";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_1)
    public static final String CARD_TYPE_LOYALTY = "LOYALTY";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_2)
    public static final String CARD_TYPE_CREDIT = "CREDIT";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_2)
    public static final String CARD_TYPE_DEBIT = "DEBIT";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_8)
    public static final String CARD_TYPE_TRANSIT = "TRANSIT";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_16)
    public static final String CARD_TYPE_VACCINE_PASS = "VACCINE_PASS";
    public static final Parcelable.Creator<Card> CREATOR = new Parcelable.Creator<Card>(){

        @NonNull
        public Card createFromParcel(@NonNull Parcel in) {
            String cardId = in.readString();
            String cardStatus = in.readString();
            SpaySdk.Brand cardBrand = (SpaySdk.Brand)((Object)in.readValue(SpaySdk.Brand.class.getClassLoader()));
            Bundle cardInfo = in.readBundle();
            if (cardInfo == null) {
                cardInfo = new Bundle();
            }
            if (TextUtils.equals((CharSequence)Card.CARD_TYPE_TRANSIT, (CharSequence)cardInfo.getString(Card.CARD_TYPE))) {
                return new TransitCard(cardId, cardStatus, cardBrand, cardInfo);
            }
            return new Card(cardId, cardStatus, cardBrand, cardInfo);
        }

        @NonNull
        public Card[] newArray(int size) {
            return new Card[size];
        }
    };
    private String cardId;
    private String cardStatus;
    private SpaySdk.Brand cardBrand;
    private Bundle cardInfo;

    private Card(@NonNull Parcel source) {
        this();
        this.readFromParcel(source);
    }

    public int describeContents() {
        return 0;
    }

    public void readFromParcel(@NonNull Parcel source) {
        this.cardId = source.readString();
        this.cardStatus = source.readString();
        this.cardBrand = (SpaySdk.Brand)((Object)source.readValue(SpaySdk.Brand.class.getClassLoader()));
        this.cardInfo = source.readBundle();
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.cardId);
        dest.writeString(this.cardStatus);
        dest.writeValue((Object)this.cardBrand);
        dest.writeBundle(this.cardInfo);
    }

    public Card() {
    }

    public Card(String cardId, String cardStatus) {
        this.cardId = cardId;
        this.cardStatus = cardStatus;
        this.cardInfo = new Bundle();
        this.cardBrand = SpaySdk.Brand.UNKNOWN_CARD;
    }

    public Card(String cardId, Bundle cardInfo) {
        this.cardId = cardId;
        this.cardStatus = "";
        this.cardInfo = cardInfo;
        this.cardBrand = SpaySdk.Brand.UNKNOWN_CARD;
    }

    public Card(String cardId, String cardStatus, Bundle cardInfo) {
        this.cardId = cardId;
        this.cardStatus = cardStatus;
        this.cardInfo = cardInfo;
        this.cardBrand = SpaySdk.Brand.UNKNOWN_CARD;
    }

    public Card(String cardId, String cardStatus, SpaySdk.Brand cardBrand, Bundle cardInfo) {
        this.cardId = cardId;
        this.cardStatus = cardStatus;
        this.cardBrand = cardBrand;
        this.cardInfo = cardInfo;
    }

    public String getCardId() {
        return this.cardId;
    }

    public SpaySdk.Brand getCardBrand() {
        return this.cardBrand;
    }

    public Bundle getCardInfo() {
        return this.cardInfo;
    }

    public String getCardStatus() {
        return this.cardStatus;
    }

    public void setCardId(String cardId) {
        this.cardId = cardId;
    }

    public void setCardBrand(SpaySdk.Brand cardBrand) {
        this.cardBrand = cardBrand;
    }

    public void setCardInfo(Bundle cardInfo) {
        this.cardInfo = cardInfo;
    }

    public void setCardStatus(String cardStatus) {
        this.cardStatus = cardStatus;
    }

    @NonNull
    public String toString() {
        return "Card{cardId='" + this.cardId + '\'' + ", cardStatus='" + this.cardStatus + '\'' + ", cardBrand='" + (Object)((Object)this.cardBrand) + '\'' + ", cardInfo=" + this.cardInfo + '}';
    }
}

