/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.card;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.AppToAppConstants;
import com.samsung.android.sdk.samsungpay.v2.ISStatusListener;
import com.samsung.android.sdk.samsungpay.v2.PartnerInfo;
import com.samsung.android.sdk.samsungpay.v2.PartnerRequest;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;
import com.samsung.android.sdk.samsungpay.v2.StatusListener;
import com.samsung.android.sdk.samsungpay.v2.StubBase;
import com.samsung.android.sdk.samsungpay.v2.card.AddCardInfo;
import com.samsung.android.sdk.samsungpay.v2.card.AddCardListener;
import com.samsung.android.sdk.samsungpay.v2.card.Card;
import com.samsung.android.sdk.samsungpay.v2.card.CardListener;
import com.samsung.android.sdk.samsungpay.v2.card.GetCardListener;
import com.samsung.android.sdk.samsungpay.v2.card.ISAddCardListener;
import com.samsung.android.sdk.samsungpay.v2.card.ISCardManager;
import com.samsung.android.sdk.samsungpay.v2.card.ISGetCardListener;
import com.samsung.android.sdk.samsungpay.v2.card.ISInitiateSessionCallback;
import com.samsung.android.sdk.samsungpay.v2.card.IdvVerifyInfo;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public final class CardManager
extends SpaySdk
implements AppToAppConstants {
    private static final int OPT_GET_ALL_CARDS = 1;
    private static final int OPT_ADD_CARD = 2;
    private static final int OPT_VERIFY_CARD_IDV = 3;
    private static final int OPT_REQUEST_PAY = 4;
    private static final int OPT_UPDATE_ADDITIONAL_SERVICE = 5;
    private static final int OPT_UPDATE_CARD = 6;
    private static final int OPT_ADD_COBADGE_CARD = 7;
    private static final String TAG = "SPAYSDK:CardManager";
    private StubBase<ISCardManager> mCardManagerStub;
    public static final int ERROR_INVALID_PARAMETER = -504;
    public static final String PUSH_PROVISION_ERROR = "push_provision_error_table";
    @NonNull
    protected Handler mHandlerForInternalListener = new Handler(Looper.getMainLooper()){

        public void handleMessage(@NonNull Message msg) {
            switch (msg.what) {
                case 0: {
                    if (msg.obj instanceof GetCardListener) {
                        ((GetCardListener)msg.obj).onSuccess(msg.getData().getParcelableArrayList("KEY_FOR_MESSAGE"));
                        break;
                    }
                    if (msg.obj instanceof StatusListener) {
                        ((StatusListener)msg.obj).onSuccess(msg.arg1, msg.getData());
                        break;
                    }
                    if (msg.obj instanceof AddCardListener) {
                        ((AddCardListener)msg.obj).onSuccess(msg.arg1, (Card)msg.getData().getParcelable("KEY_FOR_MESSAGE"));
                        break;
                    }
                    if (msg.obj instanceof CardListener) {
                        ((CardListener)msg.obj).onSuccess(msg.arg1, msg.getData());
                        break;
                    }
                    Log.e((String)CardManager.TAG, (String)"[onSuccess] Wrong listener was called");
                    break;
                }
                case 1: {
                    if (msg.obj instanceof GetCardListener) {
                        ((GetCardListener)msg.obj).onFail(msg.arg1, msg.getData());
                        break;
                    }
                    if (msg.obj instanceof StatusListener) {
                        ((StatusListener)msg.obj).onFail(msg.arg1, msg.getData());
                        break;
                    }
                    if (msg.obj instanceof AddCardListener) {
                        ((AddCardListener)msg.obj).onFail(msg.arg1, msg.getData());
                        break;
                    }
                    if (msg.obj instanceof CardListener) {
                        ((CardListener)msg.obj).onFail(msg.arg1, msg.getData());
                        break;
                    }
                    Log.e((String)CardManager.TAG, (String)"[onFail] Wrong listener was called");
                    break;
                }
                case 2: {
                    if (msg.obj instanceof AddCardListener) {
                        ((AddCardListener)msg.obj).onProgress(msg.arg1, msg.arg2, msg.getData());
                        break;
                    }
                    Log.e((String)CardManager.TAG, (String)"[onProgress] Wrong listener was called");
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    Log.e((String)CardManager.TAG, (String)"sdk can not catch listener from SPay.");
                }
            }
        }
    };
    private final Handler mHandlerForSessionCallback = new Handler(Looper.getMainLooper()){

        public void handleMessage(@NonNull Message msg) {
            UpdateServiceSessionCallback sessionCallback = (UpdateServiceSessionCallback)msg.obj;
            CardListener cardListener = (CardListener)sessionCallback.cardListenerRef.get();
            switch (msg.what) {
                case 3: {
                    CardManager.this.showUpdateServiceSheet(sessionCallback, msg.arg1);
                    break;
                }
                case 0: {
                    if (cardListener == null) break;
                    cardListener.onSuccess(msg.arg1, msg.getData());
                    break;
                }
                case 1: {
                    if (cardListener == null) break;
                    cardListener.onFail(msg.arg1, msg.getData());
                    break;
                }
            }
        }
    };

    public CardManager(Context context, PartnerInfo partnerInfo) {
        super(context, partnerInfo);
        Log.d((String)TAG, (String)"CardManager()");
        this.mCardManagerStub = new StubBase.Creator<ISCardManager>().createStub(context, "com.samsung.android.spay.sdk.v2.service.AppToAppService", ISCardManager.Stub::asInterface);
    }

    public void addCard(@NonNull AddCardInfo addCardInfo, @NonNull AddCardListener listener) {
        Log.d((String)TAG, (String)"addCard() : SDK API Level = 1.2");
        this.assertNotNull(listener, addCardInfo, addCardInfo.getTokenizationProvider(), addCardInfo.getCardDetail(), addCardInfo.getCardDetail().getString("provisionPayload"));
        AddCardInfoListenerInternal listenerInternal = new AddCardInfoListenerInternal();
        PartnerRequest pReq = new PartnerRequest.Builder(this, 2, listener).setName("addCard").checkApiLevelFor(addCardInfo).onExecute((stub, request) -> ((ISCardManager)stub).addCard(this.getPartnerInfo(), addCardInfo, listenerInternal.getAddCardListener())).onError((errorType, errorCode, errorExtra) -> listener.onFail(errorCode, errorExtra)).create();
        listenerInternal.set(pReq);
        this.mCardManagerStub.postRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_1_2);
    }

    public void addCobadgeCard(@NonNull AddCardInfo primaryAddCardInfo, @NonNull AddCardInfo secondaryAddCardInfo, @NonNull AddCardListener listener) {
        Log.d((String)TAG, (String)"addCobadgeCard(): SDK API Level = 2.22");
        this.assertNotNull(listener, primaryAddCardInfo, primaryAddCardInfo.getTokenizationProvider(), primaryAddCardInfo.getCardDetail(), primaryAddCardInfo.getCardDetail().getString("provisionPayload"));
        this.assertNotNull(secondaryAddCardInfo, secondaryAddCardInfo.getTokenizationProvider(), secondaryAddCardInfo.getCardDetail(), secondaryAddCardInfo.getCardDetail().getString("provisionPayload"));
        AddCardInfoListenerInternal listenerInternal = new AddCardInfoListenerInternal();
        PartnerRequest pReq = new PartnerRequest.Builder(this, 7, listener).setName("addCobadgeCard").checkApiLevelFor(primaryAddCardInfo, secondaryAddCardInfo).onExecute((stub, request) -> ((ISCardManager)stub).addCobadgeCard(this.getPartnerInfo(), primaryAddCardInfo, secondaryAddCardInfo, listenerInternal.getAddCardListener())).onError((errorType, errorCode, errorExtra) -> listener.onFail(errorCode, errorExtra)).create();
        listenerInternal.set(pReq);
        this.mCardManagerStub.postRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_2_22);
    }

    public void getAllCards(@Nullable Bundle cardFilter, @NonNull GetCardListener listener) {
        Log.d((String)TAG, (String)"getAllCards() : SDK API Level = 2.15");
        this.assertNotNull(listener);
        Bundle finalCardFilter = cardFilter == null ? new Bundle() : cardFilter;
        GetCardListenerInternal listenerInternal = new GetCardListenerInternal();
        PartnerRequest pReq = new PartnerRequest.Builder(this, 1, listener).setName("getAllCards").onExecute((stub, request) -> ((ISCardManager)stub).getAllCards(this.getPartnerInfo(), finalCardFilter, listenerInternal.getCardListener())).onError((errorType, errorCode, errorExtra) -> listener.onFail(errorCode, errorExtra)).create();
        listenerInternal.set(pReq);
        this.mCardManagerStub.postRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_2_15);
    }

    public void verifyCardIdv(@NonNull IdvVerifyInfo idvVerifyInfo, @NonNull StatusListener listener) {
        Log.d((String)TAG, (String)"verifyCardIdv() : SDK API Level = 1.1");
        this.assertNotNull(listener);
        this.assertNotNull(idvVerifyInfo);
        StatusListenerInternal listenerInternal = new StatusListenerInternal();
        PartnerRequest pReq = new PartnerRequest.Builder(this, 3, listener).setName("verifyCardIdv").checkApiLevelFor(idvVerifyInfo.getCardInfoData()).onExecute((stub, request) -> ((ISCardManager)stub).verifyCardIdv(this.getPartnerInfo(), idvVerifyInfo, listenerInternal.getStatusListener())).onError((errorType, errorCode, errorExtra) -> listener.onFail(errorCode, errorExtra)).create();
        listenerInternal.set(pReq);
        this.mCardManagerStub.postRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_1_1);
    }

    public void updateAdditionalService(Card card, @NonNull CardListener listener) {
        Log.d((String)TAG, (String)"updateAdditionalService() : SDK API Level = 1.8");
        this.assertNotNull(listener);
        this.assertNotNull(card);
        StatusListenerInternal listenerInternal = new StatusListenerInternal();
        PartnerRequest pReq = new PartnerRequest.Builder(this, 5, listener).setName("updateAdditionalService").checkDuplication(true).onExecute((stub, request) -> {
            if (this.getPartnerInfo().getData() == null) {
                this.getPartnerInfo().setData(new Bundle());
            }
            UpdateServiceSessionCallback sessionCallback = new UpdateServiceSessionCallback(request);
            ((ISCardManager)stub).initiateSessionWithCardInfo(this.getPartnerInfo(), sessionCallback.getInitiateSessionCallback(), card);
        }).onError((errorType, errorCode, errorExtra) -> listener.onFail(errorCode, errorExtra)).create();
        listenerInternal.set(pReq);
        this.mCardManagerStub.postRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_1_8);
    }

    @Deprecated
    public void updateCard(Card card, @NonNull CardListener listener) {
        Log.d((String)TAG, (String)"updateCard() : SDK API Level = 2.2");
        this.assertNotNull(listener);
        this.assertNotNull(card);
        StatusListenerInternal listenerInternal = new StatusListenerInternal();
        PartnerRequest pReq = new PartnerRequest.Builder(this, 6, listener).setName("updateCard").checkDuplication(true).onExecute((stub, request) -> ((ISCardManager)stub).updateCard(this.getPartnerInfo(), card, listenerInternal.getStatusListener())).onError((errorType, errorCode, errorExtra) -> listener.onFail(errorCode, errorExtra)).create();
        listenerInternal.set(pReq);
        this.mCardManagerStub.postRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_2_2);
    }

    protected void sendMsgForGetCardListener(@Nullable WeakReference<PartnerRequest> requestRef, int result, int arg1, Bundle data) {
        PartnerRequest request;
        if (requestRef == null || (request = (PartnerRequest)requestRef.get()) == null) {
            Log.d((String)TAG, (String)"request is NULL");
            return;
        }
        Message message = Message.obtain((Handler)this.mHandlerForInternalListener);
        message.obj = request.callbackObj;
        message.what = result;
        message.setData(data);
        if (result == 1) {
            message.arg1 = arg1;
        }
        this.mHandlerForInternalListener.sendMessage(message);
    }

    protected void sendMsgForStatusListener(@Nullable WeakReference<PartnerRequest> requestRef, int result, int arg1, Bundle data) {
        PartnerRequest request;
        if (requestRef == null || (request = (PartnerRequest)requestRef.get()) == null) {
            Log.d((String)TAG, (String)"sendMsgForStatusListener -  request is NULL");
            return;
        }
        Message message = Message.obtain((Handler)this.mHandlerForInternalListener);
        message.obj = request.callbackObj;
        message.what = result;
        message.arg1 = arg1;
        message.setData(data);
        this.mHandlerForInternalListener.sendMessage(message);
    }

    protected void sendMsgForAddCardListener(@Nullable WeakReference<PartnerRequest> requestRef, int result, int arg1, int arg2, Bundle data) {
        PartnerRequest request;
        if (requestRef == null || (request = (PartnerRequest)requestRef.get()) == null) {
            Log.d((String)TAG, (String)"sendMsgForAddCardListener - request is NULL");
            return;
        }
        Message message = Message.obtain((Handler)this.mHandlerForInternalListener);
        message.obj = request.callbackObj;
        message.what = result;
        message.arg1 = arg1;
        message.setData(data);
        if (result == 2) {
            message.arg2 = arg2;
        }
        this.mHandlerForInternalListener.sendMessage(message);
    }

    private void showUpdateServiceSheet(@NonNull UpdateServiceSessionCallback session, int callerUid) {
        Log.d((String)TAG, (String)"showUpdateCardSheet()");
        Context liveContext = (Context)this.contextRef.get();
        if (liveContext != null) {
            try {
                Intent intent = new Intent();
                if (liveContext instanceof Activity) {
                    Log.d((String)TAG, (String)"Context is an instance of Activity");
                    intent.setFlags(0x20000000);
                } else {
                    Log.d((String)TAG, (String)"Not Activity context");
                    intent.setFlags(0x10000000);
                }
                intent.setComponent(session.compName);
                intent.putExtra("callerUid", callerUid);
                intent.putExtra("sdkVersion", 2);
                liveContext.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)"activity not found and return error");
                CardListener cardListener = (CardListener)session.cardListenerRef.get();
                if (cardListener != null) {
                    cardListener.onFail(-1, new Bundle());
                }
            }
        } else {
            Log.e((String)TAG, (String)"showUpdateServiceSheet - Context is destroyed");
        }
    }

    protected void setServicePackage(String servicePackage) {
        this.mCardManagerStub.setServicePackage(servicePackage);
    }

    private class UpdateServiceSessionCallback
    extends InternalListenerBase {
        private static final String TAG = "UpdateServiceCallback";
        @Nullable
        private ComponentName compName;
        private WeakReference<CardListener> cardListenerRef;
        @NonNull
        private InitiateSessionCallback initiateCallback;

        public UpdateServiceSessionCallback(PartnerRequest pReq) {
            this.compName = null;
            this.initiateCallback = new InitiateSessionCallback();
            this.set(pReq);
            this.cardListenerRef = new WeakReference<CardListener>((CardListener)pReq.callbackObj);
        }

        public InitiateSessionCallback getInitiateSessionCallback() {
            return this.initiateCallback;
        }

        private class InitiateSessionCallback
        extends ISInitiateSessionCallback.Stub {
            private InitiateSessionCallback() {
            }

            @Override
            public void onSessionCompleted(@NonNull Bundle nextOrder) {
                Log.d((String)UpdateServiceSessionCallback.TAG, (String)"onInitiateCompleted: ");
                String packageName = nextOrder.getString("packageName");
                String className = nextOrder.getString("className");
                UpdateServiceSessionCallback.this.compName = new ComponentName(packageName, className);
                int callerUid = nextOrder.getInt("callerUid");
                Message msg = new Message();
                msg.what = 3;
                msg.obj = UpdateServiceSessionCallback.this;
                msg.arg1 = callerUid;
                CardManager.this.mHandlerForSessionCallback.sendMessage(msg);
            }

            @Override
            public void onSessionFailed(int errorCode, Bundle errorData) {
                if (UpdateServiceSessionCallback.this.isValidRequest("UpdateServiceCallback onSessionFailed")) {
                    Log.e((String)UpdateServiceSessionCallback.TAG, (String)("onSessionFailed: errorCode " + errorCode));
                    Message msg = new Message();
                    msg.what = 1;
                    Bundle data = new Bundle(errorData);
                    msg.obj = UpdateServiceSessionCallback.this;
                    msg.arg1 = errorCode;
                    msg.setData(data);
                    CardManager.this.mHandlerForSessionCallback.sendMessage(msg);
                }
                CardManager.this.mCardManagerStub.nextRequest();
            }

            @Override
            public void onAuthenticationApproved(int status, Bundle extraData) {
                Log.e((String)UpdateServiceSessionCallback.TAG, (String)("onAuthenticationApproved: errorData " + extraData));
                Message msg = new Message();
                msg.what = 0;
                Bundle data = new Bundle(extraData);
                msg.obj = UpdateServiceSessionCallback.this;
                msg.arg1 = status;
                msg.setData(data);
                CardManager.this.mHandlerForSessionCallback.sendMessage(msg);
                CardManager.this.mCardManagerStub.nextRequest();
            }
        }
    }

    private class AddCardInfoListenerInternal
    extends InternalListenerBase {
        private static final String TAG = "AddCardInfoInternal";
        @NonNull
        private SpayAddCardListener spayAddCardListener;

        private AddCardInfoListenerInternal() {
            this.spayAddCardListener = new SpayAddCardListener();
        }

        public ISAddCardListener getAddCardListener() {
            return this.spayAddCardListener;
        }

        private class SpayAddCardListener
        extends ISAddCardListener.Stub {
            private SpayAddCardListener() {
            }

            @Override
            public void onSuccess(int status, Card card) throws RemoteException {
                Log.d((String)AddCardInfoListenerInternal.TAG, (String)("onSuccess: status: " + status));
                Bundle bundle = new Bundle();
                bundle.putParcelable("KEY_FOR_MESSAGE", (Parcelable)card);
                CardManager.this.sendMsgForAddCardListener(AddCardInfoListenerInternal.this.pReqRef, 0, status, 0, bundle);
                CardManager.this.mCardManagerStub.nextRequest();
            }

            @Override
            public void onFail(int errorCode, Bundle data) throws RemoteException {
                if (AddCardInfoListenerInternal.this.isValidRequest("AddCardInfoInternal onFail")) {
                    Log.e((String)AddCardInfoListenerInternal.TAG, (String)("onFail: errorCode: " + errorCode));
                    CardManager.this.sendMsgForAddCardListener(AddCardInfoListenerInternal.this.pReqRef, 1, errorCode, 0, data);
                    CardManager.this.mCardManagerStub.nextRequest();
                }
            }

            @Override
            public void onProgress(int currentCount, int totalCount, Bundle data) {
                if (AddCardInfoListenerInternal.this.isValidRequest("AddCardInfoInternal onProgress")) {
                    Log.e((String)AddCardInfoListenerInternal.TAG, (String)("onProgress: currentCount: " + currentCount + ", totalCount : " + totalCount));
                    CardManager.this.sendMsgForAddCardListener(AddCardInfoListenerInternal.this.pReqRef, 2, currentCount, totalCount, data);
                }
            }
        }
    }

    private class GetCardListenerInternal
    extends InternalListenerBase {
        @NonNull
        private SpayCardListener mSpayGetCardListener;
        private static final String TAG = "GetCardListenerInternal";

        private GetCardListenerInternal() {
            this.mSpayGetCardListener = new SpayCardListener();
        }

        @NonNull
        protected ISGetCardListener getCardListener() {
            return this.mSpayGetCardListener;
        }

        private class SpayCardListener
        extends ISGetCardListener.Stub {
            private SpayCardListener() {
            }

            @Override
            public void onSuccess(PartnerInfo pInfo, List<Card> cards) throws RemoteException {
                Log.d((String)GetCardListenerInternal.TAG, (String)"onSuccess: ");
                Bundle bundle = new Bundle();
                bundle.putParcelableArrayList("KEY_FOR_MESSAGE", (ArrayList)cards);
                CardManager.this.sendMsgForGetCardListener(GetCardListenerInternal.this.pReqRef, 0, 0, bundle);
                CardManager.this.mCardManagerStub.nextRequest();
            }

            @Override
            public void onFail(PartnerInfo pInfo, int errorCode, Bundle errorData) throws RemoteException {
                if (GetCardListenerInternal.this.isValidRequest("GetCardListenerInternal onFail")) {
                    Log.d((String)GetCardListenerInternal.TAG, (String)("onFail: " + errorCode));
                    CardManager.this.sendMsgForGetCardListener(GetCardListenerInternal.this.pReqRef, 1, errorCode, errorData);
                    CardManager.this.mCardManagerStub.nextRequest();
                }
            }
        }
    }

    private class StatusListenerInternal
    extends InternalListenerBase {
        private static final String TAG = "StatusListenerInternal";
        @NonNull
        private SpayStatusListener spayStatusListener;

        private StatusListenerInternal() {
            this.spayStatusListener = new SpayStatusListener();
        }

        public ISStatusListener getStatusListener() {
            return this.spayStatusListener;
        }

        private class SpayStatusListener
        extends ISStatusListener.Stub {
            private SpayStatusListener() {
            }

            @Override
            public void onSuccess(PartnerInfo pInfo, int status, Bundle data) throws RemoteException {
                Log.d((String)StatusListenerInternal.TAG, (String)("onSuccess: status: " + status));
                CardManager.this.sendMsgForStatusListener(StatusListenerInternal.this.pReqRef, 0, status, data);
                CardManager.this.mCardManagerStub.nextRequest();
            }

            @Override
            public void onFail(PartnerInfo pInfo, int errorCode, Bundle errorData) throws RemoteException {
                if (StatusListenerInternal.this.isValidRequest("StatusListenerInternal onFail")) {
                    Log.e((String)StatusListenerInternal.TAG, (String)("onFail: errorCode: " + errorCode));
                    CardManager.this.sendMsgForStatusListener(StatusListenerInternal.this.pReqRef, 1, errorCode, errorData);
                    CardManager.this.mCardManagerStub.nextRequest();
                }
            }
        }
    }

    private static abstract class InternalListenerBase {
        @Nullable
        protected WeakReference<PartnerRequest> pReqRef = null;

        private InternalListenerBase() {
        }

        public void set(PartnerRequest pReq) {
            this.pReqRef = new WeakReference<PartnerRequest>(pReq);
        }

        public boolean isValidRequest(String tag) {
            if (this.pReqRef == null || this.pReqRef.get() == null || ((PartnerRequest)this.pReqRef.get()).isCancelled) {
                Log.e((String)CardManager.TAG, (String)(tag + ": Request is cancelled or invalid"));
                return false;
            }
            return true;
        }
    }
}

