/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.card;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.samsung.android.sdk.samsungpay.v2.ParamInfo;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;

public class IdvVerifyInfo
implements Parcelable {
    private String mCardId;
    private String mCode;
    private Bundle mCardInfoData;
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_7)
    public static final String IDV_TYPE_APP2APP = "APP2APP";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_7)
    public static final String IDV_TYPE_SMS = "SMS";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_7)
    public static final String IDV_TYPE_EMAIL = "EMAIL";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_7, checkValue=true)
    public static final String KEY_IDV_AUTH_CODE_TYPE = "IDV_AUTH_CODE_TYPE";
    public static final Parcelable.Creator<IdvVerifyInfo> CREATOR = new Parcelable.Creator<IdvVerifyInfo>(){

        @NonNull
        public IdvVerifyInfo createFromParcel(@NonNull Parcel source) {
            return new IdvVerifyInfo(source);
        }

        @NonNull
        public IdvVerifyInfo[] newArray(int size) {
            return new IdvVerifyInfo[size];
        }
    };

    public IdvVerifyInfo() {
    }

    public IdvVerifyInfo(String cardId, String code, Bundle cardInfoData) {
        this.mCardId = cardId;
        this.mCode = code;
        this.mCardInfoData = cardInfoData;
    }

    public String getCardId() {
        return this.mCardId;
    }

    public void setCardId(String cardId) {
        this.mCardId = cardId;
    }

    public String getCode() {
        return this.mCode;
    }

    public void setCode(String code) {
        this.mCode = code;
    }

    public Bundle getCardInfoData() {
        return this.mCardInfoData;
    }

    public void setCardInfoData(Bundle cardInfoData) {
        this.mCardInfoData = cardInfoData;
    }

    public String getIDnVType() {
        if (this.mCardInfoData == null) {
            return IDV_TYPE_APP2APP;
        }
        return this.mCardInfoData.getString(KEY_IDV_AUTH_CODE_TYPE, IDV_TYPE_APP2APP);
    }

    public void setIDnVType(String idvType) {
        if (this.mCardInfoData == null) {
            this.mCardInfoData = new Bundle();
        }
        this.mCardInfoData.putString(KEY_IDV_AUTH_CODE_TYPE, idvType);
    }

    private IdvVerifyInfo(@NonNull Parcel source) {
        this.readFromParcel(source);
    }

    public int describeContents() {
        return 0;
    }

    public void readFromParcel(@NonNull Parcel source) {
        this.mCardId = source.readString();
        this.mCode = source.readString();
        this.mCardInfoData = source.readBundle();
    }

    public void writeToParcel(@NonNull Parcel dest, int i) {
        dest.writeString(this.mCardId);
        dest.writeString(this.mCode);
        dest.writeBundle(this.mCardInfoData);
    }

    @NonNull
    public String toString() {
        return "IdvVerifyInfo{mCardId='" + this.mCardId + '\'' + ", mCode='" + this.mCode + '\'' + ", mCardInfoData=" + this.mCardInfoData + '}';
    }
}

