/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.card;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.ParamInfo;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;
import com.samsung.android.sdk.samsungpay.v2.card.Card;

public class TransitCard
extends Card {
    private static final String ADDITIONAL_SERVICE_TRANSACTION_ID = "SERVICE_TRANSACTION_ID";
    private static final String ADDITIONAL_SERVICE_TRANSACTION_DATA = "SERVICE_TRANSACTION_DATA";
    private static final String ADDITIONAL_SERVICE_TYPE = "SERVICE_TYPE";
    private static final String ADDITIONAL_SERVICE_DATA = "SERVICE_DATA";
    private static final String ADDITIONAL_SERVICE_DESCRIPTION = "SERVICE_DESC";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_8)
    public static final String ADDITIONAL_SERVICE_ONLINE_PAY = "ONLINE_PAY";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_8)
    public static final String ADDITIONAL_SERVICE_CHARGE = "CHARGE";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_8)
    public static final String ADDITIONAL_SERVICE_WITHDRAW = "WITHDRAW";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_8)
    public static final String ADDITIONAL_SERVICE_AAVS = "AAVS";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_8)
    public static final String ADDITIONAL_SERVICE_BALANCE_LIMIT = "BALANCE_LIMIT";

    public TransitCard() {
        this.init();
    }

    public TransitCard(String cardId, String cardStatus, SpaySdk.Brand cardBrand, Bundle cardInfo) {
        super(cardId, cardStatus, cardBrand, cardInfo);
        this.init();
    }

    private void init() {
        if (this.getCardInfo() == null) {
            this.setCardInfo(new Bundle());
        }
        this.getCardInfo().putString("CARD_TYPE", "TRANSIT");
    }

    public void setCardReferenceId(@NonNull String cardId) {
        this.setCardId(cardId);
    }

    public void setAdditionalServiceType(@NonNull String updateType) {
        this.getCardInfo().putString(ADDITIONAL_SERVICE_TYPE, updateType);
    }

    public void setAdditionalServiceData(@Nullable String updateData) {
        this.getCardInfo().putString(ADDITIONAL_SERVICE_DATA, updateData);
    }

    public void setAdditionalServiceDescription(@NonNull String description) {
        this.getCardInfo().putString(ADDITIONAL_SERVICE_DESCRIPTION, description);
    }

    public void setTransactionId(@NonNull String txnId) {
        this.getCardInfo().putString(ADDITIONAL_SERVICE_TRANSACTION_ID, txnId);
    }

    public String getCardReferenceId() {
        return this.getCardId();
    }

    public String getAdditionalServiceType() {
        if (this.getCardInfo() != null) {
            return this.getCardInfo().getString(ADDITIONAL_SERVICE_TYPE, "");
        }
        return "";
    }

    public String getAdditionalServiceData() {
        if (this.getCardInfo() != null) {
            return this.getCardInfo().getString(ADDITIONAL_SERVICE_DATA, "");
        }
        return "";
    }

    public String getAdditionalServiceDescription() {
        if (this.getCardInfo() != null) {
            return this.getCardInfo().getString(ADDITIONAL_SERVICE_DESCRIPTION, "");
        }
        return "";
    }

    public String getTransactionId() {
        if (this.getCardInfo() != null) {
            return this.getCardInfo().getString(ADDITIONAL_SERVICE_TRANSACTION_ID, "");
        }
        return "";
    }
}

