/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.payment;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;
import com.samsung.android.sdk.samsungpay.v2.payment.CardInfo;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.AddressControl;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.AmountBoxControl;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.CustomSheet;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetControl;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetItemType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CustomSheetPaymentInfo
implements Parcelable {
    private String version;
    private String merchantId;
    private String merchantName;
    private String orderNumber;
    private PaymentProtocol paymentProtocol;
    private AddressInPaymentSheet addressInPaymentSheet = AddressInPaymentSheet.DO_NOT_SHOW;
    private List<SpaySdk.Brand> allowedCardBrand;
    private CardInfo cardInfo;
    private boolean isCardHolderNameRequired = false;
    private boolean isRecurring = false;
    private String merchantCountryCode;
    private CustomSheet customSheet;
    private Bundle extraPaymentInfo;
    public static final Parcelable.Creator<CustomSheetPaymentInfo> CREATOR = new Parcelable.Creator<CustomSheetPaymentInfo>(){

        @NonNull
        public CustomSheetPaymentInfo createFromParcel(@NonNull Parcel source) {
            return new CustomSheetPaymentInfo(source);
        }

        @NonNull
        public CustomSheetPaymentInfo[] newArray(int size) {
            return new CustomSheetPaymentInfo[size];
        }
    };

    private CustomSheetPaymentInfo() {
    }

    private CustomSheetPaymentInfo(@NonNull Builder builder) {
        this.version = SpaySdk.getVersionName();
        this.merchantId = builder.merchantId;
        this.merchantName = builder.merchantName;
        this.orderNumber = builder.orderNumber;
        this.paymentProtocol = builder.paymentProtocol;
        this.addressInPaymentSheet = builder.addressInPaymentSheet != null ? builder.addressInPaymentSheet : AddressInPaymentSheet.DO_NOT_SHOW;
        this.allowedCardBrand = builder.allowedCardBrand;
        this.cardInfo = builder.cardInfo;
        this.isCardHolderNameRequired = builder.isCardHolderNameRequired;
        this.isRecurring = builder.isRecurring;
        this.merchantCountryCode = builder.merchantCountryCode;
        this.customSheet = builder.customSheet;
        this.extraPaymentInfo = builder.extraPaymentInfo;
    }

    public CustomSheetPaymentInfo(@NonNull Parcel source) {
        this.readFromParcel(source);
    }

    public void readFromParcel(@NonNull Parcel source) {
        this.version = (String)source.readValue(String.class.getClassLoader());
        this.merchantId = (String)source.readValue(String.class.getClassLoader());
        this.merchantName = (String)source.readValue(String.class.getClassLoader());
        this.orderNumber = (String)source.readValue(String.class.getClassLoader());
        this.paymentProtocol = (PaymentProtocol)((Object)source.readValue(PaymentProtocol.class.getClassLoader()));
        this.addressInPaymentSheet = (AddressInPaymentSheet)((Object)source.readValue(AddressInPaymentSheet.class.getClassLoader()));
        this.allowedCardBrand = new ArrayList<SpaySdk.Brand>();
        source.readTypedList(this.allowedCardBrand, SpaySdk.Brand.CREATOR);
        this.cardInfo = (CardInfo)source.readValue(CardInfo.class.getClassLoader());
        this.isCardHolderNameRequired = (Boolean)source.readValue(Boolean.class.getClassLoader());
        this.isRecurring = (Boolean)source.readValue(Boolean.class.getClassLoader());
        this.merchantCountryCode = (String)source.readValue(String.class.getClassLoader());
        this.customSheet = (CustomSheet)source.readParcelable(CustomSheet.class.getClassLoader());
        this.extraPaymentInfo = source.readBundle();
    }

    public String getVersion() {
        return this.version;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    @Deprecated
    public PaymentProtocol getPaymentProtocol() {
        return this.paymentProtocol;
    }

    public AddressInPaymentSheet getAddressInPaymentSheet() {
        return this.addressInPaymentSheet;
    }

    public List<SpaySdk.Brand> getAllowedCardBrands() {
        return this.allowedCardBrand;
    }

    public CardInfo getCardInfo() {
        return this.cardInfo;
    }

    public boolean getIsCardHolderNameRequired() {
        return this.isCardHolderNameRequired;
    }

    public boolean getIsRecurring() {
        return this.isRecurring;
    }

    public String getMerchantCountryCode() {
        return this.merchantCountryCode;
    }

    public Bundle getExtraPaymentInfo() {
        return this.extraPaymentInfo;
    }

    public CustomSheet getCustomSheet() {
        return this.customSheet;
    }

    public boolean isEnableEnforcePaymentSheet() {
        this.nullCheckExtraPaymentInfo();
        return this.extraPaymentInfo.getBoolean("enforcePaymentSheet", false);
    }

    @Deprecated
    public boolean isFastCheckout() {
        this.nullCheckExtraPaymentInfo();
        return this.extraPaymentInfo.getBoolean("fastCheckOutStatus", false);
    }

    public String getPaymentCardLast4DPAN() {
        this.nullCheckExtraPaymentInfo();
        return this.extraPaymentInfo.getString("last4Dpan", "");
    }

    public String getPaymentCardLast4FPAN() {
        this.nullCheckExtraPaymentInfo();
        return this.extraPaymentInfo.getString("last4Fpan", "");
    }

    @NonNull
    public SpaySdk.Brand getPaymentCardBrand() {
        this.nullCheckExtraPaymentInfo();
        return SpaySdk.Brand.valueOf(this.extraPaymentInfo.getString("cardBrand", "UNKNOWN_CARD"));
    }

    public String getPaymentCurrencyCode() {
        if (this.customSheet != null) {
            for (SheetControl sheet : this.customSheet.getSheetControls()) {
                if (sheet.getControltype() != SheetControl.Controltype.AMOUNTBOX) continue;
                AmountBoxControl amountBoxControl = (AmountBoxControl)sheet;
                return amountBoxControl.getCurrencyCode();
            }
        }
        return "";
    }

    public Address getPaymentShippingAddress() {
        if (this.customSheet != null) {
            for (SheetControl sheet : this.customSheet.getSheetControls()) {
                AddressControl addressControl;
                if (sheet.getControltype() != SheetControl.Controltype.ADDRESS || (addressControl = (AddressControl)sheet).getAddressType() != SheetItemType.SHIPPING_ADDRESS) continue;
                return addressControl.getAddress();
            }
        }
        return new Address.Builder().build();
    }

    public String getPaymentShippingMethod() {
        this.nullCheckExtraPaymentInfo();
        return this.extraPaymentInfo.getString("shippingMethod", "");
    }

    private void nullCheckExtraPaymentInfo() {
        if (this.extraPaymentInfo == null) {
            this.extraPaymentInfo = new Bundle();
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeValue((Object)this.version);
        dest.writeValue((Object)this.merchantId);
        dest.writeValue((Object)this.merchantName);
        dest.writeValue((Object)this.orderNumber);
        dest.writeValue((Object)this.paymentProtocol);
        dest.writeValue((Object)this.addressInPaymentSheet);
        dest.writeTypedList(this.allowedCardBrand);
        dest.writeValue((Object)this.cardInfo);
        dest.writeValue((Object)this.isCardHolderNameRequired);
        dest.writeValue((Object)this.isRecurring);
        dest.writeValue((Object)this.merchantCountryCode);
        dest.writeParcelable((Parcelable)this.customSheet, flags);
        dest.writeBundle(this.extraPaymentInfo);
    }

    public static class Builder {
        private String merchantId;
        private String merchantName;
        private String orderNumber;
        private PaymentProtocol paymentProtocol;
        private AddressInPaymentSheet addressInPaymentSheet;
        private List<SpaySdk.Brand> allowedCardBrand = new ArrayList<SpaySdk.Brand>();
        private CardInfo cardInfo;
        private boolean isCardHolderNameRequired;
        private boolean isRecurring;
        private String merchantCountryCode;
        private CustomSheet customSheet;
        private Bundle extraPaymentInfo;

        @NonNull
        public Builder setMerchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        @NonNull
        public Builder setMerchantName(String merchantName) {
            this.merchantName = merchantName;
            return this;
        }

        @NonNull
        public Builder setOrderNumber(String orderNumber) {
            this.orderNumber = orderNumber;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setPaymentProtocol(PaymentProtocol paymentProtocol) {
            this.paymentProtocol = paymentProtocol;
            return this;
        }

        @NonNull
        public Builder setAddressInPaymentSheet(AddressInPaymentSheet addressInPaymentSheet) {
            this.addressInPaymentSheet = addressInPaymentSheet;
            return this;
        }

        @NonNull
        public Builder setAllowedCardBrands(List<SpaySdk.Brand> brands) {
            this.allowedCardBrand = brands;
            return this;
        }

        @NonNull
        public Builder setCardInfo(CardInfo cardInfo) {
            this.cardInfo = cardInfo;
            return this;
        }

        @NonNull
        public Builder setCardHolderNameEnabled(boolean isCardHolderNameRequired) {
            this.isCardHolderNameRequired = isCardHolderNameRequired;
            return this;
        }

        @NonNull
        public Builder setRecurringEnabled(boolean isRecurring) {
            this.isRecurring = isRecurring;
            return this;
        }

        @NonNull
        public Builder setMerchantCountryCode(@Nullable String merchantCountryCode) {
            Locale[] localeList;
            if (merchantCountryCode != null && merchantCountryCode.isEmpty()) {
                throw new IllegalArgumentException("merchant country code is empty.");
            }
            for (Locale locale : localeList = Locale.getAvailableLocales()) {
                try {
                    if (!locale.getCountry().equals(merchantCountryCode)) continue;
                    this.merchantCountryCode = locale.getCountry();
                    return this;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException(merchantCountryCode + " is invalid merchant country code.");
        }

        @NonNull
        public Builder setCustomSheet(CustomSheet customSheet) {
            this.customSheet = customSheet;
            return this;
        }

        @NonNull
        public Builder setExtraPaymentInfo(Bundle extraPaymentInfo) {
            this.extraPaymentInfo = extraPaymentInfo;
            return this;
        }

        @NonNull
        public Builder enableEnforcePaymentSheet() {
            this.nullCheckExtraPaymentInfo();
            this.extraPaymentInfo.putBoolean("enforcePaymentSheet", true);
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setFastCheckoutStatus(boolean value) {
            this.nullCheckExtraPaymentInfo();
            this.extraPaymentInfo.putBoolean("fastCheckOutStatus", value);
            return this;
        }

        @NonNull
        public Builder setPaymentCardLast4DPAN(String last4digits) {
            this.nullCheckExtraPaymentInfo();
            this.extraPaymentInfo.putString("last4Dpan", last4digits);
            return this;
        }

        @NonNull
        public Builder setPaymentCardLast4FPAN(String last4digits) {
            this.nullCheckExtraPaymentInfo();
            this.extraPaymentInfo.putString("last4Fpan", last4digits);
            return this;
        }

        @NonNull
        public Builder setPaymentCardBrand(@NonNull SpaySdk.Brand cardBrand) {
            this.nullCheckExtraPaymentInfo();
            this.extraPaymentInfo.putString("cardBrand", cardBrand.name());
            return this;
        }

        @NonNull
        public Builder setPaymentShippingMethod(String shippingMethod) {
            this.nullCheckExtraPaymentInfo();
            this.extraPaymentInfo.putString("shippingMethod", shippingMethod);
            return this;
        }

        private void nullCheckExtraPaymentInfo() {
            if (this.extraPaymentInfo == null) {
                this.extraPaymentInfo = new Bundle();
            }
        }

        @NonNull
        public CustomSheetPaymentInfo build() {
            return new CustomSheetPaymentInfo(this);
        }
    }

    public static enum AddressInPaymentSheet implements Parcelable
    {
        DO_NOT_SHOW,
        NEED_BILLING_SPAY,
        NEED_SHIPPING_SPAY,
        SEND_SHIPPING,
        NEED_BILLING_SEND_SHIPPING,
        NEED_BILLING_AND_SHIPPING;

        public static final Parcelable.Creator<AddressInPaymentSheet> CREATOR;

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<AddressInPaymentSheet>(){

                public AddressInPaymentSheet createFromParcel(@NonNull Parcel in) {
                    return AddressInPaymentSheet.values()[in.readInt()];
                }

                @Nullable
                public AddressInPaymentSheet[] newArray(int size) {
                    return null;
                }
            };
        }
    }

    @Deprecated
    public static enum PaymentProtocol implements Parcelable
    {
        PROTOCOL_3DS,
        PROTOCOL_EMV,
        PROTOCOL_COF,
        PROTOCOL_OTHER;

        public static final Parcelable.Creator<PaymentProtocol> CREATOR;

        @NonNull
        public static PaymentProtocol convert(String type) {
            if ((type = type.toUpperCase(Locale.US)).contains("3DS")) {
                return PROTOCOL_3DS;
            }
            if (type.contains("EMV")) {
                return PROTOCOL_EMV;
            }
            return PROTOCOL_OTHER;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<PaymentProtocol>(){

                public PaymentProtocol createFromParcel(@NonNull Parcel in) {
                    return PaymentProtocol.values()[in.readInt()];
                }

                @NonNull
                public PaymentProtocol[] newArray(int size) {
                    return new PaymentProtocol[size];
                }
            };
        }
    }

    public static class Address
    implements Parcelable {
        protected static final String EXTRA_EMAIL_ADDRESS = "emailAddress";
        protected String version;
        protected String addressee;
        protected String addressLine1;
        protected String addressLine2;
        protected String city;
        protected String state;
        protected String countryCode;
        protected String postalCode;
        protected String phoneNumber;
        protected Bundle extraAddressInfo;
        @Nullable
        protected String email;
        protected static final String KEY_VERSION = "version";
        protected static final String KEY_ADDRESSEE = "addressee";
        protected static final String KEY_ADDRESS_LINE1 = "addressLine1";
        protected static final String KEY_ADDRESS_LINE2 = "addressLine2";
        protected static final String KEY_CITY = "city";
        protected static final String KEY_STATE = "state";
        protected static final String KEY_COUNTRY_CODE = "countryCode";
        protected static final String KEY_POSTAL_CODE = "postalCode";
        protected static final String KEY_PHONE_NUMBER = "phoneNumber";
        protected static final String KEY_EXTRA_INFO = "extraAddressInfo";
        public static final Parcelable.Creator<Address> CREATOR = new Parcelable.Creator<Address>(){

            @NonNull
            public Address createFromParcel(@NonNull Parcel source) {
                return new Address(source);
            }

            @NonNull
            public Address[] newArray(int size) {
                return new Address[size];
            }
        };

        protected Address() {
        }

        private Address(@NonNull Builder builder) {
            this.version = SpaySdk.getVersionName();
            this.addressee = builder.addressee;
            this.addressLine1 = builder.addressLine1;
            this.addressLine2 = builder.addressLine2;
            this.city = builder.city;
            this.state = builder.state;
            this.countryCode = builder.countryCode;
            this.postalCode = builder.postalCode;
            this.phoneNumber = builder.phoneNumber;
            this.extraAddressInfo = builder.extraAddressInfo;
            this.email = builder.email;
        }

        public Address(@NonNull Parcel source) {
            this.version = (String)source.readValue(String.class.getClassLoader());
            this.addressee = (String)source.readValue(String.class.getClassLoader());
            this.addressLine1 = (String)source.readValue(String.class.getClassLoader());
            this.addressLine2 = (String)source.readValue(String.class.getClassLoader());
            this.city = (String)source.readValue(String.class.getClassLoader());
            this.state = (String)source.readValue(String.class.getClassLoader());
            this.countryCode = (String)source.readValue(String.class.getClassLoader());
            this.postalCode = (String)source.readValue(String.class.getClassLoader());
            this.phoneNumber = (String)source.readValue(String.class.getClassLoader());
            this.extraAddressInfo = source.readBundle();
            if (this.extraAddressInfo != null) {
                this.email = this.extraAddressInfo.getString(EXTRA_EMAIL_ADDRESS);
            }
        }

        @NonNull
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putString(KEY_VERSION, this.version);
            bundle.putString(KEY_ADDRESSEE, this.addressee);
            bundle.putString(KEY_ADDRESS_LINE1, this.addressLine1);
            bundle.putString(KEY_ADDRESS_LINE2, this.addressLine2);
            bundle.putString(KEY_CITY, this.city);
            bundle.putString(KEY_STATE, this.state);
            bundle.putString(KEY_COUNTRY_CODE, this.countryCode);
            bundle.putString(KEY_POSTAL_CODE, this.postalCode);
            bundle.putString(KEY_PHONE_NUMBER, this.phoneNumber);
            if (this.extraAddressInfo == null) {
                this.extraAddressInfo = new Bundle();
            }
            this.extraAddressInfo.putString(EXTRA_EMAIL_ADDRESS, this.email);
            bundle.putBundle(KEY_EXTRA_INFO, this.extraAddressInfo);
            return bundle;
        }

        public String getAddressee() {
            return this.addressee;
        }

        public String getAddressLine1() {
            return this.addressLine1;
        }

        public String getAddressLine2() {
            return this.addressLine2;
        }

        public String getCity() {
            return this.city;
        }

        public String getState() {
            return this.state;
        }

        public String getCountryCode() {
            return this.countryCode;
        }

        public String getPostalCode() {
            return this.postalCode;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public Bundle getExtraAddressInfo() {
            return this.extraAddressInfo;
        }

        public String getEmail() {
            return this.email;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeValue((Object)this.version);
            dest.writeValue((Object)this.addressee);
            dest.writeValue((Object)this.addressLine1);
            dest.writeValue((Object)this.addressLine2);
            dest.writeValue((Object)this.city);
            dest.writeValue((Object)this.state);
            dest.writeValue((Object)this.countryCode);
            dest.writeValue((Object)this.postalCode);
            dest.writeValue((Object)this.phoneNumber);
            dest.writeBundle(this.extraAddressInfo);
        }

        public static class Builder {
            @Nullable
            protected String addressee;
            @Nullable
            protected String addressLine1;
            @Nullable
            protected String addressLine2;
            @Nullable
            protected String city;
            @Nullable
            protected String state;
            @Nullable
            protected String countryCode;
            @Nullable
            protected String postalCode;
            @Nullable
            protected String phoneNumber;
            @Nullable
            protected Bundle extraAddressInfo;
            @Nullable
            protected String email;

            public Builder() {
            }

            public Builder(@NonNull Bundle bundle) {
                this.addressee = bundle.getString(Address.KEY_ADDRESSEE);
                this.addressLine1 = bundle.getString(Address.KEY_ADDRESS_LINE1);
                this.addressLine2 = bundle.getString(Address.KEY_ADDRESS_LINE2);
                this.city = bundle.getString(Address.KEY_CITY);
                this.state = bundle.getString(Address.KEY_STATE);
                this.countryCode = bundle.getString(Address.KEY_COUNTRY_CODE);
                this.postalCode = bundle.getString(Address.KEY_POSTAL_CODE);
                this.phoneNumber = bundle.getString(Address.KEY_PHONE_NUMBER);
                this.extraAddressInfo = bundle.getBundle(Address.KEY_EXTRA_INFO);
                if (this.extraAddressInfo != null) {
                    this.email = this.extraAddressInfo.getString(Address.EXTRA_EMAIL_ADDRESS);
                }
            }

            @NonNull
            public Builder setAddressee(String addressee) {
                this.addressee = addressee;
                return this;
            }

            @NonNull
            public Builder setAddressLine1(String addressLine1) {
                this.addressLine1 = addressLine1;
                return this;
            }

            @NonNull
            public Builder setAddressLine2(String addressLine2) {
                this.addressLine2 = addressLine2;
                return this;
            }

            @NonNull
            public Builder setCity(String city) {
                this.city = city;
                return this;
            }

            @NonNull
            public Builder setState(String state) {
                this.state = state;
                return this;
            }

            @NonNull
            public Builder setCountryCode(@NonNull String country3DigitCode) {
                String[] codes;
                if (country3DigitCode.isEmpty()) {
                    throw new IllegalArgumentException("country3DigitCode is empty");
                }
                for (String code2Digit : codes = Locale.getISOCountries()) {
                    Locale locale = new Locale("", code2Digit);
                    try {
                        if (!locale.getISO3Country().equals(country3DigitCode)) continue;
                        this.countryCode = country3DigitCode;
                        return this;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new IllegalArgumentException(this.countryCode + "countryCode is invalid ");
            }

            @NonNull
            public Builder setPostalCode(String postalCode) {
                this.postalCode = postalCode;
                return this;
            }

            @NonNull
            public Builder setPhoneNumber(String phoneNumber) {
                this.phoneNumber = phoneNumber;
                return this;
            }

            @NonNull
            public Builder setExtraAddressInfo(Bundle extraAddressInfo) {
                this.extraAddressInfo = extraAddressInfo;
                return this;
            }

            @NonNull
            public Builder setEmail(String email) {
                this.email = email;
                if (this.extraAddressInfo == null) {
                    this.extraAddressInfo = new Bundle();
                }
                this.extraAddressInfo.putString(Address.EXTRA_EMAIL_ADDRESS, email);
                return this;
            }

            @NonNull
            public Address build() {
                return new Address(this);
            }
        }
    }
}

