/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.payment;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.samsung.android.sdk.samsungpay.v2.ISStatusListener;
import com.samsung.android.sdk.samsungpay.v2.PartnerInfo;
import com.samsung.android.sdk.samsungpay.v2.payment.CardInfo;
import com.samsung.android.sdk.samsungpay.v2.payment.CustomSheetPaymentInfo;
import com.samsung.android.sdk.samsungpay.v2.payment.ISGetCardBrandListener;
import com.samsung.android.sdk.samsungpay.v2.payment.ISPaymentCallback;
import com.samsung.android.sdk.samsungpay.v2.payment.PaymentInfo;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.CustomSheet;
import com.samsung.android.sdk.samsungpay.v2.service.ISUserInfoCallback;
import com.samsung.android.sdk.samsungpay.v2.service.RequestType;
import java.util.ArrayList;
import java.util.List;

public interface ISPaymentManager
extends IInterface {
    public void initiateSession(PartnerInfo var1, PaymentInfo var2, ISPaymentCallback var3) throws RemoteException;

    public void terminateSession() throws RemoteException;

    public int updateAmount(PaymentInfo.Amount var1) throws RemoteException;

    public int invalidAddress(int var1) throws RemoteException;

    public List<CardInfo> requestCardType(Bundle var1, PartnerInfo var2, ISGetCardBrandListener var3) throws RemoteException;

    public boolean isSamsungPaySetupCompleted() throws RemoteException;

    public void startSimplePay(PartnerInfo var1, CardInfo var2, ISStatusListener var3) throws RemoteException;

    public void initiateSessionWithSheetInfo(PartnerInfo var1, ISPaymentCallback var2, CustomSheetPaymentInfo var3, RequestType[] var4, ISUserInfoCallback var5) throws RemoteException;

    public int updateSheet(CustomSheet var1) throws RemoteException;

    public int updateSheetWithCustomMessage(CustomSheet var1, int var2, String var3) throws RemoteException;

    public void getFastCheckoutStatus(PartnerInfo var1, ISStatusListener var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISPaymentManager {
        private static final String DESCRIPTOR = "com.samsung.android.sdk.samsungpay.v2.payment.ISPaymentManager";
        static final int TRANSACTION_initiateSession = 1;
        static final int TRANSACTION_terminateSession = 2;
        static final int TRANSACTION_updateAmount = 3;
        static final int TRANSACTION_invalidAddress = 4;
        static final int TRANSACTION_requestCardType = 5;
        static final int TRANSACTION_isSamsungPaySetupCompleted = 6;
        static final int TRANSACTION_startSimplePay = 7;
        static final int TRANSACTION_initiateSessionWithSheetInfo = 8;
        static final int TRANSACTION_updateSheet = 9;
        static final int TRANSACTION_updateSheetWithCustomMessage = 10;
        static final int TRANSACTION_getFastCheckoutStatus = 11;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISPaymentManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISPaymentManager) {
                return (ISPaymentManager)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    PartnerInfo _arg0 = 0 != data.readInt() ? (PartnerInfo)PartnerInfo.CREATOR.createFromParcel(data) : null;
                    PaymentInfo _arg1 = 0 != data.readInt() ? (PaymentInfo)PaymentInfo.CREATOR.createFromParcel(data) : null;
                    ISPaymentCallback _arg2 = ISPaymentCallback.Stub.asInterface(data.readStrongBinder());
                    this.initiateSession(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.terminateSession();
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    PaymentInfo.Amount _arg0 = 0 != data.readInt() ? (PaymentInfo.Amount)PaymentInfo.Amount.CREATOR.createFromParcel(data) : null;
                    int _result = this.updateAmount(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.invalidAddress(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    Bundle _arg0 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    PartnerInfo _arg1 = 0 != data.readInt() ? (PartnerInfo)PartnerInfo.CREATOR.createFromParcel(data) : null;
                    ISGetCardBrandListener _arg2 = ISGetCardBrandListener.Stub.asInterface(data.readStrongBinder());
                    List _result = this.requestCardType(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isSamsungPaySetupCompleted();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    PartnerInfo _arg0 = 0 != data.readInt() ? (PartnerInfo)PartnerInfo.CREATOR.createFromParcel(data) : null;
                    CardInfo _arg1 = 0 != data.readInt() ? (CardInfo)CardInfo.CREATOR.createFromParcel(data) : null;
                    ISStatusListener _arg2 = ISStatusListener.Stub.asInterface(data.readStrongBinder());
                    this.startSimplePay(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    PartnerInfo _arg0 = 0 != data.readInt() ? (PartnerInfo)PartnerInfo.CREATOR.createFromParcel(data) : null;
                    ISPaymentCallback _arg1 = ISPaymentCallback.Stub.asInterface(data.readStrongBinder());
                    CustomSheetPaymentInfo _arg2 = 0 != data.readInt() ? (CustomSheetPaymentInfo)CustomSheetPaymentInfo.CREATOR.createFromParcel(data) : null;
                    RequestType[] _arg3 = (RequestType[])data.createTypedArray(RequestType.CREATOR);
                    ISUserInfoCallback _arg4 = ISUserInfoCallback.Stub.asInterface(data.readStrongBinder());
                    this.initiateSessionWithSheetInfo(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    CustomSheet _arg0 = 0 != data.readInt() ? (CustomSheet)CustomSheet.CREATOR.createFromParcel(data) : null;
                    int _result = this.updateSheet(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    CustomSheet _arg0 = 0 != data.readInt() ? (CustomSheet)CustomSheet.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _result = this.updateSheetWithCustomMessage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    PartnerInfo _arg0 = 0 != data.readInt() ? (PartnerInfo)PartnerInfo.CREATOR.createFromParcel(data) : null;
                    ISStatusListener _arg1 = ISStatusListener.Stub.asInterface(data.readStrongBinder());
                    this.getFastCheckoutStatus(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ISPaymentManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ISPaymentManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ISPaymentManager {
            private IBinder mRemote;
            public static ISPaymentManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initiateSession(PartnerInfo pInfo, PaymentInfo request, ISPaymentCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (pInfo != null) {
                        _data.writeInt(1);
                        pInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().initiateSession(pInfo, request, callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void terminateSession() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().terminateSession();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int updateAmount(PaymentInfo.Amount amount) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (amount != null) {
                        _data.writeInt(1);
                        amount.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().updateAmount(amount);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int invalidAddress(int errorcode) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(errorcode);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().invalidAddress(errorcode);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<CardInfo> requestCardType(Bundle requestFilter, PartnerInfo pInfo, ISGetCardBrandListener callback) throws RemoteException {
                ArrayList _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (requestFilter != null) {
                        _data.writeInt(1);
                        requestFilter.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (pInfo != null) {
                        _data.writeInt(1);
                        pInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<CardInfo> list = Stub.getDefaultImpl().requestCardType(requestFilter, pInfo, callback);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(CardInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSamsungPaySetupCompleted() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isSamsungPaySetupCompleted();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startSimplePay(PartnerInfo pInfo, CardInfo cardInfo, ISStatusListener cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (pInfo != null) {
                        _data.writeInt(1);
                        pInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (cardInfo != null) {
                        _data.writeInt(1);
                        cardInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(cb != null ? cb.asBinder() : null);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startSimplePay(pInfo, cardInfo, cb);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initiateSessionWithSheetInfo(PartnerInfo pInfo, ISPaymentCallback callback, CustomSheetPaymentInfo request, RequestType[] requiredTypes, ISUserInfoCallback userInfoCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (pInfo != null) {
                        _data.writeInt(1);
                        pInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedArray((Parcelable[])requiredTypes, 0);
                    _data.writeStrongBinder(userInfoCallback != null ? userInfoCallback.asBinder() : null);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().initiateSessionWithSheetInfo(pInfo, callback, request, requiredTypes, userInfoCallback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int updateSheet(CustomSheet customSheet) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (customSheet != null) {
                        _data.writeInt(1);
                        customSheet.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().updateSheet(customSheet);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int updateSheetWithCustomMessage(CustomSheet customSheet, int errorCode, String customErrorMessage) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (customSheet != null) {
                        _data.writeInt(1);
                        customSheet.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(errorCode);
                    _data.writeString(customErrorMessage);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().updateSheetWithCustomMessage(customSheet, errorCode, customErrorMessage);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getFastCheckoutStatus(PartnerInfo pInfo, ISStatusListener cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (pInfo != null) {
                        _data.writeInt(1);
                        pInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(cb != null ? cb.asBinder() : null);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getFastCheckoutStatus(pInfo, cb);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISPaymentManager {
        @Override
        public void initiateSession(PartnerInfo pInfo, PaymentInfo request, ISPaymentCallback callback) throws RemoteException {
        }

        @Override
        public void terminateSession() throws RemoteException {
        }

        @Override
        public int updateAmount(PaymentInfo.Amount amount) throws RemoteException {
            return 0;
        }

        @Override
        public int invalidAddress(int errorcode) throws RemoteException {
            return 0;
        }

        @Override
        public List<CardInfo> requestCardType(Bundle requestFilter, PartnerInfo pInfo, ISGetCardBrandListener callback) throws RemoteException {
            return null;
        }

        @Override
        public boolean isSamsungPaySetupCompleted() throws RemoteException {
            return false;
        }

        @Override
        public void startSimplePay(PartnerInfo pInfo, CardInfo cardInfo, ISStatusListener cb) throws RemoteException {
        }

        @Override
        public void initiateSessionWithSheetInfo(PartnerInfo pInfo, ISPaymentCallback callback, CustomSheetPaymentInfo request, RequestType[] requiredTypes, ISUserInfoCallback userInfoCallback) throws RemoteException {
        }

        @Override
        public int updateSheet(CustomSheet customSheet) throws RemoteException {
            return 0;
        }

        @Override
        public int updateSheetWithCustomMessage(CustomSheet customSheet, int errorCode, String customErrorMessage) throws RemoteException {
            return 0;
        }

        @Override
        public void getFastCheckoutStatus(PartnerInfo pInfo, ISStatusListener cb) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

