/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.payment;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.PartnerInfo;
import com.samsung.android.sdk.samsungpay.v2.PartnerRequest;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;
import com.samsung.android.sdk.samsungpay.v2.StubBase;
import com.samsung.android.sdk.samsungpay.v2.payment.EncryptionKeyListener;
import com.samsung.android.sdk.samsungpay.v2.payment.ISEncryptionKeyListener;
import com.samsung.android.sdk.samsungpay.v2.payment.ISMstManager;
import com.samsung.android.sdk.samsungpay.v2.payment.ISMstPaymentListener;
import com.samsung.android.sdk.samsungpay.v2.payment.ISTransactionResultListener;
import com.samsung.android.sdk.samsungpay.v2.payment.MstPaymentInfo;
import com.samsung.android.sdk.samsungpay.v2.payment.MstPaymentListener;
import com.samsung.android.sdk.samsungpay.v2.payment.SpayPublicKey;
import com.samsung.android.sdk.samsungpay.v2.payment.SpayResponseInfo;
import com.samsung.android.sdk.samsungpay.v2.payment.TransactionResultInfo;
import com.samsung.android.sdk.samsungpay.v2.payment.TransactionResultListener;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;

public final class MstManager
extends SpaySdk {
    private static final String TAG = "SPAYSDK:MstManager";
    private static final int OPT_GET_TOKEN_ENCRYPTION_KEY = 1;
    private static final int OPT_START_MST = 2;
    private static final int OPT_STOP_MST = 3;
    private static final int OPT_SEND_TRANSACTION = 4;
    private StubBase<ISMstManager> mMstManagerStub;
    private SpayPublicKey publicKey;
    private SpayResponseInfo spayResponseInfo;
    private SoftReference<Activity> mActivityReference;
    public static final int ERROR_SPAY_MST_OVERSEAS_NOT_SUPPORTED = -601;
    public static final int ERROR_SPAY_MST_NOT_PREPARED = -602;
    public static final int ERROR_SPAY_USIM_CHANGED = -603;
    @NonNull
    protected Handler mHandlerForInternalListener = new Handler(Looper.getMainLooper()){

        public void handleMessage(@NonNull Message msg) {
            switch (msg.what) {
                case 0: {
                    if (msg.obj instanceof EncryptionKeyListener) {
                        ((EncryptionKeyListener)msg.obj).onSuccess(MstManager.this.publicKey);
                        break;
                    }
                    if (msg.obj instanceof MstPaymentListener) {
                        ((MstPaymentListener)msg.obj).onSuccess(MstManager.this.spayResponseInfo);
                        break;
                    }
                    if (msg.obj instanceof TransactionResultListener) {
                        ((TransactionResultListener)msg.obj).onSuccess(msg.getData());
                        break;
                    }
                    Log.e((String)MstManager.TAG, (String)"[onSuccess] Wrong listener was called");
                    break;
                }
                case 1: {
                    if (msg.obj instanceof EncryptionKeyListener) {
                        ((EncryptionKeyListener)msg.obj).onFail(msg.arg1, msg.getData());
                        break;
                    }
                    if (msg.obj instanceof MstPaymentListener) {
                        ((MstPaymentListener)msg.obj).onFail(msg.arg1, msg.getData());
                        break;
                    }
                    if (msg.obj instanceof TransactionResultListener) {
                        ((TransactionResultListener)msg.obj).onFail(msg.arg1, msg.getData());
                        break;
                    }
                    Log.e((String)MstManager.TAG, (String)"[onFail] Wrong listener was called");
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    Log.e((String)MstManager.TAG, (String)"sdk can not catch listener from SPay.");
                }
            }
        }
    };

    public MstManager(@NonNull Context context, @NonNull PartnerInfo partnerInfo) {
        super(context, partnerInfo);
        Log.d((String)TAG, (String)"MstManager()");
        this.mMstManagerStub = new StubBase.Creator<ISMstManager>().createStub(context, "com.samsung.android.spay.sdk.v2.service.MstService", ISMstManager.Stub::asInterface);
    }

    public void getTokenEncryptionKey(@NonNull EncryptionKeyListener listener) {
        Log.d((String)TAG, (String)"getTokenEncryptionKey() : SDK API Level = 2.1");
        this.assertNotNull(listener);
        EncryptionKeyListenerInternal listenerInternal = new EncryptionKeyListenerInternal();
        PartnerRequest pReq = new PartnerRequest.Builder(this, 1, listener).setName("getTokenEncryptionKey").onExecute((stub, request) -> ((ISMstManager)stub).getTokenEncryptionKey(this.getPartnerInfo(), listenerInternal.getEncryptionKeyListener())).onError((errorType, errorCode, errorExtra) -> listener.onFail(errorCode, errorExtra)).create();
        listenerInternal.set(pReq);
        this.mMstManagerStub.postRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_2_1);
    }

    public void startMST(Activity activity, MstPaymentInfo mstPaymentInfo, @NonNull MstPaymentListener listener) {
        Log.d((String)TAG, (String)"startMST() : SDK API Level = 2.1");
        this.assertNotNull(listener);
        this.assertNotNull(mstPaymentInfo);
        this.mActivityReference = new SoftReference<Activity>(activity);
        MstPaymentListenerInternal listenerInternal = new MstPaymentListenerInternal();
        PartnerRequest pReq = new PartnerRequest.Builder(this, 2, listener).setName("startMST").onExecute((stub, request) -> {
            ((ISMstManager)stub).startMST(this.getPartnerInfo(), mstPaymentInfo, listenerInternal.getMstPaymentListener());
            this.keepScreenOn(true);
        }).onError((errorType, errorCode, errorExtra) -> listener.onFail(errorCode, errorExtra)).create();
        listenerInternal.set(pReq);
        this.mMstManagerStub.postRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_2_1);
    }

    @Deprecated
    public void stopMST() {
        Log.d((String)TAG, (String)"stopMST() : SDK API Level = 2.1");
        this.stopMST(null);
    }

    public void stopMST(@Nullable MstPaymentListener listener) {
        Log.d((String)TAG, (String)"stopMST() : SDK API Level = 2.3");
        PartnerRequest pReq = new PartnerRequest.Builder(this, 3, listener).setName("stopMST").onExecute((stub, request) -> {
            ISMstPaymentListener mstPaymentListener = this.createStopMstListener(listener);
            ((ISMstManager)stub).stopMST(this.getPartnerInfo(), mstPaymentListener);
            this.keepScreenOn(false);
            this.mMstManagerStub.nextRequest();
        }).onError((errorType, errorCode, errorExtra) -> {
            if (listener != null) {
                listener.onFail(errorCode, errorExtra);
            }
        }).create();
        this.mMstManagerStub.cancelledPendingTasks(false);
        this.mMstManagerStub.postRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_2_3);
    }

    public void sendTransactionResultInfo(TransactionResultInfo mstTransactionResultInfo, @NonNull TransactionResultListener listener) {
        Log.d((String)TAG, (String)"sendTransactionResultInfo() : SDK API Level = 2.1");
        this.assertNotNull(listener);
        this.assertNotNull(mstTransactionResultInfo);
        MstTransactionListenerInternal listenerInternal = new MstTransactionListenerInternal();
        PartnerRequest pReq = new PartnerRequest.Builder(this, 4, listener).setName("sendTransactionResultInfo").onExecute((stub, request) -> ((ISMstManager)stub).sendTransactionResultInfo(this.getPartnerInfo(), mstTransactionResultInfo, listenerInternal.getTransactionResultListener())).onError((errorType, errorCode, errorExtra) -> listener.onFail(errorCode, errorExtra)).create();
        listenerInternal.set(pReq);
        this.mMstManagerStub.postRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_2_1);
    }

    protected void sendMsgForEncryptionKeyListener(@Nullable WeakReference<PartnerRequest> requestRef, int result, int arg1, Bundle data) {
        PartnerRequest request;
        if (requestRef == null || (request = (PartnerRequest)requestRef.get()) == null) {
            Log.d((String)TAG, (String)"sendMsgForEncryptionKeyListener -  request is NULL");
            return;
        }
        Message message = Message.obtain((Handler)this.mHandlerForInternalListener);
        message.obj = request.callbackObj;
        message.what = result;
        message.arg1 = arg1;
        message.setData(data);
        this.mHandlerForInternalListener.sendMessage(message);
    }

    protected void sendMsgForMstPaymentListener(@Nullable WeakReference<PartnerRequest> requestRef, int result, int arg1, Bundle data) {
        PartnerRequest request;
        if (requestRef == null || (request = (PartnerRequest)requestRef.get()) == null) {
            Log.d((String)TAG, (String)"sendMsgForMstPaymentListener -  request is NULL");
            return;
        }
        Message message = Message.obtain((Handler)this.mHandlerForInternalListener);
        message.obj = request.callbackObj;
        message.what = result;
        message.arg1 = arg1;
        message.setData(data);
        this.mHandlerForInternalListener.sendMessage(message);
    }

    protected void sendMsgForMstTransactionListener(@Nullable WeakReference<PartnerRequest> requestRef, int result, int arg1, Bundle data) {
        PartnerRequest request;
        if (requestRef == null || (request = (PartnerRequest)requestRef.get()) == null) {
            Log.d((String)TAG, (String)"sendMsgForMstTransactionListener -  request is NULL");
            return;
        }
        Message message = Message.obtain((Handler)this.mHandlerForInternalListener);
        message.obj = request.callbackObj;
        message.what = result;
        message.arg1 = arg1;
        message.setData(data);
        this.mHandlerForInternalListener.sendMessage(message);
    }

    private void keepScreenOn(boolean enabled) {
        Activity activity;
        Log.d((String)TAG, (String)("keepScreenOn - enabled = " + enabled));
        if (this.mActivityReference != null && (activity = this.mActivityReference.get()) != null) {
            activity.runOnUiThread(() -> {
                if (!activity.isDestroyed() && !activity.isFinishing()) {
                    Window window = activity.getWindow();
                    if (enabled) {
                        window.addFlags(524288);
                        window.addFlags(128);
                    } else {
                        window.clearFlags(524288);
                        window.clearFlags(128);
                    }
                    WindowManager.LayoutParams wlp = window.getAttributes();
                    try {
                        Class<?> clazz = Class.forName("android.view.WindowManager$LayoutParams");
                        Field fld = clazz.getField("coverMode");
                        fld.setInt(wlp, enabled ? 1 : 0);
                        window.setAttributes(wlp);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                } else {
                    Log.e((String)TAG, (String)"keepScreenOn - Activity is finishing or destroyed");
                }
            });
        } else {
            Log.e((String)TAG, (String)"keepScreenOn - Activity is NULL");
        }
    }

    @NonNull
    private ISMstPaymentListener createStopMstListener(final @Nullable MstPaymentListener listener) {
        return new ISMstPaymentListener.Stub(){

            @Override
            public void onSuccess(SpayResponseInfo response) {
                if (listener != null) {
                    listener.onSuccess(null);
                }
            }

            @Override
            public void onFail(int errorCode, Bundle errorData) {
                if (listener != null) {
                    listener.onFail(errorCode, errorData);
                }
            }
        };
    }

    private class EncryptionKeyListenerInternal {
        private static final String TAG = "EncryptionKeyListener";
        @Nullable
        private WeakReference<PartnerRequest> pReqRef = null;
        @NonNull
        private SpayEncryptionKeyListener spayEncryptionKeyListener = new SpayEncryptionKeyListener();

        private EncryptionKeyListenerInternal() {
        }

        public void set(PartnerRequest pReq) {
            this.pReqRef = new WeakReference<PartnerRequest>(pReq);
        }

        public ISEncryptionKeyListener getEncryptionKeyListener() {
            return this.spayEncryptionKeyListener;
        }

        private class SpayEncryptionKeyListener
        extends ISEncryptionKeyListener.Stub {
            private SpayEncryptionKeyListener() {
            }

            @Override
            public void onSuccess(SpayPublicKey pubKey) throws RemoteException {
                Log.d((String)EncryptionKeyListenerInternal.TAG, (String)("onSuccess: public key : " + pubKey));
                MstManager.this.mMstManagerStub.nextRequest();
                MstManager.this.publicKey = pubKey;
                MstManager.this.sendMsgForEncryptionKeyListener(EncryptionKeyListenerInternal.this.pReqRef, 0, 0, new Bundle());
            }

            @Override
            public void onFail(int errorCode, Bundle errorData) throws RemoteException {
                Log.e((String)EncryptionKeyListenerInternal.TAG, (String)("onFail: error: " + errorCode));
                MstManager.this.sendMsgForEncryptionKeyListener(EncryptionKeyListenerInternal.this.pReqRef, 1, errorCode, errorData);
                MstManager.this.mMstManagerStub.nextRequest();
            }
        }
    }

    private class MstPaymentListenerInternal {
        private static final String TAG = "MstPaymentListener";
        @Nullable
        private WeakReference<PartnerRequest> pReqRef = null;
        @NonNull
        private SpayMSTPaymentListenerInternal spayMstPaymentListener = new SpayMSTPaymentListenerInternal();

        private MstPaymentListenerInternal() {
        }

        public void set(PartnerRequest pReq) {
            this.pReqRef = new WeakReference<PartnerRequest>(pReq);
        }

        public ISMstPaymentListener getMstPaymentListener() {
            return this.spayMstPaymentListener;
        }

        private class SpayMSTPaymentListenerInternal
        extends ISMstPaymentListener.Stub {
            private SpayMSTPaymentListenerInternal() {
            }

            @Override
            public void onSuccess(@NonNull SpayResponseInfo data) throws RemoteException {
                Log.d((String)MstPaymentListenerInternal.TAG, (String)("onSuccess: Status : " + data.getPayMstStatus()));
                MstManager.this.spayResponseInfo = data;
                int status = data.getPayMstStatus();
                if (status == 27 || status == 21 || status == 0) {
                    MstManager.this.mMstManagerStub.nextRequest();
                    MstManager.this.keepScreenOn(false);
                }
                if (status == 23 || status == 0) {
                    MstManager.this.sendMsgForMstPaymentListener(MstPaymentListenerInternal.this.pReqRef, 0, 0, new Bundle());
                }
            }

            @Override
            public void onFail(int errorCode, Bundle errorData) throws RemoteException {
                Log.e((String)MstPaymentListenerInternal.TAG, (String)("onFail: error: " + errorCode));
                MstManager.this.keepScreenOn(false);
                MstManager.this.sendMsgForMstPaymentListener(MstPaymentListenerInternal.this.pReqRef, 1, errorCode, errorData);
                MstManager.this.mMstManagerStub.nextRequest();
            }
        }
    }

    private class MstTransactionListenerInternal {
        private static final String TAG = "TransactionResult";
        @Nullable
        private WeakReference<PartnerRequest> pReqRef = null;
        @NonNull
        private SpayMstTransactionListenerInternal spayMstTransactionListener = new SpayMstTransactionListenerInternal();

        private MstTransactionListenerInternal() {
        }

        public void set(PartnerRequest pReq) {
            this.pReqRef = new WeakReference<PartnerRequest>(pReq);
        }

        public ISTransactionResultListener getTransactionResultListener() {
            return this.spayMstTransactionListener;
        }

        private class SpayMstTransactionListenerInternal
        extends ISTransactionResultListener.Stub {
            private SpayMstTransactionListenerInternal() {
            }

            @Override
            public void onSuccess(Bundle data) throws RemoteException {
                Log.d((String)MstTransactionListenerInternal.TAG, (String)("onSuccess: data : " + data));
                MstManager.this.sendMsgForMstTransactionListener(MstTransactionListenerInternal.this.pReqRef, 0, 0, data);
                MstManager.this.mMstManagerStub.nextRequest();
            }

            @Override
            public void onFail(int errorCode, Bundle errorData) throws RemoteException {
                Log.e((String)MstTransactionListenerInternal.TAG, (String)("onFail: error: " + errorCode));
                MstManager.this.sendMsgForMstTransactionListener(MstTransactionListenerInternal.this.pReqRef, 1, errorCode, errorData);
                MstManager.this.mMstManagerStub.nextRequest();
            }
        }
    }
}

