/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.payment;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;

public class MstPaymentInfo
implements Parcelable {
    private String transactionReference = "";
    private Long transactionTimestamp = 0L;
    private String transactionSignature = "";
    private String encryptedToken = "";
    private String signedToken = "";
    private String intermediateCA = "";
    private String endEntityCA = "";
    private int durationTime = 0;
    private boolean isRetry = false;
    private boolean isEncrypted = false;
    private Bundle extraData = new Bundle();
    public static final Parcelable.Creator<MstPaymentInfo> CREATOR = new Parcelable.Creator<MstPaymentInfo>(){

        @NonNull
        public MstPaymentInfo createFromParcel(@NonNull Parcel source) {
            return new MstPaymentInfo(source);
        }

        @NonNull
        public MstPaymentInfo[] newArray(int size) {
            return new MstPaymentInfo[size];
        }
    };

    public MstPaymentInfo(@NonNull Builder builder) {
        this.transactionReference = builder.transactionReference;
        this.transactionTimestamp = builder.transactionTimestamp;
        this.transactionSignature = builder.transactionSignature;
        this.encryptedToken = builder.encryptedToken;
        this.signedToken = builder.signedToken;
        this.intermediateCA = builder.intermediateCA;
        this.endEntityCA = builder.endEntityCA;
        this.durationTime = builder.durationTime;
        this.isRetry = builder.isRetry;
        this.isEncrypted = builder.isEncrypted;
        this.extraData = builder.extraData;
    }

    public MstPaymentInfo(@NonNull Parcel source) {
        this.readFromParcel(source);
    }

    public void readFromParcel(@NonNull Parcel source) {
        this.transactionReference = source.readString();
        this.transactionTimestamp = source.readLong();
        this.transactionSignature = source.readString();
        this.encryptedToken = source.readString();
        this.signedToken = source.readString();
        this.intermediateCA = source.readString();
        this.endEntityCA = source.readString();
        this.durationTime = source.readInt();
        this.isRetry = (Boolean)source.readValue(Boolean.class.getClassLoader());
        this.isEncrypted = (Boolean)source.readValue(Boolean.class.getClassLoader());
        this.extraData = source.readBundle();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.transactionReference);
        dest.writeLong(this.transactionTimestamp.longValue());
        dest.writeString(this.transactionSignature);
        dest.writeString(this.encryptedToken);
        dest.writeString(this.signedToken);
        dest.writeString(this.intermediateCA);
        dest.writeString(this.endEntityCA);
        dest.writeInt(this.durationTime);
        dest.writeValue((Object)this.isRetry);
        dest.writeValue((Object)this.isEncrypted);
        dest.writeBundle(this.extraData);
    }

    public String getTransactionReference() {
        return this.transactionReference;
    }

    public Long getTransactionTimeStamp() {
        return this.transactionTimestamp;
    }

    public String getTransactionSignature() {
        return this.transactionSignature;
    }

    public String getEncryptedToken() {
        return this.encryptedToken;
    }

    public String getSignedToken() {
        return this.signedToken;
    }

    public String getIntermediateCA() {
        return this.intermediateCA;
    }

    public String getEndEntityCA() {
        return this.endEntityCA;
    }

    public int getDurationTime() {
        return this.durationTime;
    }

    public boolean getIsRetry() {
        return this.isRetry;
    }

    public boolean getIsEncrypted() {
        return this.isEncrypted;
    }

    @NonNull
    public Bundle getExtraMstPaymentData() {
        if (this.extraData == null) {
            this.extraData = new Bundle();
        }
        return this.extraData;
    }

    public static class Builder {
        private String transactionReference = "";
        private Long transactionTimestamp = 0L;
        private String transactionSignature = "";
        private String encryptedToken = "";
        private String signedToken = "";
        private String intermediateCA = "";
        private String endEntityCA = "";
        private int durationTime = 0;
        private boolean isRetry = false;
        private boolean isEncrypted = false;
        private Bundle extraData = new Bundle();

        @NonNull
        public Builder setTransactionReference(String tranRef) {
            this.transactionReference = tranRef;
            return this;
        }

        @NonNull
        public Builder setTransactionTimestamp(Long tranTimestamp) {
            this.transactionTimestamp = tranTimestamp;
            return this;
        }

        @NonNull
        public Builder setTransactionSignature(String tranSignature) {
            this.transactionSignature = tranSignature;
            return this;
        }

        @NonNull
        public Builder setEncryptedToken(String encryptedToken) {
            this.encryptedToken = encryptedToken;
            return this;
        }

        @NonNull
        public Builder setSignedToken(String signedToken) {
            this.signedToken = signedToken;
            return this;
        }

        @NonNull
        public Builder setIntermediateCA(String intermediateCA) {
            this.intermediateCA = intermediateCA;
            return this;
        }

        @NonNull
        public Builder setEndEntityCA(String endEntityCA) {
            this.endEntityCA = endEntityCA;
            return this;
        }

        @NonNull
        public Builder setDurationTime(int durationTime) {
            this.durationTime = durationTime;
            return this;
        }

        @NonNull
        public Builder setIsRetry(boolean isRetry) {
            this.isRetry = isRetry;
            return this;
        }

        @NonNull
        public Builder setIsEncrypted(boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            return this;
        }

        @NonNull
        public Builder setExtraMSTPaymentData(Bundle data) {
            this.extraData = data;
            return this;
        }

        @NonNull
        public MstPaymentInfo build() {
            return new MstPaymentInfo(this);
        }
    }
}

