/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.payment;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Set;

@Deprecated
public class PaymentInfo
implements Parcelable {
    private String version;
    private Amount amount;
    private Address shippingAddress;
    private Address billingAddress;
    private String merchantId;
    private String merchantName;
    private String orderNumber;
    private PaymentProtocol paymentProtocol;
    private AddressInPaymentSheet addressInPaymentSheet = AddressInPaymentSheet.DO_NOT_SHOW;
    private List<SpaySdk.Brand> allowedCardBrand;
    private boolean isGiftCardPurchase = false;
    private SpaySdk.Brand cardBrand;
    private boolean isCardHolderNameRequired = false;
    private boolean isRecurring = false;
    private String merchantCountryCode;
    private Bundle extraPaymentInfo;
    public static final Parcelable.Creator<PaymentInfo> CREATOR = new Parcelable.Creator<PaymentInfo>(){

        @NonNull
        public PaymentInfo createFromParcel(@NonNull Parcel source) {
            return new PaymentInfo(source);
        }

        @NonNull
        public PaymentInfo[] newArray(int size) {
            return new PaymentInfo[size];
        }
    };

    private PaymentInfo() {
    }

    private PaymentInfo(@NonNull Builder builder) {
        this.version = SpaySdk.getVersionName();
        this.amount = builder.amount;
        this.shippingAddress = builder.shippingAddress;
        this.billingAddress = builder.billingAddress;
        this.merchantId = builder.merchantId;
        this.merchantName = builder.merchantName;
        this.orderNumber = builder.orderNumber;
        this.paymentProtocol = builder.paymentProtocol;
        this.addressInPaymentSheet = builder.addressInPaymentSheet != null ? builder.addressInPaymentSheet : AddressInPaymentSheet.DO_NOT_SHOW;
        this.allowedCardBrand = builder.allowedCardBrand;
        this.isGiftCardPurchase = builder.isGiftCardPurchase;
        this.cardBrand = builder.cardBrand;
        this.isCardHolderNameRequired = builder.isCardHolderNameRequired;
        this.isRecurring = builder.isRecurring;
        this.merchantCountryCode = builder.merchantCountryCode;
        this.extraPaymentInfo = builder.extraPaymentInfo;
    }

    public PaymentInfo(@NonNull Parcel source) {
        this.readFromParcel(source);
    }

    public void readFromParcel(@NonNull Parcel source) {
        this.version = (String)source.readValue(String.class.getClassLoader());
        this.amount = (Amount)source.readParcelable(Amount.class.getClassLoader());
        this.shippingAddress = (Address)source.readParcelable(Address.class.getClassLoader());
        this.billingAddress = (Address)source.readParcelable(Address.class.getClassLoader());
        this.merchantId = (String)source.readValue(String.class.getClassLoader());
        this.merchantName = (String)source.readValue(String.class.getClassLoader());
        this.orderNumber = (String)source.readValue(String.class.getClassLoader());
        this.paymentProtocol = (PaymentProtocol)((Object)source.readValue(PaymentProtocol.class.getClassLoader()));
        this.addressInPaymentSheet = (AddressInPaymentSheet)((Object)source.readValue(AddressInPaymentSheet.class.getClassLoader()));
        this.allowedCardBrand = new ArrayList<SpaySdk.Brand>();
        source.readTypedList(this.allowedCardBrand, SpaySdk.Brand.CREATOR);
        this.isGiftCardPurchase = (Boolean)source.readValue(Boolean.class.getClassLoader());
        this.cardBrand = (SpaySdk.Brand)((Object)source.readValue(SpaySdk.Brand.class.getClassLoader()));
        this.isCardHolderNameRequired = (Boolean)source.readValue(Boolean.class.getClassLoader());
        this.isRecurring = (Boolean)source.readValue(Boolean.class.getClassLoader());
        this.merchantCountryCode = (String)source.readValue(String.class.getClassLoader());
        this.extraPaymentInfo = source.readBundle();
    }

    public Amount getAmount() {
        return this.amount;
    }

    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public PaymentProtocol getPaymentProtocol() {
        return this.paymentProtocol;
    }

    public AddressInPaymentSheet getAddressInPaymentSheet() {
        return this.addressInPaymentSheet;
    }

    public List<SpaySdk.Brand> getAllowedCardBrands() {
        return this.allowedCardBrand;
    }

    @Deprecated
    public SpaySdk.Brand getCardBrand() {
        return this.cardBrand;
    }

    public boolean getIsGiftCardPurchase() {
        return this.isGiftCardPurchase;
    }

    public boolean getIsCardHolderNameRequired() {
        return this.isCardHolderNameRequired;
    }

    public boolean getIsRecurring() {
        return this.isRecurring;
    }

    public String getMerchantCountryCode() {
        return this.merchantCountryCode;
    }

    public Bundle getExtraPaymentInfo() {
        return this.extraPaymentInfo;
    }

    public boolean isEnableEnforcePaymentSheet() {
        this.nullCheckExtraPaymentInfo();
        return this.extraPaymentInfo.getBoolean("enforcePaymentSheet", false);
    }

    @Deprecated
    public boolean isFastCheckout() {
        this.nullCheckExtraPaymentInfo();
        return this.extraPaymentInfo.getBoolean("fastCheckOutStatus", false);
    }

    public String getPaymentCardLast4DPAN() {
        this.nullCheckExtraPaymentInfo();
        return this.extraPaymentInfo.getString("last4Dpan", "");
    }

    public String getPaymentCardLast4FPAN() {
        this.nullCheckExtraPaymentInfo();
        return this.extraPaymentInfo.getString("last4Fpan", "");
    }

    @NonNull
    public SpaySdk.Brand getPaymentCardBrand() {
        this.nullCheckExtraPaymentInfo();
        return SpaySdk.Brand.valueOf(this.extraPaymentInfo.getString("cardBrand", "UNKNOWN_CARD"));
    }

    public String getPaymentCurrencyCode() {
        return this.amount.currencyCode;
    }

    public Address getPaymentShippingAddress() {
        return this.shippingAddress;
    }

    private void nullCheckExtraPaymentInfo() {
        if (this.extraPaymentInfo == null) {
            this.extraPaymentInfo = new Bundle();
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeValue((Object)this.version);
        dest.writeParcelable((Parcelable)this.amount, 0);
        dest.writeParcelable((Parcelable)this.shippingAddress, 0);
        dest.writeParcelable((Parcelable)this.billingAddress, 0);
        dest.writeValue((Object)this.merchantId);
        dest.writeValue((Object)this.merchantName);
        dest.writeValue((Object)this.orderNumber);
        dest.writeValue((Object)this.paymentProtocol);
        dest.writeValue((Object)this.addressInPaymentSheet);
        dest.writeTypedList(this.allowedCardBrand);
        dest.writeValue((Object)this.isGiftCardPurchase);
        dest.writeValue((Object)this.cardBrand);
        dest.writeValue((Object)this.isCardHolderNameRequired);
        dest.writeValue((Object)this.isRecurring);
        dest.writeValue((Object)this.merchantCountryCode);
        dest.writeBundle(this.extraPaymentInfo);
    }

    @Deprecated
    public static class Builder {
        private Amount amount;
        private Address shippingAddress;
        private Address billingAddress;
        private String merchantId;
        private String merchantName;
        private String orderNumber;
        private PaymentProtocol paymentProtocol;
        private AddressInPaymentSheet addressInPaymentSheet;
        private List<SpaySdk.Brand> allowedCardBrand = new ArrayList<SpaySdk.Brand>();
        private boolean isGiftCardPurchase;
        private SpaySdk.Brand cardBrand;
        private boolean isCardHolderNameRequired;
        private boolean isRecurring;
        private String merchantCountryCode;
        private Bundle extraPaymentInfo;

        @NonNull
        public Builder setAmount(Amount amount) {
            this.amount = amount;
            return this;
        }

        @NonNull
        public Builder setShippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        @NonNull
        public Builder setBillingAddress(Address billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        @NonNull
        public Builder setMerchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        @NonNull
        public Builder setMerchantName(String merchantName) {
            this.merchantName = merchantName;
            return this;
        }

        @NonNull
        public Builder setOrderNumber(String orderNumber) {
            this.orderNumber = orderNumber;
            return this;
        }

        @NonNull
        public Builder setPaymentProtocol(PaymentProtocol paymentProtocol) {
            this.paymentProtocol = paymentProtocol;
            return this;
        }

        @NonNull
        public Builder setAddressInPaymentSheet(AddressInPaymentSheet addressInPaymentSheet) {
            this.addressInPaymentSheet = addressInPaymentSheet;
            return this;
        }

        @NonNull
        public Builder setAllowedCardBrands(List<SpaySdk.Brand> brands) {
            this.allowedCardBrand = brands;
            return this;
        }

        @NonNull
        public Builder setIsGiftCardPurchase(boolean isGiftCardPurchase) {
            this.isGiftCardPurchase = isGiftCardPurchase;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder cardBrand(SpaySdk.Brand cardBrand) {
            this.cardBrand = cardBrand;
            return this;
        }

        @NonNull
        public Builder setCardHolderNameEnabled(boolean isCardHolderNameRequired) {
            this.isCardHolderNameRequired = isCardHolderNameRequired;
            return this;
        }

        @NonNull
        public Builder setRecurringEnabled(boolean isRecurring) {
            this.isRecurring = isRecurring;
            return this;
        }

        @NonNull
        public Builder setMerchantCountryCode(@Nullable String merchantCountryCode) {
            Locale[] localeList;
            if (merchantCountryCode != null && merchantCountryCode.isEmpty()) {
                throw new IllegalArgumentException("merchant country code is empty.");
            }
            for (Locale locale : localeList = Locale.getAvailableLocales()) {
                try {
                    if (!locale.getCountry().equals(merchantCountryCode)) continue;
                    this.merchantCountryCode = locale.getCountry();
                    return this;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException(merchantCountryCode + " is invalid merchant country code.");
        }

        @NonNull
        public Builder setExtraPaymentInfo(Bundle extraPaymentInfo) {
            this.extraPaymentInfo = extraPaymentInfo;
            return this;
        }

        @NonNull
        public Builder enableEnforcePaymentSheet() {
            this.nullCheckExtraPaymentInfo();
            this.extraPaymentInfo.putBoolean("enforcePaymentSheet", true);
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setFastCheckoutStatus(boolean value) {
            this.nullCheckExtraPaymentInfo();
            this.extraPaymentInfo.putBoolean("fastCheckOutStatus", value);
            return this;
        }

        @NonNull
        public Builder setPaymentCardLast4DPAN(String last4digits) {
            this.nullCheckExtraPaymentInfo();
            this.extraPaymentInfo.putString("last4Dpan", last4digits);
            return this;
        }

        @NonNull
        public Builder setPaymentCardLast4FPAN(String last4digits) {
            this.nullCheckExtraPaymentInfo();
            this.extraPaymentInfo.putString("last4Fpan", last4digits);
            return this;
        }

        @NonNull
        public Builder setPaymentCardBrand(@NonNull SpaySdk.Brand cardBrand) {
            this.nullCheckExtraPaymentInfo();
            this.extraPaymentInfo.putString("cardBrand", cardBrand.name());
            return this;
        }

        private void nullCheckExtraPaymentInfo() {
            if (this.extraPaymentInfo == null) {
                this.extraPaymentInfo = new Bundle();
            }
        }

        @NonNull
        public PaymentInfo build() {
            return new PaymentInfo(this);
        }
    }

    @Deprecated
    public static enum AddressInPaymentSheet implements Parcelable
    {
        DO_NOT_SHOW,
        NEED_BILLING_SPAY,
        NEED_SHIPPING_SPAY,
        SEND_SHIPPING,
        NEED_BILLING_SEND_SHIPPING,
        NEED_BILLING_AND_SHIPPING;

        public static final Parcelable.Creator<AddressInPaymentSheet> CREATOR;

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<AddressInPaymentSheet>(){

                public AddressInPaymentSheet createFromParcel(@NonNull Parcel in) {
                    return AddressInPaymentSheet.values()[in.readInt()];
                }

                @Nullable
                public AddressInPaymentSheet[] newArray(int size) {
                    return null;
                }
            };
        }
    }

    @Deprecated
    public static class Amount
    implements Parcelable {
        private String version;
        private String currencyCode;
        private String itemTotalPrice;
        private String tax;
        private String shippingPrice;
        private String totalPrice;
        public static final Parcelable.Creator<Amount> CREATOR = new Parcelable.Creator<Amount>(){

            @NonNull
            public Amount createFromParcel(@NonNull Parcel source) {
                return new Amount(source);
            }

            @NonNull
            public Amount[] newArray(int size) {
                return new Amount[size];
            }
        };

        private Amount() {
        }

        private Amount(@NonNull Builder builder) {
            this.version = SpaySdk.getVersionName();
            this.currencyCode = builder.currencyCode;
            this.itemTotalPrice = builder.itemTotalPrice;
            this.tax = builder.tax;
            this.shippingPrice = builder.shippingPrice;
            this.totalPrice = builder.totalPrice;
        }

        public Amount(@NonNull Parcel source) {
            this.version = (String)source.readValue(String.class.getClassLoader());
            this.currencyCode = (String)source.readValue(String.class.getClassLoader());
            this.itemTotalPrice = (String)source.readValue(String.class.getClassLoader());
            this.tax = (String)source.readValue(String.class.getClassLoader());
            this.shippingPrice = (String)source.readValue(String.class.getClassLoader());
            this.totalPrice = (String)source.readValue(String.class.getClassLoader());
        }

        public String getCurrencyCode() {
            return this.currencyCode;
        }

        public String getItemTotalPrice() {
            return this.itemTotalPrice;
        }

        public String getTax() {
            return this.tax;
        }

        public String getShippingPrice() {
            return this.shippingPrice;
        }

        public String getTotalPrice() {
            return this.totalPrice;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeValue((Object)this.version);
            dest.writeValue((Object)this.currencyCode);
            dest.writeValue((Object)this.itemTotalPrice);
            dest.writeValue((Object)this.tax);
            dest.writeValue((Object)this.shippingPrice);
            dest.writeValue((Object)this.totalPrice);
        }

        private static boolean isValid(@Nullable String str) {
            double d;
            if (str == null) {
                return false;
            }
            try {
                d = Double.parseDouble(str);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            return d >= 0.0;
        }

        @Deprecated
        public static class Builder {
            private String currencyCode;
            private String itemTotalPrice;
            private String tax;
            private String shippingPrice;
            private String totalPrice;

            @NonNull
            public Builder setCurrencyCode(@NonNull String currencyCode) {
                Set<Currency> currencySet = Currency.getAvailableCurrencies();
                for (Currency currencyInfo : currencySet) {
                    try {
                        if (!currencyInfo.getCurrencyCode().equals(currencyCode)) continue;
                        this.currencyCode = currencyCode;
                        return this;
                    }
                    catch (Exception exception) {
                    }
                }
                throw new IllegalArgumentException(currencyCode + " is invalid currencyCode.");
            }

            @NonNull
            public Builder setItemTotalPrice(String itemTotalPrice) {
                if (Amount.isValid(itemTotalPrice)) {
                    this.itemTotalPrice = itemTotalPrice;
                    return this;
                }
                throw new IllegalArgumentException(itemTotalPrice + " is invalid itemTotalPrice");
            }

            @NonNull
            public Builder setTax(String tax) {
                if (Amount.isValid(tax)) {
                    this.tax = tax;
                    return this;
                }
                throw new IllegalArgumentException(tax + " is invalid tax");
            }

            @NonNull
            public Builder setShippingPrice(String shippingPrice) {
                if (Amount.isValid(shippingPrice)) {
                    this.shippingPrice = shippingPrice;
                    return this;
                }
                throw new IllegalArgumentException(shippingPrice + " is invalid shippingPrice");
            }

            @NonNull
            public Builder setTotalPrice(String totalPrice) {
                if (!Amount.isValid(totalPrice)) {
                    throw new IllegalArgumentException(totalPrice + " is invalid totalPrice");
                }
                this.totalPrice = totalPrice;
                return this;
            }

            @NonNull
            public Amount build() {
                return new Amount(this);
            }
        }
    }

    @Deprecated
    public static class Address
    implements Parcelable {
        private String version;
        private String addressee;
        private String addressLine1;
        private String addressLine2;
        private String city;
        private String state;
        private String countryCode;
        private String postalCode;
        public static final Parcelable.Creator<Address> CREATOR = new Parcelable.Creator<Address>(){

            @NonNull
            public Address createFromParcel(@NonNull Parcel source) {
                return new Address(source);
            }

            @NonNull
            public Address[] newArray(int size) {
                return new Address[size];
            }
        };

        private Address() {
        }

        private Address(@NonNull Builder builder) {
            this.version = SpaySdk.getVersionName();
            this.addressee = builder.addressee;
            this.addressLine1 = builder.addressLine1;
            this.addressLine2 = builder.addressLine2;
            this.city = builder.city;
            this.state = builder.state;
            this.countryCode = builder.countryCode;
            this.postalCode = builder.postalCode;
        }

        public Address(@NonNull Parcel source) {
            this.version = (String)source.readValue(String.class.getClassLoader());
            this.addressee = (String)source.readValue(String.class.getClassLoader());
            this.addressLine1 = (String)source.readValue(String.class.getClassLoader());
            this.addressLine2 = (String)source.readValue(String.class.getClassLoader());
            this.city = (String)source.readValue(String.class.getClassLoader());
            this.state = (String)source.readValue(String.class.getClassLoader());
            this.countryCode = (String)source.readValue(String.class.getClassLoader());
            this.postalCode = (String)source.readValue(String.class.getClassLoader());
        }

        public String getAddressee() {
            return this.addressee;
        }

        public String getAddressLine1() {
            return this.addressLine1;
        }

        public String getAddressLine2() {
            return this.addressLine2;
        }

        public String getCity() {
            return this.city;
        }

        public String getState() {
            return this.state;
        }

        public String getCountryCode() {
            return this.countryCode;
        }

        public String getPostalCode() {
            return this.postalCode;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeValue((Object)this.version);
            dest.writeValue((Object)this.addressee);
            dest.writeValue((Object)this.addressLine1);
            dest.writeValue((Object)this.addressLine2);
            dest.writeValue((Object)this.city);
            dest.writeValue((Object)this.state);
            dest.writeValue((Object)this.countryCode);
            dest.writeValue((Object)this.postalCode);
        }

        @Deprecated
        public static class Builder {
            private String addressee;
            private String addressLine1;
            private String addressLine2;
            private String city;
            private String state;
            private String countryCode;
            private String postalCode;

            @NonNull
            public Builder setAddressee(String addressee) {
                this.addressee = addressee;
                return this;
            }

            @NonNull
            public Builder setAddressLine1(String addressLine1) {
                this.addressLine1 = addressLine1;
                return this;
            }

            @NonNull
            public Builder setAddressLine2(String addressLine2) {
                this.addressLine2 = addressLine2;
                return this;
            }

            @NonNull
            public Builder setCity(String city) {
                this.city = city;
                return this;
            }

            @NonNull
            public Builder setState(String state) {
                this.state = state;
                return this;
            }

            @NonNull
            public Builder setCountryCode(@NonNull String countryCode) {
                Locale[] localeList;
                if (countryCode.isEmpty()) {
                    throw new IllegalArgumentException("countryCode is empty");
                }
                for (Locale locale : localeList = Locale.getAvailableLocales()) {
                    try {
                        if (!locale.getDisplayCountry().equals(countryCode)) continue;
                        this.countryCode = countryCode;
                        return this;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new IllegalArgumentException(countryCode + "countryCode is invalid ");
            }

            @NonNull
            public Builder setPostalCode(String postalCode) {
                this.postalCode = postalCode;
                return this;
            }

            @NonNull
            public Address build() {
                return new Address(this);
            }
        }
    }

    @Deprecated
    public static enum PaymentProtocol implements Parcelable
    {
        PROTOCOL_3DS,
        PROTOCOL_EMV,
        PROTOCOL_COF,
        PROTOCOL_OTHER;

        public static final Parcelable.Creator<PaymentProtocol> CREATOR;

        @NonNull
        public static PaymentProtocol convert(String type) {
            if ((type = type.toUpperCase(Locale.US)).contains("3DS")) {
                return PROTOCOL_3DS;
            }
            if (type.contains("EMV")) {
                return PROTOCOL_EMV;
            }
            return PROTOCOL_OTHER;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<PaymentProtocol>(){

                public PaymentProtocol createFromParcel(@NonNull Parcel in) {
                    return PaymentProtocol.values()[in.readInt()];
                }

                @NonNull
                public PaymentProtocol[] newArray(int size) {
                    return new PaymentProtocol[size];
                }
            };
        }
    }
}

