/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.payment;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.ISStatusListener;
import com.samsung.android.sdk.samsungpay.v2.ParamInfo;
import com.samsung.android.sdk.samsungpay.v2.PartnerInfo;
import com.samsung.android.sdk.samsungpay.v2.PartnerRequest;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;
import com.samsung.android.sdk.samsungpay.v2.SpayValidity;
import com.samsung.android.sdk.samsungpay.v2.StatusListener;
import com.samsung.android.sdk.samsungpay.v2.StubBase;
import com.samsung.android.sdk.samsungpay.v2.payment.CardInfo;
import com.samsung.android.sdk.samsungpay.v2.payment.CustomSheetPaymentInfo;
import com.samsung.android.sdk.samsungpay.v2.payment.ISGetCardBrandListener;
import com.samsung.android.sdk.samsungpay.v2.payment.ISPaymentCallback;
import com.samsung.android.sdk.samsungpay.v2.payment.ISPaymentManager;
import com.samsung.android.sdk.samsungpay.v2.payment.PaymentInfo;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.AddressControl;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.CustomSheet;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetControl;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetItemType;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetUpdatedListener;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SpinnerControl;
import com.samsung.android.sdk.samsungpay.v2.service.ISUserInfoCallback;
import com.samsung.android.sdk.samsungpay.v2.service.RequestType;
import com.samsung.android.sdk.samsungpay.v2.service.UserInfoCollection;
import com.samsung.android.sdk.samsungpay.v2.service.UserInfoListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PaymentManager
extends SpaySdk {
    private static final String TAG = "SPAYSDK:PaymentManager";
    private StubBase<ISPaymentManager> mPaymentManagerStub;
    private static final int CUSTOM_SHEET_VER_1 = 1;
    private static final int CMD_START = 200;
    private static final int CMD_CARD_TYPE = 201;
    private static final int CMD_SETUP_INFO = 202;
    private static final int CMD_START_SIMPLE_PAY = 203;
    private static final int CMD_START_WITH_CUSTOM_SHEET = 204;
    private static final int CMD_GET_FCO_STATUS = 205;
    private static final int CMD_SEND_PAYMENT_RESULT_INFO = 206;
    private static final int CMD_UPDATE_AMOUNT = 207;
    private static final int CMD_UPDATE_AMOUNT_FAIL = 208;
    private static final int CMD_UPDATE_SHEET = 209;
    private static final int CMD_EXECUTE_PENDING_METHODS = 1000;
    private static final int CMD_FAILED_BIND_STUB = 1001;
    private static final int MSG_PAYMENT_INFO_CHANGED = 100;
    private static final int MSG_APPROVE_PAYMENT = 101;
    private static final int MSG_FAIL_PAYMENT = 102;
    private static final int MSG_PAYMENT_ADDRESS_CHANGED = 103;
    private static final int MSG_PAYMENT_CARD_CHANGED = 104;
    private static final int MSG_SHOW_PAYMENT_ACTIVITY = 105;
    private static final int MSG_PAYMENT_SHEET_UPDATED = 106;
    private static final int MSG_APPROVE_PAYMENT_WITH_SHEET = 107;
    private static final int MSG_CUSTOM_SHEET_CARD_INFO_UPDATED = 108;
    private static final int MSG_CUSTOM_SHEET_APPROVE_PAYMENT = 109;
    private static final int MSG_CUSTOM_SHEET_FAIL_PAYMENT = 110;
    private static final String KEY_PAYMENT_INFO = "PaymentInfo";
    private static final String KEY_ENCRYPTED_DATA = "EncryptedData";
    private static final String KEY_UPDATED_CONTROL_ID = "updatedControlId";
    private static final String KEY_CUSTOM_SHEET = "customSheet";
    private static final String KEY_UPDATE_CARD = "updatedCard";
    private static final String KEY_CUSTOM_SHEET_PAYMENT_NFO = "customSheetPaymentInfo";
    private static final String KEY_EXTRA_DATA = "extraData";
    public static final String EXTRA_PAY_OPERATION_TYPE = "payOperationType";
    public static final String PAY_OPERATION_TYPE_PAYMENT = "payment";
    public static final String PAY_OPERATION_TYPE_REFUND = "refund";
    public static final String EXTRA_TRANSACTION_DATE = "transactionDate";
    public static final String EXTRA_TRANSACTION_NUMBER = "transactionNumber";
    public static final String EXTRA_TRANSACTION_TYPE = "transactionType";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_7)
    public static final String EXTRA_ENFORCE_PAYMENT_SHEET = "enforcePaymentSheet";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_7)
    @Deprecated
    public static final String EXTRA_FCO_STATUS = "fastCheckOutStatus";
    @Deprecated
    public static final int FCO_DISABLED = 0;
    @Deprecated
    public static final int FCO_ENABLED = 1;
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_1_7)
    public static final String EXTRA_SHIPPING_METHOD = "shippingMethod";
    public static final int TRANSACTION_TYPE_MST = 1;
    public static final int TRANSACTION_TYPE_NFC = 2;
    public static final int ERROR_NOT_READY_PAYMENT = -108;
    @Deprecated
    public static final String EXTRA_TOP_BACKGROUND_COLOR = "topBackgroundColor";
    public static final String EXTRA_LOGO_IMAGE_URL = "logoImageUrl";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_3)
    public static final String EXTRA_KEY_TEST_MODE = "testMode";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_4)
    public static final String EXTRA_KEY_ADDITIONAL_DATA = "additionalData";
    @ParamInfo(since=SpaySdk.SdkApiLevel.LEVEL_2_7)
    public static final String EXTRA_KEY_CARD_BRAND_FILTER = "card_brand_filter";
    public static final int ERROR_SESSION_LOCKED = -109;
    public static final int ERROR_SESSION_TIMED_OUT = -110;
    public static final int ERROR_TRANSACTION_TIMED_OUT = -111;
    public static final int ERROR_TRANSACTION_CLOSED = -112;
    public static final int ERROR_ADDRESS_UPDATED_TIME_OUT = -113;
    public static final int ERROR_INTERNAL_ADDRESS_UPDATED = -114;
    public static final int ERROR_MAKING_SHEET_FAILED = -115;
    public static final int ERROR_SPAY_RESET = -116;
    public static final int ERROR_SHIPPING_ADDRESS_INVALID = -201;
    public static final int ERROR_SHIPPING_ADDRESS_UNABLE_TO_SHIP = -202;
    public static final int ERROR_SHIPPING_ADDRESS_NOT_EXIST = -203;
    public static final int ERROR_BILLING_ADDRESS_INVALID = -204;
    public static final int ERROR_BILLING_ADDRESS_NOT_EXIST = -205;
    public static final int CUSTOM_MESSAGE = -220;
    @Deprecated
    public static final int ERROR_PAYMENT_PROTOCOL_NOT_SUPPORTED = -401;
    @Deprecated
    public static final int ERROR_CARD_NOT_SUPPORTED_IN_LATEST_SPAY = -402;
    public static final int ERROR_CARD_NOT_SUPPORTED_ONLINE_PAY = -402;
    private final Handler mEventHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(@NonNull Message msg) {
            PartnerRequest partnerRequest = (PartnerRequest)msg.obj;
            block0 : switch (msg.what) {
                case 103: {
                    Bundle result_PayInfo = msg.getData();
                    ((TransactionInfoListener)partnerRequest.callbackObj).onAddressUpdated((PaymentInfo)result_PayInfo.get(PaymentManager.KEY_PAYMENT_INFO));
                    break;
                }
                case 104: {
                    CardInfo updateCard = (CardInfo)partnerRequest.obj3;
                    ((TransactionInfoListener)partnerRequest.callbackObj).onCardInfoUpdated(updateCard);
                    break;
                }
                case 101: {
                    Bundle result = msg.getData();
                    ((TransactionInfoListener)partnerRequest.callbackObj).onSuccess((PaymentInfo)result.get(PaymentManager.KEY_PAYMENT_INFO), result.getString(PaymentManager.KEY_ENCRYPTED_DATA), null);
                    PaymentManager.this.nextRequest();
                    break;
                }
                case 102: 
                case 110: {
                    PaymentManager.this.onFailure(msg);
                    PaymentManager.this.nextRequest();
                    break;
                }
                case 105: {
                    PaymentManager.this.showPaymentSheet((PartnerRequest)msg.obj, msg.arg1);
                    break;
                }
                case 1000: {
                    break;
                }
                case 106: {
                    Bundle sheet_update_result = msg.getData();
                    String updatedControlId = sheet_update_result.getString(PaymentManager.KEY_UPDATED_CONTROL_ID);
                    CustomSheet sheet = (CustomSheet)sheet_update_result.get(PaymentManager.KEY_CUSTOM_SHEET);
                    SheetControl sheetControl = sheet.getSheetControl(updatedControlId);
                    CustomSheetPaymentInfo callbackCustomSheetPaymentInfo = (CustomSheetPaymentInfo)partnerRequest.obj1;
                    if (sheetControl == null) break;
                    switch (sheetControl.getControltype()) {
                        case ADDRESS: {
                            SheetUpdatedListener sheetUpdatedListener;
                            AddressControl addressControl = (AddressControl)callbackCustomSheetPaymentInfo.getCustomSheet().getSheetControl(updatedControlId);
                            if (addressControl == null || (sheetUpdatedListener = addressControl.getSheetUpdatedListener()) == null) break block0;
                            sheetUpdatedListener.onResult(updatedControlId, sheet);
                            break block0;
                        }
                        case SPINNER: {
                            SheetUpdatedListener sheetUpdatedListener;
                            SpinnerControl spinnerControl = (SpinnerControl)callbackCustomSheetPaymentInfo.getCustomSheet().getSheetControl(updatedControlId);
                            if (spinnerControl == null || (sheetUpdatedListener = spinnerControl.getSheetUpdatedListener()) == null) break block0;
                            sheetUpdatedListener.onResult(updatedControlId, sheet);
                            break block0;
                        }
                    }
                    Log.e((String)PaymentManager.TAG, (String)"MSG_PAYMENT_SHEET_UPDATED : controlType is not matched.");
                    break;
                }
                case 108: {
                    Bundle card_update_result = msg.getData();
                    CardInfo cardInfo = (CardInfo)card_update_result.get(PaymentManager.KEY_UPDATE_CARD);
                    CustomSheet customSheet = (CustomSheet)card_update_result.get(PaymentManager.KEY_CUSTOM_SHEET);
                    ((CustomSheetTransactionInfoListener)partnerRequest.callbackObj).onCardInfoUpdated(cardInfo, customSheet);
                    break;
                }
                case 109: {
                    Bundle approve_result = msg.getData();
                    ((CustomSheetTransactionInfoListener)partnerRequest.callbackObj).onSuccess((CustomSheetPaymentInfo)approve_result.get(PaymentManager.KEY_CUSTOM_SHEET_PAYMENT_NFO), approve_result.getString(PaymentManager.KEY_ENCRYPTED_DATA), (Bundle)approve_result.get(PaymentManager.KEY_EXTRA_DATA));
                    PaymentManager.this.nextRequest();
                    break;
                }
            }
        }
    };
    private boolean mIsAsyncResponse = false;
    @NonNull
    protected Handler mHandlerForInternalListener = new Handler(Looper.getMainLooper()){

        public void handleMessage(@NonNull Message msg) {
            switch (msg.what) {
                case 0: {
                    if (msg.obj instanceof CardInfoListener) {
                        ((CardInfoListener)msg.obj).onResult(msg.getData().getParcelableArrayList("KEY_FOR_MESSAGE"));
                        break;
                    }
                    ((StatusListener)msg.obj).onSuccess(msg.arg1, msg.getData());
                    break;
                }
                case 1: {
                    if (msg.obj instanceof CardInfoListener) {
                        ((CardInfoListener)msg.obj).onFailure(msg.arg1, msg.getData());
                        break;
                    }
                    ((StatusListener)msg.obj).onFail(msg.arg1, msg.getData());
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    Log.e((String)PaymentManager.TAG, (String)"sdk can not catch listener from SPay.");
                }
            }
        }
    };

    private static boolean isParsable(@Nullable String str) {
        double d;
        if (str == null) {
            return false;
        }
        try {
            d = Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            Log.d((String)TAG, (String)"NumberFormat Exception");
            return false;
        }
        return d >= 0.0;
    }

    public PaymentManager(Context context, PartnerInfo partnerInfo) {
        super(context, partnerInfo);
        Log.d((String)TAG, (String)"PaymentManager()");
        this.mPaymentManagerStub = new StubBase.Creator<ISPaymentManager>().createStub(context, "com.samsung.android.spay.sdk.v2.service.InAppService", ISPaymentManager.Stub::asInterface);
    }

    @NonNull
    private String checkPaymentInfoValidity(@NonNull CustomSheetPaymentInfo customSheetPaymentInfo) {
        Bundle extraInfo = customSheetPaymentInfo.getExtraPaymentInfo();
        if (extraInfo != null && extraInfo.containsKey("supportComboCard") && SpayValidity.readPartnerApiLevelInManifest((Context)this.contextRef.get()).compareTo(SpaySdk.SdkApiLevel.LEVEL_2_8) > 0) {
            throw new IllegalArgumentException("EXTRA_SUPPORT_COMBO_CARD key is deprecated since Api level 2.9. Use EXTRA_ACCEPT_COMBO_CARD instead");
        }
        String detailMessage = "";
        int amountBoxControlCount = 0;
        boolean needShippingAddress = false;
        boolean sendShippingAddress = false;
        int shippingAddressControlCount = 0;
        boolean needBillingAddress = false;
        int billingAddressControlCount = 0;
        AddressControl shippingAddressControl = null;
        CustomSheet sheet = customSheetPaymentInfo.getCustomSheet();
        if (sheet != null) {
            switch (customSheetPaymentInfo.getAddressInPaymentSheet()) {
                case SEND_SHIPPING: 
                case NEED_BILLING_SEND_SHIPPING: {
                    sendShippingAddress = true;
                }
                case NEED_SHIPPING_SPAY: 
                case NEED_BILLING_AND_SHIPPING: {
                    needShippingAddress = true;
                    break;
                }
            }
            switch (customSheetPaymentInfo.getAddressInPaymentSheet()) {
                case NEED_BILLING_SEND_SHIPPING: 
                case NEED_BILLING_AND_SHIPPING: 
                case NEED_BILLING_SPAY: {
                    needBillingAddress = true;
                    break;
                }
            }
            for (SheetControl control : sheet.getSheetControls()) {
                if (control.getControltype() == SheetControl.Controltype.AMOUNTBOX) {
                    ++amountBoxControlCount;
                }
                if (control.getControltype() != SheetControl.Controltype.ADDRESS) continue;
                AddressControl addressControl = (AddressControl)control;
                switch (addressControl.getAddressType()) {
                    case SHIPPING_ADDRESS: {
                        ++shippingAddressControlCount;
                        shippingAddressControl = addressControl;
                        break;
                    }
                    case BILLING_ADDRESS: 
                    case ZIP_ONLY_ADDRESS: {
                        ++billingAddressControlCount;
                        break;
                    }
                }
            }
        }
        if (sheet == null) {
            detailMessage = "You must set customSheet using setCustomSheet().";
        } else if (amountBoxControlCount == 0 || amountBoxControlCount > 1) {
            detailMessage = "There must be a AmountBoxControl.";
        } else if (customSheetPaymentInfo.getMerchantName() == null || customSheetPaymentInfo.getMerchantName().length() == 0) {
            detailMessage = "You must set merchant name.";
        } else if (needBillingAddress && (billingAddressControlCount == 0 || billingAddressControlCount > 1)) {
            detailMessage = "There must be a AddressControl of billing";
        } else if (needShippingAddress && (shippingAddressControlCount == 0 || shippingAddressControlCount > 1)) {
            detailMessage = "There must be a AddressControl of shipping";
        } else if (sendShippingAddress && shippingAddressControl != null) {
            if (shippingAddressControl.getDisplayOption() != 0 && shippingAddressControl.getAddress() == null) {
                detailMessage = "There must be an address in the Address control as the Address control has a display option";
            } else if ((shippingAddressControl.getDisplayOption() & 4) != 0 && TextUtils.isEmpty((CharSequence)shippingAddressControl.getAddress().phoneNumber)) {
                detailMessage = "There must be a phone number in Address control because it is a shipping display option";
            } else if ((shippingAddressControl.getDisplayOption() & 8) != 0 && TextUtils.isEmpty((CharSequence)shippingAddressControl.getAddress().email)) {
                detailMessage = "There must be an email in the Address control because it is a shipping display option";
            } else if ((shippingAddressControl.getDisplayOption() & 1) != 0 && TextUtils.isEmpty((CharSequence)shippingAddressControl.getAddress().addressee)) {
                detailMessage = "There must be an addressee in the Address control because it is a shipping display option";
            }
        }
        return detailMessage;
    }

    @NonNull
    private String checkPaymentInfoValidity(@NonNull PaymentInfo paymentRequest) {
        String detailMessage = "";
        if (paymentRequest.getAmount() == null) {
            detailMessage = "You must set Amount.";
        } else if (paymentRequest.getAddressInPaymentSheet() == PaymentInfo.AddressInPaymentSheet.SEND_SHIPPING || paymentRequest.getAddressInPaymentSheet() == PaymentInfo.AddressInPaymentSheet.NEED_BILLING_SEND_SHIPPING) {
            if (paymentRequest.getShippingAddress() == null) {
                detailMessage = "You must set address to display on the payment sheet.";
            } else {
                String invalidFields = this.getInvalidAddressFields(paymentRequest.getShippingAddress());
                if (!invalidFields.trim().isEmpty()) {
                    detailMessage = "You must set mandatory address fields.\n Following fields cannot be null or empty : ( " + invalidFields + ")";
                }
            }
        } else if (paymentRequest.getIsGiftCardPurchase()) {
            if (!PaymentManager.isParsable(paymentRequest.getAmount().getTotalPrice())) {
                detailMessage = "You must set Gift Card Amount.";
            }
        } else {
            if (!(PaymentManager.isParsable(paymentRequest.getAmount().getShippingPrice()) && PaymentManager.isParsable(paymentRequest.getAmount().getTotalPrice()) && PaymentManager.isParsable(paymentRequest.getAmount().getItemTotalPrice()) && PaymentManager.isParsable(paymentRequest.getAmount().getTax()))) {
                detailMessage = "You must set all Amount fields with valid values.";
            }
            if (paymentRequest.getMerchantName() == null || paymentRequest.getMerchantName().isEmpty()) {
                detailMessage = "You must set merchant name.";
            }
        }
        return detailMessage;
    }

    @NonNull
    private String getInvalidAddressFields(@NonNull PaymentInfo.Address address) {
        String invalidFields = "";
        if (address.getAddressLine1() == null || address.getAddressLine1().trim().isEmpty()) {
            invalidFields = invalidFields + "AddressLine1 ";
        }
        if (address.getCity() == null || address.getCity().trim().isEmpty()) {
            invalidFields = invalidFields + "City ";
        }
        if (address.getState() == null || address.getState().trim().isEmpty()) {
            invalidFields = invalidFields + "State ";
        }
        if (address.getPostalCode() == null || address.getPostalCode().trim().isEmpty()) {
            invalidFields = invalidFields + "ZipCode ";
        }
        if (address.getCountryCode() == null || address.getCountryCode().trim().isEmpty()) {
            invalidFields = invalidFields + "Country ";
        }
        return invalidFields;
    }

    public void requestCardInfo(Bundle requestFilter, @NonNull CardInfoListener listener) {
        Log.d((String)TAG, (String)"requestCardInfo : SDK API Level = 1.1");
        this.mIsAsyncResponse = false;
        this.assertNotNull(listener);
        GetCardBrandListenerInternal listenerInternal = new GetCardBrandListenerInternal();
        PartnerRequest pReq = new PartnerRequest.Builder(this, 201, listener).setName("requestCardInfo").setObj1(requestFilter).onExecute((stub, request) -> this.doRequestCardInfo((ISPaymentManager)stub, request, listenerInternal)).onError((errorType, errorCode, errorExtra) -> listener.onFailure(errorCode, errorExtra)).create();
        listenerInternal.set(pReq);
        this.mPaymentManagerStub.postRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_1_1);
    }

    @Deprecated
    public void updateAmount(PaymentInfo.Amount amount) {
        Log.d((String)TAG, (String)"updateAmount() : SDK API Level = 1.1");
        if (!this.mPaymentManagerStub.isValidStub()) {
            throw new IllegalStateException("Service is disconnected. Please try to call startInAppPay() before.");
        }
        PartnerRequest pReq = new PartnerRequest.Builder(this, 207, null).setName("updateAmount").onExecute((stub, request) -> {
            int result = ((ISPaymentManager)stub).updateAmount(amount);
            if (result == -108) {
                throw new IllegalStateException("You should call startInAppPay() before updateTransactionDetails");
            }
            if (result == -109) {
                throw new IllegalStateException("Samsung Pay Service is locked by other application.");
            }
        }).onError((errorType, errorCode, errorExtra) -> {
            throw new IllegalStateException("Exception: " + errorCode);
        }).create();
        this.mPaymentManagerStub.executeRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_1_1);
    }

    @Deprecated
    public void updateAmountFailed(int errorCode) {
        Log.d((String)TAG, (String)"updateAmountFailed() : SDK API Level = 1.1");
        if (!this.mPaymentManagerStub.isValidStub()) {
            throw new IllegalStateException("Service is disconnected. Please try to call startInAppPay() before.");
        }
        PartnerRequest pReq = new PartnerRequest.Builder(this, 208, null).setName("updateAmountFailed").onExecute((stub, request) -> {
            int result = ((ISPaymentManager)stub).invalidAddress(errorCode);
            if (result == -108) {
                throw new IllegalStateException("You should call startInAppPay() before updateTransactionDetails");
            }
            if (result == -109) {
                throw new IllegalStateException("Samsung Pay Service is locked by other application.");
            }
        }).onError((errorType, errCode, errorExtra) -> {
            throw new IllegalStateException("Exception: " + errCode);
        }).create();
        this.mPaymentManagerStub.executeRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_1_1);
    }

    public void updateSheet(CustomSheet sheet) {
        Log.d((String)TAG, (String)"updateSheet() : SDK API Level = 1.3");
        if (!this.mPaymentManagerStub.isValidStub()) {
            throw new IllegalStateException("Service is disconnected. Please try to call startInAppPay() before.");
        }
        this.assertNotNull(sheet);
        PartnerRequest pReq = new PartnerRequest.Builder(this, 209, null).setName("updateSheet").checkApiLevelFor(sheet).onExecute((stub, request) -> {
            int result = ((ISPaymentManager)stub).updateSheet(sheet);
            if (result == -108) {
                throw new IllegalStateException("You should call startInAppPay() before updateTransactionDetails");
            }
            if (result == -109) {
                throw new IllegalStateException("Samsung Pay Service is locked by other application.");
            }
        }).onError((errorType, errCode, errorExtra) -> {
            throw new IllegalStateException("Exception: " + errCode);
        }).create();
        this.mPaymentManagerStub.executeRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_1_3);
    }

    public void updateSheet(CustomSheet sheet, int errorCode, String customErrorMessage) {
        Log.d((String)TAG, (String)"updateSheet() with custom error code & message : SDK API Level = 1.5");
        if (!this.mPaymentManagerStub.isValidStub()) {
            throw new IllegalStateException("Service is disconnected. Please try to call startInAppPay() before.");
        }
        this.assertNotNull(sheet);
        PartnerRequest pReq = new PartnerRequest.Builder(this, 209, null).setName("updateSheet").checkApiLevelFor(sheet).onExecute((stub, request) -> {
            int result = ((ISPaymentManager)stub).updateSheetWithCustomMessage(sheet, errorCode, customErrorMessage);
            if (result == -108) {
                throw new IllegalStateException("You should call startInAppPayWithCustomSheet() before updateControl");
            }
            if (result == -109) {
                throw new IllegalStateException("Samsung Pay Service is locked by other application.");
            }
        }).onError((errorType, errCode, errorExtra) -> {
            throw new IllegalStateException("Exception: " + errCode);
        }).create();
        this.mPaymentManagerStub.executeRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_1_5);
    }

    public void startSimplePay(@NonNull CardInfo cardInfo, @NonNull StatusListener listener) {
        Log.d((String)TAG, (String)"startSimplePay : SDK API Level = 1.1");
        this.assertNotNull(cardInfo);
        this.assertNotNull(cardInfo.getCardId());
        this.assertNotNull(listener);
        Bundle cardMetaData = cardInfo.getCardMetaData();
        if (cardMetaData == null || cardMetaData.get(EXTRA_PAY_OPERATION_TYPE) == null || cardMetaData.get(EXTRA_TRANSACTION_TYPE) == null) {
            throw new IllegalArgumentException("PaymentManager.EXTRA_PAY_OPERATION_TYPE and PaymentManager.EXTRA_TRANSACTION_TYPE are must be set.");
        }
        SpayStatusListener stListener = new SpayStatusListener();
        PartnerRequest pReq = new PartnerRequest.Builder(this, 203, listener).setName("startSimplePay").setObj1(stListener).setObj2(cardInfo).onExecute((stub, request) -> this.doStartSimplePay((ISPaymentManager)stub, request)).onError((errorType, errorCode, errorExtra) -> listener.onFail(errorCode, errorExtra)).create();
        stListener.setPartnerListenerRef(listener);
        this.mPaymentManagerStub.postRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_1_1);
    }

    @Deprecated
    public void startInAppPay(@NonNull PaymentInfo paymentRequest, @NonNull TransactionInfoListener listener) {
        Log.d((String)TAG, (String)"startInAppPay : SDK API Level = 1.1");
        this.assertNotNull(paymentRequest);
        this.assertNotNull(listener);
        Context context = (Context)this.contextRef.get();
        SpaySdk.SdkApiLevel partnerDefinedSdkApiLevel = SpayValidity.readPartnerApiLevelInManifest(context);
        boolean needCheck = true;
        if (needCheck && partnerDefinedSdkApiLevel.compareTo(SpaySdk.SdkApiLevel.LEVEL_2_8) >= 0) {
            throw new IllegalStateException("startInAppPay is deprecated from SDK version 2.0. please do not use this api anymore");
        }
        String exceptionMessage = this.checkPaymentInfoValidity(paymentRequest);
        if (!exceptionMessage.isEmpty()) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        PartnerRequest pReq = new PartnerRequest.Builder(this, 200, listener).checkApiLevelFor(paymentRequest.getExtraPaymentInfo()).setName("startInAppPay").setObj1(paymentRequest).onExecute((stub, request) -> this.doStart((ISPaymentManager)stub, request)).onError((errorType, errorCode, errorExtra) -> listener.onFailure(errorCode, errorExtra)).create();
        this.mPaymentManagerStub.postRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_1_1);
    }

    public void startInAppPayWithCustomSheet(@NonNull CustomSheetPaymentInfo customSheetPaymentInfo, @NonNull CustomSheetTransactionInfoListener listener) {
        Log.d((String)TAG, (String)"startInAppPayWithCustomSheet : SDK API Level = 1.3");
        this.startInAppPayCommon(customSheetPaymentInfo, listener, null, null, SpaySdk.SdkApiLevel.LEVEL_1_3);
    }

    @Deprecated
    public void startInAppPayWithUserInfo(@NonNull CustomSheetPaymentInfo customSheetPaymentInfo, @NonNull CustomSheetTransactionInfoListener transactionListener, RequestType[] requiredTypes, UserInfoListener userInfoListener) {
        Log.d((String)TAG, (String)"startInAppPayWithUserInfo : SDK API Level = 2.6");
        this.assertNotNull(userInfoListener);
        this.verifyAddressControls(customSheetPaymentInfo, requiredTypes);
        RequestType[] finalRequiredTypes = this.assertContainsPaymentCardType(requiredTypes);
        this.startInAppPayCommon(customSheetPaymentInfo, transactionListener, finalRequiredTypes, userInfoListener, SpaySdk.SdkApiLevel.LEVEL_2_6);
    }

    private void startInAppPayCommon(@NonNull CustomSheetPaymentInfo customSheetPaymentInfo, @NonNull CustomSheetTransactionInfoListener transactionListener, RequestType[] requiredTypes, @Nullable UserInfoListener userInfoListener, SpaySdk.SdkApiLevel apiLevel) {
        this.assertNotNull(customSheetPaymentInfo);
        this.assertNotNull(transactionListener);
        this.verifyOrderNumberForVISA(customSheetPaymentInfo);
        String exceptionMessage = this.checkPaymentInfoValidity(customSheetPaymentInfo);
        if (!exceptionMessage.isEmpty()) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        RequestType[] cloneRequiredTypes = userInfoListener != null ? this.convertRequestAllType(requiredTypes) : null;
        PartnerRequest pReq = new PartnerRequest.Builder(this, 204, transactionListener).setName("startInAppPayCommon").checkApiLevelFor(new Object[]{cloneRequiredTypes, this.getPartnerInfo().getData(), customSheetPaymentInfo.getCustomSheet(), customSheetPaymentInfo.getExtraPaymentInfo()}).setObj1(customSheetPaymentInfo).setObj2(1).checkDuplication(true).onExecute((stub, request) -> this.doStartWithCustomSheet((ISPaymentManager)stub, request, cloneRequiredTypes, userInfoListener)).onError((errorType, errorCode, errorMsg) -> transactionListener.onFailure(errorCode, errorMsg)).create();
        this.mPaymentManagerStub.postRequest(pReq, apiLevel);
    }

    private RequestType[] assertContainsPaymentCardType(@Nullable RequestType[] requiredTypes) {
        if (requiredTypes != null) {
            ArrayList<RequestType> typeList = new ArrayList<RequestType>();
            Collections.addAll(typeList, requiredTypes);
            if (!typeList.contains((Object)RequestType.PAYMENT_CARD)) {
                typeList.add(RequestType.PAYMENT_CARD);
                requiredTypes = typeList.toArray(new RequestType[typeList.size()]);
            }
        }
        return requiredTypes;
    }

    private void verifyAddressControls(@NonNull CustomSheetPaymentInfo customSheetPaymentInfo, @Nullable RequestType[] requestTypes) {
        if (requestTypes == null || requestTypes.length == 0) {
            return;
        }
        boolean billingRequestFlag = false;
        boolean shippingRequestFlag = false;
        ArrayList<RequestType> requestList = new ArrayList<RequestType>();
        if (requestTypes[0] == RequestType.ALL) {
            requestList.addAll(Arrays.asList(RequestType.values()));
        } else {
            requestList.addAll(Arrays.asList(requestTypes));
        }
        for (RequestType requestType : requestList) {
            if (requestType == RequestType.BILLING_ADDRESS) {
                billingRequestFlag = true;
                continue;
            }
            if (requestType != RequestType.SHIPPING_ADDRESS) continue;
            shippingRequestFlag = true;
        }
        if (billingRequestFlag || shippingRequestFlag) {
            for (SheetControl sheetControl : customSheetPaymentInfo.getCustomSheet().getSheetControls()) {
                if (!(sheetControl instanceof AddressControl)) continue;
                SheetItemType type = ((AddressControl)sheetControl).getSheetItem().getSheetItemType();
                if (type == SheetItemType.SHIPPING_ADDRESS) {
                    shippingRequestFlag = false;
                    continue;
                }
                if (type != SheetItemType.BILLING_ADDRESS) continue;
                billingRequestFlag = false;
            }
            if (shippingRequestFlag) {
                throw new IllegalArgumentException("Shipping address is requested in RequestTypes but CustomSheet doesn't contain a shipping address control. Add a shipping address control to CustomSheet");
            }
            if (billingRequestFlag) {
                throw new IllegalArgumentException("Billing address is requested in RequestTypes but CustomSheet doesn't contain a billing address control. Add a billing address control to CustomSheet");
            }
        }
    }

    private void verifyOrderNumberForVISA(@NonNull CustomSheetPaymentInfo customSheetPaymentInfo) {
        List<SpaySdk.Brand> allowedBrands = customSheetPaymentInfo.getAllowedCardBrands();
        String orderNumber = customSheetPaymentInfo.getOrderNumber();
        if (!TextUtils.isEmpty((CharSequence)orderNumber)) {
            if (allowedBrands == null || allowedBrands.size() == 0 || allowedBrands.contains((Object)SpaySdk.Brand.VISA)) {
                Pattern pattern = Pattern.compile("[a-zA-Z0-9-]*");
                Matcher matcher = pattern.matcher(orderNumber);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Order number contains non-allowed character. Alphanumeric and hyphens(-) are allowed.");
                }
                if (orderNumber.length() > 36) {
                    throw new IllegalArgumentException("Order number is more than 36 characters");
                }
            }
        } else if (allowedBrands == null || allowedBrands.size() == 0) {
            Log.w((String)TAG, (String)"Order number is empty. The request would be failed if user selects VISA for payment. Consider to provide an order number or exclude VISA from allowed card brands");
        } else if (allowedBrands.contains((Object)SpaySdk.Brand.VISA)) {
            throw new IllegalArgumentException("Order number is mandatory for VISA");
        }
    }

    @Deprecated
    public void getFastCheckoutStatus(@NonNull StatusListener listener) {
        Log.d((String)TAG, (String)"getFastCheckoutStatus() : SDK API Level = 1.9");
        SpayStatusListener stListener = new SpayStatusListener();
        PartnerRequest pReq = new PartnerRequest.Builder(this, 205, listener).setName("getFastCheckoutStatus").setObj1(stListener).onExecute((stub, request) -> this.doGetFCOStatus((ISPaymentManager)stub, request)).onError((errorType, errorCode, errorMsg) -> listener.onFail(errorCode, errorMsg)).create();
        stListener.setPartnerListenerRef(listener);
        this.mPaymentManagerStub.postRequest(pReq, SpaySdk.SdkApiLevel.LEVEL_1_9);
    }

    private void nextRequest() {
        this.mPaymentManagerStub.nextRequest();
    }

    private void sendFailMessage(int errCode, PartnerRequest request) {
        Message msg = new Message();
        msg.what = 102;
        msg.arg1 = errCode;
        msg.obj = request;
        this.mEventHandler.sendMessage(msg);
    }

    private void sendFailMessageForCustomSheet(int errCode, Bundle bundle, PartnerRequest request) {
        Message msg = new Message();
        msg.what = 110;
        msg.arg1 = errCode;
        msg.obj = request;
        msg.setData(bundle);
        this.mEventHandler.sendMessage(msg);
    }

    private void doStart(@NonNull ISPaymentManager stub, @NonNull PartnerRequest pReq) throws RemoteException {
        PaymentInfo pInfo = (PaymentInfo)pReq.obj1;
        if (this.getPartnerInfo().getData() == null) {
            this.getPartnerInfo().setData(new Bundle());
        }
        InAppPaymentCallback inAppPayCb = new InAppPaymentCallback(pReq);
        Log.d((String)TAG, (String)this.getPartnerInfo().toString());
        stub.initiateSession(this.getPartnerInfo(), pInfo, inAppPayCb);
    }

    private void doStartWithCustomSheet(@NonNull ISPaymentManager stub, @NonNull PartnerRequest pReq, RequestType[] requireRequestTypes, @Nullable UserInfoListener callback) throws RemoteException {
        CustomSheetPaymentInfo pInfo = (CustomSheetPaymentInfo)pReq.obj1;
        if (this.getPartnerInfo().getData() == null) {
            this.getPartnerInfo().setData(new Bundle());
        }
        InAppPaymentCallback inAppPayCb = new InAppPaymentCallback(pReq);
        Log.d((String)TAG, (String)this.getPartnerInfo().toString());
        InAppUserInfoCallback inAppUserInfoCallback = callback != null ? new InAppUserInfoCallback(callback) : null;
        stub.initiateSessionWithSheetInfo(this.getPartnerInfo(), inAppPayCb, pInfo, requireRequestTypes, inAppUserInfoCallback);
    }

    private void doRequestCardInfo(@NonNull ISPaymentManager stub, @NonNull PartnerRequest pReq, @NonNull GetCardBrandListenerInternal listenerInternal) throws RemoteException {
        Bundle requestFilter = (Bundle)pReq.obj1;
        List<CardInfo> result = stub.requestCardType(requestFilter, this.getPartnerInfo(), listenerInternal.getBrandListener());
        if (!this.mIsAsyncResponse) {
            ((CardInfoListener)pReq.callbackObj).onResult(result);
            this.mPaymentManagerStub.nextRequest();
        }
    }

    private void doStartSimplePay(@NonNull ISPaymentManager stub, @NonNull PartnerRequest pReq) throws RemoteException {
        SpayStatusListener stListener = (SpayStatusListener)pReq.obj1;
        stub.startSimplePay(this.getPartnerInfo(), (CardInfo)pReq.obj2, stListener);
    }

    private void doGetFCOStatus(@NonNull ISPaymentManager stub, @NonNull PartnerRequest pReq) throws RemoteException {
        SpayStatusListener stListener = (SpayStatusListener)pReq.obj1;
        stub.getFastCheckoutStatus(this.getPartnerInfo(), stListener);
    }

    private void showPaymentSheet(@NonNull PartnerRequest partnerRequest, int callerUid) {
        Log.d((String)TAG, (String)"showPaymentSheet()");
        try {
            Intent intent = new Intent();
            Context liveContext = (Context)this.contextRef.get();
            if (liveContext == null) {
                throw new Exception("Context is destroyed");
            }
            if (liveContext instanceof Activity) {
                Log.d((String)TAG, (String)"Context is an instance of Activity");
                intent.setFlags(0x20000000);
            } else {
                Log.d((String)TAG, (String)"Not Activity context");
                intent.setFlags(0x10000000);
            }
            intent.setComponent((ComponentName)partnerRequest.obj3);
            intent.putExtra("callerUid", callerUid);
            intent.putExtra("sdkVersion", 2);
            intent.putExtra("use_bended_api", true);
            Object obj = partnerRequest.obj2;
            if (obj != null) {
                int customSheetVersion = (Integer)obj;
                intent.putExtra("customSheetVersion", customSheetVersion);
                Log.i((String)TAG, (String)("customSheetVersion : " + customSheetVersion));
            }
            liveContext.startActivity(intent);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("showPaymentSheet - Error: " + e.toString()));
            ((TransactionInfoListener)partnerRequest.callbackObj).onFailure(-1, null);
            this.nextRequest();
        }
    }

    private void sendMsgForGetCardBrandListener(@Nullable WeakReference<PartnerRequest> requestRef, int result, int arg1, Bundle data) {
        PartnerRequest request;
        if (requestRef == null || (request = (PartnerRequest)requestRef.get()) == null) {
            Log.d((String)TAG, (String)"request is NULL");
            return;
        }
        Message message = Message.obtain((Handler)this.mHandlerForInternalListener);
        message.obj = request.callbackObj;
        message.what = result;
        message.setData(data);
        if (result == 1) {
            message.arg1 = arg1;
        }
        this.mHandlerForInternalListener.sendMessage(message);
    }

    protected void sendMsgForStatusListener(@Nullable WeakReference<StatusListener> listenerRef, int result, int arg1, Bundle data) {
        StatusListener listener;
        if (listenerRef == null || (listener = (StatusListener)listenerRef.get()) == null) {
            Log.e((String)TAG, (String)"sendMsgForStatusListener - Listener is NULL");
            return;
        }
        Message message = Message.obtain((Handler)this.mHandlerForInternalListener);
        message.obj = listener;
        message.what = result;
        message.arg1 = arg1;
        message.setData(data);
        this.mHandlerForInternalListener.sendMessage(message);
    }

    protected void setServicePackage(String servicePackage) {
        this.mPaymentManagerStub.setServicePackage(servicePackage);
    }

    private void onFailure(@NonNull Message msg) {
        PartnerRequest partnerRequest = (PartnerRequest)msg.obj;
        if (partnerRequest.callbackObj instanceof TransactionInfoListener) {
            ((TransactionInfoListener)partnerRequest.callbackObj).onFailure(msg.arg1, msg.getData());
        } else if (partnerRequest.callbackObj instanceof CustomSheetTransactionInfoListener) {
            ((CustomSheetTransactionInfoListener)partnerRequest.callbackObj).onFailure(msg.arg1, msg.getData());
        }
    }

    private class GetCardBrandListenerInternal {
        @NonNull
        private SpayBrandListener mSpayGetBrandListener = new SpayBrandListener();
        @Nullable
        private WeakReference<PartnerRequest> pReqRef = null;
        private static final String TAG = "BrandListenerInternal";

        private GetCardBrandListenerInternal() {
        }

        public void set(PartnerRequest pReq) {
            this.pReqRef = new WeakReference<PartnerRequest>(pReq);
        }

        @NonNull
        protected ISGetCardBrandListener getBrandListener() {
            return this.mSpayGetBrandListener;
        }

        private class SpayBrandListener
        extends ISGetCardBrandListener.Stub {
            private SpayBrandListener() {
            }

            @Override
            public void onSuccess(List<CardInfo> cards) throws RemoteException {
                Log.d((String)GetCardBrandListenerInternal.TAG, (String)"onSuccess: ");
                Bundle bundle = new Bundle();
                bundle.putParcelableArrayList("KEY_FOR_MESSAGE", (ArrayList)cards);
                PaymentManager.this.sendMsgForGetCardBrandListener(GetCardBrandListenerInternal.this.pReqRef, 0, 0, bundle);
                PaymentManager.this.mPaymentManagerStub.nextRequest();
            }

            @Override
            public void onFail(int errorCode, Bundle errorData) throws RemoteException {
                Log.d((String)GetCardBrandListenerInternal.TAG, (String)("onFail: " + errorCode));
                PaymentManager.this.sendMsgForGetCardBrandListener(GetCardBrandListenerInternal.this.pReqRef, 1, errorCode, errorData);
                PaymentManager.this.mPaymentManagerStub.nextRequest();
            }

            @Override
            public void onProcess() {
                PaymentManager.this.mIsAsyncResponse = true;
                Log.d((String)GetCardBrandListenerInternal.TAG, (String)"SpayBrandListener - requestCardType onProcess()");
            }
        }
    }

    public static interface CardInfoListener {
        public void onResult(List<CardInfo> var1);

        public void onFailure(int var1, Bundle var2);
    }

    private class SpayStatusListener
    extends ISStatusListener.Stub {
        private static final String TAG = "SpayStatusListener";
        @Nullable
        private WeakReference<StatusListener> partnerListenerRef = null;

        private SpayStatusListener() {
        }

        public void setPartnerListenerRef(StatusListener listener) {
            this.partnerListenerRef = new WeakReference<StatusListener>(listener);
        }

        @Override
        public void onSuccess(PartnerInfo pInfo, int status, Bundle data) throws RemoteException {
            Log.d((String)TAG, (String)("onSuccess: status: " + status));
            PaymentManager.this.sendMsgForStatusListener(this.partnerListenerRef, 0, status, data);
            Log.d((String)TAG, (String)"calling to clean up from queue");
            PaymentManager.this.nextRequest();
        }

        @Override
        public void onFail(PartnerInfo pInfo, int errorCode, Bundle errorData) throws RemoteException {
            Log.e((String)TAG, (String)("onFail: errorCode: " + errorCode));
            PaymentManager.this.sendMsgForStatusListener(this.partnerListenerRef, 1, errorCode, errorData);
            Log.d((String)TAG, (String)"calling to clean up from queue");
            PaymentManager.this.nextRequest();
        }
    }

    @Deprecated
    public static interface TransactionInfoListener {
        public void onAddressUpdated(PaymentInfo var1);

        public void onCardInfoUpdated(CardInfo var1);

        public void onSuccess(PaymentInfo var1, String var2, Bundle var3);

        public void onFailure(int var1, @Nullable Bundle var2);
    }

    public static interface CustomSheetTransactionInfoListener {
        public void onCardInfoUpdated(CardInfo var1, CustomSheet var2);

        public void onSuccess(CustomSheetPaymentInfo var1, String var2, Bundle var3);

        public void onFailure(int var1, Bundle var2);
    }

    public class InAppPaymentCallback
    extends ISPaymentCallback.Stub {
        private WeakReference<PartnerRequest> pReqRef;

        public InAppPaymentCallback(PartnerRequest pReq) {
            this.pReqRef = new WeakReference<PartnerRequest>(pReq);
        }

        @Nullable
        private PartnerRequest getRequest() {
            PartnerRequest request = (PartnerRequest)this.pReqRef.get();
            if (request == null) {
                Log.e((String)PaymentManager.TAG, (String)"InAppPaymentCallback - request is NULL");
            }
            return request;
        }

        @Override
        public void onInitiateCompleted(@NonNull Bundle nextOrder) {
            Log.d((String)PaymentManager.TAG, (String)"onInitiateCompleted: ");
            PartnerRequest request = this.getRequest();
            if (request != null) {
                String packageName = nextOrder.getString("packageName");
                String className = nextOrder.getString("className");
                request.obj3 = new ComponentName(packageName, className);
                int callerUid = nextOrder.getInt("callerUid");
                Message msg = new Message();
                msg.what = 105;
                msg.obj = request;
                msg.arg1 = callerUid;
                PaymentManager.this.mEventHandler.sendMessage(msg);
            }
        }

        @Override
        public void onFailPayment(int errCode, String msg) {
            Log.e((String)PaymentManager.TAG, (String)("onFailPayment: errCode " + errCode));
            PartnerRequest request = this.getRequest();
            if (request != null) {
                PaymentManager.this.sendFailMessage(errCode, request);
            }
        }

        @Override
        public void onFailPaymentForCustomSheet(int errCode, Bundle extraData) {
            Log.e((String)PaymentManager.TAG, (String)("onFailPaymentForCustomSheet: errCode " + errCode));
            PartnerRequest request = this.getRequest();
            if (request != null) {
                PaymentManager.this.sendFailMessageForCustomSheet(errCode, extraData, request);
            }
        }

        @Override
        public void onAddressInfoChanged(PaymentInfo updatedPaymentInfo) {
            Log.d((String)PaymentManager.TAG, (String)"onAddressInfoChanged ");
            PartnerRequest request = this.getRequest();
            if (request != null) {
                Message msg = new Message();
                msg.what = 103;
                Bundle data = new Bundle();
                data.putParcelable(PaymentManager.KEY_PAYMENT_INFO, (Parcelable)updatedPaymentInfo);
                msg.setData(data);
                msg.obj = request;
                PaymentManager.this.mEventHandler.sendMessage(msg);
            }
        }

        @Override
        public void onCardInfoChanged(CardInfo updatedCard) {
            Log.d((String)PaymentManager.TAG, (String)"onCardInfoChanged ");
            PartnerRequest request = this.getRequest();
            if (request != null) {
                request.obj3 = updatedCard;
                Message msg = new Message();
                msg.what = 104;
                msg.obj = request;
                PaymentManager.this.mEventHandler.sendMessage(msg);
            }
        }

        @Override
        public void onApproveTransaction(PaymentInfo paymentInfo, String encryptedData) {
            Log.d((String)PaymentManager.TAG, (String)"onApproveTransaction ");
            PartnerRequest request = this.getRequest();
            if (request != null) {
                Message msg = new Message();
                msg.what = 101;
                Bundle data = new Bundle();
                data.putParcelable(PaymentManager.KEY_PAYMENT_INFO, (Parcelable)paymentInfo);
                data.putString(PaymentManager.KEY_ENCRYPTED_DATA, encryptedData);
                msg.setData(data);
                msg.obj = request;
                PaymentManager.this.mEventHandler.sendMessage(msg);
            }
        }

        @Override
        public void onCustomSheetUpdated(String updatedControlId, CustomSheet sheet) {
            Log.d((String)PaymentManager.TAG, (String)"onCustomSheetUpdated ");
            PartnerRequest request = this.getRequest();
            if (request != null) {
                Message msg = new Message();
                msg.what = 106;
                Bundle data = new Bundle();
                data.putString(PaymentManager.KEY_UPDATED_CONTROL_ID, updatedControlId);
                data.putParcelable(PaymentManager.KEY_CUSTOM_SHEET, (Parcelable)sheet);
                msg.setData(data);
                msg.obj = request;
                PaymentManager.this.mEventHandler.sendMessage(msg);
            }
        }

        @Override
        public void onCustomSheetTransactionApproved(String encryptedData, Bundle extraData, CustomSheetPaymentInfo customSheetPaymentInfo) {
            Log.d((String)PaymentManager.TAG, (String)"onCustomSheetTransactionApproved ");
            PartnerRequest request = this.getRequest();
            if (request != null) {
                Message msg = new Message();
                msg.what = 109;
                Bundle data = new Bundle();
                data.putParcelable(PaymentManager.KEY_CUSTOM_SHEET_PAYMENT_NFO, (Parcelable)customSheetPaymentInfo);
                data.putString(PaymentManager.KEY_ENCRYPTED_DATA, encryptedData);
                data.putParcelable(PaymentManager.KEY_EXTRA_DATA, (Parcelable)extraData);
                msg.setData(data);
                msg.obj = request;
                PaymentManager.this.mEventHandler.sendMessage(msg);
            }
        }

        @Override
        public void onCustomSheetCardInfoUpdated(CardInfo updatedCard, CustomSheet sheet) {
            Log.d((String)PaymentManager.TAG, (String)"onCustomSheetCardInfoUpdated ");
            PartnerRequest request = this.getRequest();
            if (request != null) {
                Message msg = new Message();
                msg.what = 108;
                Bundle data = new Bundle();
                data.putParcelable(PaymentManager.KEY_UPDATE_CARD, (Parcelable)updatedCard);
                data.putParcelable(PaymentManager.KEY_CUSTOM_SHEET, (Parcelable)sheet);
                msg.setData(data);
                msg.obj = request;
                PaymentManager.this.mEventHandler.sendMessage(msg);
            }
        }
    }

    public class InAppUserInfoCallback
    extends ISUserInfoCallback.Stub {
        private WeakReference<UserInfoListener> listenerRef;

        public InAppUserInfoCallback(UserInfoListener listener) {
            this.listenerRef = new WeakReference<UserInfoListener>(listener);
        }

        @Override
        public void onGetUserInfoInitiated(Bundle nextOrder) {
        }

        @Override
        public void onReceived(int errorCode, @NonNull Bundle data) {
            UserInfoListener listener = (UserInfoListener)this.listenerRef.get();
            if (listener != null) {
                if (errorCode == 0) {
                    UserInfoCollection userInfoCollection = new UserInfoCollection(data);
                    listener.onSuccess(userInfoCollection);
                } else {
                    listener.onFail(errorCode, data);
                }
            }
        }
    }
}

