/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.payment;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;

public class PaymentResultInfo
implements Parcelable {
    private static final String PAYMENT_RESULT_STATUS = "paymentResultStatus";
    private static final String PAYMENT_RESULT_ORDER_NUMBER = "paymentResultOrderNumber";
    private Bundle paymentResultData;
    public static final Parcelable.Creator<PaymentResultInfo> CREATOR = new Parcelable.Creator<PaymentResultInfo>(){

        @NonNull
        public PaymentResultInfo createFromParcel(@NonNull Parcel source) {
            return new PaymentResultInfo(source);
        }

        @NonNull
        public PaymentResultInfo[] newArray(int size) {
            return new PaymentResultInfo[size];
        }
    };

    public PaymentResultInfo(@NonNull Builder builder) {
        this.paymentResultData = builder.paymentResultData;
    }

    public PaymentResultInfo(@NonNull Parcel source) {
        this.readFromParcel(source);
    }

    public void readFromParcel(@NonNull Parcel source) {
        this.paymentResultData = source.readBundle();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeBundle(this.paymentResultData);
    }

    public String getPaymentResultStatus() {
        return this.paymentResultData.getString(PAYMENT_RESULT_STATUS, ResultStatus.UNKNOWN.name());
    }

    public String getPaymentResultOrderNumber() {
        return this.paymentResultData.getString(PAYMENT_RESULT_ORDER_NUMBER, "");
    }

    public static class Builder {
        private Bundle paymentResultData;

        @NonNull
        public Builder setPaymentResultStatus(@NonNull ResultStatus status) {
            if (this.paymentResultData == null) {
                this.paymentResultData = new Bundle();
            }
            this.paymentResultData.putString(PaymentResultInfo.PAYMENT_RESULT_STATUS, status.name());
            return this;
        }

        @NonNull
        public Builder setPaymentResultOrderNumber(String orderNumber) {
            this.paymentResultData.putString(PaymentResultInfo.PAYMENT_RESULT_ORDER_NUMBER, orderNumber);
            return this;
        }

        @NonNull
        public PaymentResultInfo build() {
            return new PaymentResultInfo(this);
        }
    }

    public static enum ResultStatus {
        UNKNOWN,
        CHARGED,
        REJECTED;

    }
}

