/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.payment;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;

public class TransactionResultInfo
implements Parcelable {
    private Double amount;
    private String currency;
    private String dateTime;
    private String issuer;
    private String approvalType;
    private String merchantName;
    private String userId;
    private Bundle extraData;
    public static final Parcelable.Creator<TransactionResultInfo> CREATOR = new Parcelable.Creator<TransactionResultInfo>(){

        @NonNull
        public TransactionResultInfo createFromParcel(@NonNull Parcel source) {
            return new TransactionResultInfo(source);
        }

        @NonNull
        public TransactionResultInfo[] newArray(int size) {
            return new TransactionResultInfo[size];
        }
    };

    public TransactionResultInfo(@NonNull Builder builder) {
        this.amount = builder.amount;
        this.currency = builder.currency;
        this.dateTime = builder.dateTime;
        this.issuer = builder.issuer;
        this.approvalType = builder.approvalType;
        this.merchantName = builder.merchantName;
        this.userId = builder.userId;
        this.extraData = builder.extraData;
    }

    public TransactionResultInfo(@NonNull Parcel source) {
        this.readFromParcel(source);
    }

    public void readFromParcel(@NonNull Parcel source) {
        this.amount = source.readDouble();
        this.currency = source.readString();
        this.dateTime = source.readString();
        this.issuer = source.readString();
        this.approvalType = source.readString();
        this.merchantName = source.readString();
        this.userId = source.readString();
        this.extraData = source.readBundle();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeDouble(this.amount.doubleValue());
        dest.writeString(this.currency);
        dest.writeString(this.dateTime);
        dest.writeString(this.issuer);
        dest.writeString(this.approvalType);
        dest.writeString(this.merchantName);
        dest.writeString(this.userId);
        dest.writeBundle(this.extraData);
    }

    public Double getTransactionAmount() {
        return this.amount;
    }

    public String getTransactionCurrency() {
        return this.currency;
    }

    public String getTransactionDateTime() {
        return this.dateTime;
    }

    public String getTransactionIssuer() {
        return this.issuer;
    }

    public String getTransactionApprovalType() {
        return this.approvalType;
    }

    public String getTransactionMerchantName() {
        return this.merchantName;
    }

    public String getUserProfileId() {
        return this.userId;
    }

    @NonNull
    public Bundle getExtraData() {
        if (this.extraData == null) {
            this.extraData = new Bundle();
        }
        return this.extraData;
    }

    public static class Builder {
        private Double amount;
        private String currency;
        private String dateTime;
        private String issuer;
        private String approvalType;
        private String merchantName;
        private String userId;
        private Bundle extraData;

        @NonNull
        public Builder setTransactionAmount(Double tranAmount) {
            this.amount = tranAmount;
            return this;
        }

        @NonNull
        public Builder setTransactionCurrency(String tranCurrency) {
            this.currency = tranCurrency;
            return this;
        }

        @NonNull
        public Builder setTransactionDateTime(String tranDateTime) {
            this.dateTime = tranDateTime;
            return this;
        }

        @NonNull
        public Builder setTransactionIssuer(String tranIssuer) {
            this.issuer = tranIssuer;
            return this;
        }

        @NonNull
        public Builder setTransactionApprovalType(@NonNull ApprovalType tranApprovalType) {
            this.approvalType = tranApprovalType.name();
            return this;
        }

        @NonNull
        public Builder setTransactionMerchantName(String tranMerchantName) {
            this.merchantName = tranMerchantName;
            return this;
        }

        @NonNull
        public Builder setUserProfileId(String userProfileId) {
            this.userId = userProfileId;
            return this;
        }

        @NonNull
        public Builder setExtraData(Bundle data) {
            this.extraData = data;
            return this;
        }

        @NonNull
        public TransactionResultInfo build() {
            return new TransactionResultInfo(this);
        }
    }

    public static enum ApprovalType {
        UNKNOWN,
        APPROVED,
        CANCELED,
        REJECTED;

    }
}

