/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.payment.sheet;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.payment.CustomSheetPaymentInfo;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetControl;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetItem;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetItemType;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetUpdatedListener;

public class AddressControl
extends SheetControl
implements Parcelable {
    private static final String TAG = "AddressControl";
    private static final String EXTRA_DISPLAY_OPTION = "extra_display_option";
    private int errorCode;
    private SheetItem sheetItem;
    private CustomSheetPaymentInfo.Address address;
    private SheetUpdatedListener sheetUpdatedListener;
    private int displayOption;
    public static final Parcelable.Creator<AddressControl> CREATOR = new Parcelable.Creator<AddressControl>(){

        @NonNull
        public AddressControl createFromParcel(@NonNull Parcel in) {
            in.readParcelable(SheetControl.Controltype.class.getClassLoader());
            return new AddressControl(in);
        }

        @NonNull
        public AddressControl[] newArray(int size) {
            return new AddressControl[size];
        }
    };

    public AddressControl(@NonNull String controlId, @Nullable SheetItemType sheetItemType) {
        super(SheetControl.Controltype.ADDRESS);
        this.setControlId(controlId);
        if (sheetItemType == null || !sheetItemType.equals((Object)SheetItemType.BILLING_ADDRESS) && !sheetItemType.equals((Object)SheetItemType.SHIPPING_ADDRESS) && !sheetItemType.equals((Object)SheetItemType.ZIP_ONLY_ADDRESS)) {
            throw new IllegalArgumentException("AddressControl : sheetItemType must be either BILLING_ADDRESS or SHIPPING_ADDRESS.");
        }
        this.sheetItem = new SheetItem.Builder().setSheetItemType(sheetItemType).setExtraValue(new Bundle()).build();
    }

    protected AddressControl(@NonNull Parcel in) {
        super(in);
        this.errorCode = in.readInt();
        this.sheetItem = (SheetItem)in.readParcelable(SheetItem.class.getClassLoader());
        this.address = (CustomSheetPaymentInfo.Address)in.readParcelable(CustomSheetPaymentInfo.Address.class.getClassLoader());
        if (this.sheetItem.getExtraValue() != null) {
            this.displayOption = this.sheetItem.getExtraValue().getInt(EXTRA_DISPLAY_OPTION);
        }
        this.setControltype(SheetControl.Controltype.ADDRESS);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.errorCode);
        dest.writeParcelable((Parcelable)this.sheetItem, flags);
        dest.writeParcelable((Parcelable)this.address, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public SheetUpdatedListener getSheetUpdatedListener() {
        return this.sheetUpdatedListener;
    }

    public void setSheetUpdatedListener(SheetUpdatedListener sheetUpdatedListener) {
        this.sheetUpdatedListener = sheetUpdatedListener;
    }

    public SheetItem getSheetItem() {
        return this.sheetItem;
    }

    public CustomSheetPaymentInfo.Address getAddress() {
        return this.address;
    }

    public void setAddress(CustomSheetPaymentInfo.Address address) {
        this.address = address;
    }

    public SheetItemType getAddressType() {
        return this.sheetItem.getSheetItemType();
    }

    public void setAddressTitle(@NonNull String title) {
        SheetItem item = this.sheetItem;
        this.sheetItem = new SheetItem.Builder().setId(item.getId()).setTitle(title).setSheetItemType(item.getSheetItemType()).setExtraValue(item.getExtraValue()).build();
    }

    public String getAddressTitle() {
        return this.sheetItem.getTitle();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setDisplayOption(int displayOption) {
        if (this.sheetItem.getSheetItemType() != SheetItemType.SHIPPING_ADDRESS) {
            throw new IllegalArgumentException("setDisplayOption : sheetItemType must be either SHIPPING_ADDRESS.");
        }
        this.displayOption = displayOption;
        SheetItem item = this.sheetItem;
        Bundle extraValue = new Bundle(item.getExtraValue());
        extraValue.putInt(EXTRA_DISPLAY_OPTION, displayOption);
        this.sheetItem = new SheetItem.Builder().setId(item.getId()).setTitle(item.getTitle()).setSheetItemType(item.getSheetItemType()).setExtraValue(extraValue).build();
    }

    public int getDisplayOption() {
        return this.displayOption;
    }
}

