/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.payment.sheet;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetControl;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetItem;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetItemType;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import java.util.Set;

public class AmountBoxControl
extends SheetControl
implements Parcelable {
    private static final String TAG = "AmountBoxControl";
    private List<SheetItem> items = new ArrayList<SheetItem>();
    private String currencyCode;
    public static final Parcelable.Creator<AmountBoxControl> CREATOR = new Parcelable.Creator<AmountBoxControl>(){

        @NonNull
        public AmountBoxControl createFromParcel(@NonNull Parcel in) {
            in.readParcelable(SheetControl.Controltype.class.getClassLoader());
            return new AmountBoxControl(in);
        }

        @NonNull
        public AmountBoxControl[] newArray(int size) {
            return new AmountBoxControl[size];
        }
    };

    public AmountBoxControl(@NonNull String controlId, @NonNull String currencyCode) {
        super(SheetControl.Controltype.AMOUNTBOX);
        this.setControlId(controlId);
        this.setCurrencyCode(currencyCode);
    }

    protected AmountBoxControl(@NonNull Parcel in) {
        super(in);
        this.items = in.createTypedArrayList(SheetItem.CREATOR);
        this.currencyCode = in.readString();
        this.setControltype(SheetControl.Controltype.AMOUNTBOX);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeTypedList(this.items);
        dest.writeString(this.currencyCode);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public List<SheetItem> getItems() {
        return this.items;
    }

    public double getValue(@NonNull String id) {
        int foundIndex = this.getItemIndex(id);
        if (foundIndex > -1) {
            return this.items.get(foundIndex).getDValue();
        }
        throw new IllegalArgumentException("id is invalid.");
    }

    private int getItemIndex(@NonNull String id) {
        for (int foundIndex = 0; foundIndex < this.items.size(); ++foundIndex) {
            if (!id.equals(this.items.get(foundIndex).getId())) continue;
            return foundIndex;
        }
        return -1;
    }

    private int getAmountTotalIndex() {
        for (int foundIndex = 0; foundIndex < this.items.size(); ++foundIndex) {
            if (this.items.get(foundIndex).getSheetItemType() != SheetItemType.AMOUNT_TOTAL) continue;
            return foundIndex;
        }
        return -1;
    }

    private boolean hasAmountTotal() {
        return this.getAmountTotalIndex() > -1;
    }

    public boolean existItem(@NonNull String id) {
        return this.getItemIndex(id) > -1;
    }

    public void addItem(@NonNull String id, @NonNull String title, double price, @NonNull String extraPrice) {
        if (this.hasAmountTotal()) {
            this.addItem(this.items.size() - 1, id, title, price, extraPrice);
        } else {
            this.addItem(this.items.size(), id, title, price, extraPrice);
        }
    }

    public void addItem(int location, @NonNull String id, @NonNull String title, double price, @NonNull String extraPrice) {
        if (location < 0 || this.hasAmountTotal() && location >= this.items.size() || !this.hasAmountTotal() && location > this.items.size()) {
            throw new IllegalArgumentException("addItem : there is abnormal location");
        }
        if (this.getItemIndex(id) > -1) {
            throw new IllegalArgumentException("addItem : same id is used.");
        }
        SheetItem sheetItem = new SheetItem.Builder().setId(id).setTitle(title).setDValue(price).setSValue(extraPrice).setSheetItemType(SheetItemType.AMOUNT_ITEM).build();
        this.items.add(location, sheetItem);
    }

    public void setAmountTotal(double price, @NonNull String displayOption) {
        if (displayOption.isEmpty()) {
            throw new IllegalArgumentException("setAmountTotal : You must set displayOption.");
        }
        int foundIndex = this.getAmountTotalIndex();
        SheetItem sheetItem = new SheetItem.Builder().setId("").setTitle("").setDValue(price).setSValue(displayOption).setSheetItemType(SheetItemType.AMOUNT_TOTAL).build();
        if (foundIndex > -1) {
            this.items.set(foundIndex, sheetItem);
        } else {
            this.items.add(sheetItem);
        }
    }

    public void removeItem(@NonNull String id) {
        int index = this.getItemIndex(id);
        if (index < 0) {
            throw new IllegalArgumentException("removeItem : there is no id.");
        }
        this.items.remove(index);
    }

    public void updateValue(@NonNull String id, double price) {
        int foundIndex = this.getItemIndex(id);
        if (foundIndex > -1) {
            SheetItem sheetItem = new SheetItem.Builder().setId(id).setTitle(this.items.get(foundIndex).getTitle()).setDValue(price).setSValue("").setSheetItemType(this.items.get(foundIndex).getSheetItemType()).build();
            this.items.set(foundIndex, sheetItem);
            return;
        }
        throw new IllegalArgumentException("updateValue : there are no items associated with the id.");
    }

    public void updateValue(@NonNull String id, double price, @Nullable String extraPrice) {
        int foundIndex = this.getItemIndex(id);
        if (foundIndex > -1) {
            SheetItem sheetItem = new SheetItem.Builder().setId(id).setTitle(this.items.get(foundIndex).getTitle()).setDValue(price).setSValue(extraPrice).setSheetItemType(this.items.get(foundIndex).getSheetItemType()).build();
            this.items.set(foundIndex, sheetItem);
            return;
        }
        throw new IllegalArgumentException("updateValue : there are no items associated with the id.");
    }

    public void updateTitle(@NonNull String id, @Nullable String title) {
        int foundIndex = this.getItemIndex(id);
        if (foundIndex > -1) {
            SheetItem sheetItem = new SheetItem.Builder().setId(id).setTitle(title).setDValue(this.items.get(foundIndex).getDValue()).setSValue(this.items.get(foundIndex).getSValue()).setSheetItemType(this.items.get(foundIndex).getSheetItemType()).build();
            this.items.set(foundIndex, sheetItem);
            return;
        }
        throw new IllegalArgumentException("updateTitle : there are no items associated with the id.");
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(@NonNull String currencyCode) {
        Set<Currency> currencySet = Currency.getAvailableCurrencies();
        for (Currency currencyInfo : currencySet) {
            try {
                if (!currencyInfo.getCurrencyCode().equals(currencyCode)) continue;
                this.currencyCode = currencyCode;
                return;
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalArgumentException(currencyCode + " is invalid currencyCode.");
    }

    @NonNull
    public String toString() {
        return "AmountBoxControl{, items=" + this.items + ", currencyCode='" + this.currencyCode + '\'' + '}';
    }
}

