/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.payment.sheet;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.AmountBoxControl;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetControl;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetItemType;
import java.util.ArrayList;
import java.util.List;

public class CustomSheet
implements Parcelable {
    private static final String TAG = "CustomSheet";
    private List<SheetControl> sheetControls = new ArrayList<SheetControl>();
    public static final Parcelable.Creator<CustomSheet> CREATOR = new Parcelable.Creator<CustomSheet>(){

        @NonNull
        public CustomSheet createFromParcel(@NonNull Parcel in) {
            return new CustomSheet(in);
        }

        @NonNull
        public CustomSheet[] newArray(int size) {
            return new CustomSheet[size];
        }
    };

    public CustomSheet() {
    }

    protected CustomSheet(@NonNull Parcel in) {
        this.sheetControls = in.createTypedArrayList(SheetControl.CREATOR);
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedList(this.sheetControls);
    }

    public int describeContents() {
        return 0;
    }

    public void addControl(@NonNull SheetControl sheetControl) {
        this.addControl(this.sheetControls.size(), sheetControl);
    }

    public void addControl(int location, @NonNull SheetControl sheetControl) {
        if (location < 0 || location > this.sheetControls.size()) {
            throw new IllegalArgumentException("addItem : there is abnormal location.");
        }
        if (this.getSheetControl(sheetControl.getControlId()) != null) {
            throw new IllegalArgumentException("addControl : same id is used.");
        }
        if (sheetControl.getControltype() == SheetControl.Controltype.AMOUNTBOX) {
            AmountBoxControl amountBoxControl = (AmountBoxControl)sheetControl;
            int lastItemIndex = amountBoxControl.getItems().size() - 1;
            if (lastItemIndex < 0) {
                throw new IllegalArgumentException("addControl : No data in AmountBoxControl.");
            }
            if (!amountBoxControl.getItems().get(lastItemIndex).getSheetItemType().equals((Object)SheetItemType.AMOUNT_TOTAL)) {
                throw new IllegalArgumentException("AMOUNT_TOTAL type must be the last item in AmountBoxControl.");
            }
        }
        this.sheetControls.add(location, sheetControl);
    }

    public boolean updateControl(@NonNull SheetControl sheetControl) {
        if (this.sheetControls != null) {
            for (int foundIndex = 0; foundIndex < this.sheetControls.size(); ++foundIndex) {
                if (!sheetControl.equals(this.sheetControls.get(foundIndex))) continue;
                this.sheetControls.set(foundIndex, sheetControl);
                return true;
            }
        }
        return false;
    }

    public boolean removeControl(@NonNull SheetControl sheetControl) {
        if (sheetControl.getControltype() == SheetControl.Controltype.AMOUNTBOX) {
            throw new IllegalArgumentException("AmountBoxControl must not be deleted.");
        }
        if (sheetControl.getControltype() == SheetControl.Controltype.ADDRESS) {
            throw new IllegalArgumentException("AddressControl must not be deleted.");
        }
        if (this.sheetControls != null) {
            for (int foundIndex = 0; foundIndex < this.sheetControls.size(); ++foundIndex) {
                if (!sheetControl.equals(this.sheetControls.get(foundIndex))) continue;
                this.sheetControls.remove(foundIndex);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public SheetControl getSheetControl(@NonNull String controlId) {
        for (SheetControl controll : this.sheetControls) {
            if (!controlId.equals(controll.getControlId())) continue;
            return controll;
        }
        return null;
    }

    public List<SheetControl> getSheetControls() {
        return this.sheetControls;
    }
}

