/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.payment.sheet;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.AddressControl;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.AmountBoxControl;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.PlainTextControl;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SpinnerControl;

public class SheetControl
implements Parcelable {
    private Controltype controltype;
    private String controlId;
    public static final Parcelable.Creator<SheetControl> CREATOR = new Parcelable.Creator<SheetControl>(){

        @NonNull
        public SheetControl createFromParcel(@NonNull Parcel in) {
            Controltype controltype = (Controltype)in.readParcelable(Controltype.class.getClassLoader());
            switch (controltype) {
                case PLAINTEXT: {
                    return new PlainTextControl(in);
                }
                case AMOUNTBOX: {
                    return new AmountBoxControl(in);
                }
                case ADDRESS: {
                    return new AddressControl(in);
                }
                case SPINNER: {
                    return new SpinnerControl(in);
                }
            }
            return new SheetControl(in);
        }

        @NonNull
        public SheetControl[] newArray(int size) {
            return new SheetControl[size];
        }
    };

    protected SheetControl(@NonNull Parcel in) {
        this.controlId = in.readString();
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.controltype, flags);
        dest.writeString(this.controlId);
    }

    public int describeContents() {
        return 0;
    }

    public SheetControl(Controltype controltype) {
        this.controltype = controltype;
    }

    public String getControlId() {
        return this.controlId;
    }

    protected void setControlId(@NonNull String controlId) {
        if (controlId == null || controlId.length() == 0) {
            throw new IllegalArgumentException("setControlId : controlId is invalid.");
        }
        this.controlId = controlId;
    }

    public Controltype getControltype() {
        return this.controltype;
    }

    public void setControltype(Controltype controltype) {
        this.controltype = controltype;
    }

    public boolean equals(@Nullable Object sheetController) {
        if (this == sheetController) {
            return true;
        }
        if (sheetController == null || this.getClass() != sheetController.getClass()) {
            return false;
        }
        SheetControl that = (SheetControl)sheetController;
        if (this.controlId != null ? !this.controlId.equals(that.controlId) : that.controlId != null) {
            return false;
        }
        return this.controltype == that.controltype;
    }

    public int hashCode() {
        int result = this.controlId != null ? this.controlId.hashCode() : 0;
        result = 31 * result + (this.controltype != null ? this.controltype.hashCode() : 0);
        return result;
    }

    public static enum Controltype implements Parcelable
    {
        PLAINTEXT,
        AMOUNTBOX,
        ADDRESS,
        SPINNER;

        public static final Parcelable.Creator<Controltype> CREATOR;

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<Controltype>(){

                public Controltype createFromParcel(@NonNull Parcel in) {
                    return Controltype.values()[in.readInt()];
                }

                @NonNull
                public Controltype[] newArray(int size) {
                    return new Controltype[size];
                }
            };
        }
    }
}

