/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.payment.sheet;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetItemType;

public class SheetItem
implements Parcelable {
    private String id;
    private String title;
    private String sValue;
    private double dValue;
    private SheetItemType sheetItemType;
    private Bundle extraValue;
    public static final Parcelable.Creator<SheetItem> CREATOR = new Parcelable.Creator<SheetItem>(){

        @NonNull
        public SheetItem createFromParcel(@NonNull Parcel in) {
            return new SheetItem(in);
        }

        @NonNull
        public SheetItem[] newArray(int size) {
            return new SheetItem[size];
        }
    };

    private SheetItem(@NonNull Builder builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.sValue = builder.sValue;
        this.dValue = builder.dValue;
        this.sheetItemType = builder.sheetItemType;
        this.extraValue = builder.extraValue;
    }

    protected SheetItem(@NonNull Parcel in) {
        this.id = in.readString();
        this.title = in.readString();
        this.sValue = in.readString();
        this.dValue = in.readDouble();
        this.sheetItemType = (SheetItemType)in.readParcelable(SheetItemType.class.getClassLoader());
        this.extraValue = in.readBundle();
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.title);
        dest.writeString(this.sValue);
        dest.writeDouble(this.dValue);
        dest.writeParcelable((Parcelable)this.sheetItemType, flags);
        dest.writeBundle(this.extraValue);
    }

    public int describeContents() {
        return 0;
    }

    public SheetItemType getSheetItemType() {
        return this.sheetItemType;
    }

    public Bundle getExtraValue() {
        return this.extraValue;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSValue() {
        return this.sValue;
    }

    public double getDValue() {
        return this.dValue;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SheetItem that = (SheetItem)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @NonNull
    public String toString() {
        return "SheetItem{extraValue=" + this.extraValue + ", id='" + this.id + '\'' + ", title='" + this.title + '\'' + ", sValue='" + this.sValue + '\'' + ", dValue='" + this.dValue + '\'' + ", sheetItemType=" + (Object)((Object)this.sheetItemType) + '}';
    }

    public static class Builder {
        private String id;
        private String title;
        private String sValue;
        private double dValue;
        private SheetItemType sheetItemType;
        private Bundle extraValue;

        @NonNull
        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        @NonNull
        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        @NonNull
        public Builder setSValue(String sValue) {
            this.sValue = sValue;
            return this;
        }

        @NonNull
        public Builder setDValue(double dValue) {
            this.dValue = dValue;
            return this;
        }

        @NonNull
        public Builder setSheetItemType(SheetItemType sheetItemType) {
            this.sheetItemType = sheetItemType;
            return this;
        }

        @NonNull
        public Builder setExtraValue(Bundle extraValue) {
            this.extraValue = extraValue;
            return this;
        }

        @NonNull
        public SheetItem build() {
            return new SheetItem(this);
        }
    }
}

