/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.payment.sheet;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetControl;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetItem;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetItemType;
import com.samsung.android.sdk.samsungpay.v2.payment.sheet.SheetUpdatedListener;
import java.util.ArrayList;
import java.util.List;

public class SpinnerControl
extends SheetControl
implements Parcelable {
    private static final String TAG = "SpinnerControl";
    private List<SheetItem> items = new ArrayList<SheetItem>();
    private String selectedItemId;
    private SheetUpdatedListener sheetUpdatedListener;
    public static final Parcelable.Creator<SpinnerControl> CREATOR = new Parcelable.Creator<SpinnerControl>(){

        @NonNull
        public SpinnerControl createFromParcel(@NonNull Parcel in) {
            in.readParcelable(SheetControl.Controltype.class.getClassLoader());
            return new SpinnerControl(in);
        }

        @NonNull
        public SpinnerControl[] newArray(int size) {
            return new SpinnerControl[size];
        }
    };

    public SpinnerControl(@NonNull String controlId, @NonNull String title, SheetItemType sheetItemType) {
        super(SheetControl.Controltype.SPINNER);
        this.setControlId(controlId);
        if (title == null) {
            throw new NullPointerException("SpinnerControl : You must set title.");
        }
        if (sheetItemType != SheetItemType.SHIPPING_METHOD_SPINNER && sheetItemType != SheetItemType.INSTALLMENT_SPINNER) {
            throw new IllegalArgumentException("SpinnerControl : sheetItemType must be either SHIPPING_METHOD_SPINNER or INSTALLMENT_SPINNER.");
        }
        SheetItem SheetItem2 = new SheetItem.Builder().setId("").setTitle(title).setSheetItemType(sheetItemType).build();
        this.items.add(SheetItem2);
    }

    protected SpinnerControl(@NonNull Parcel in) {
        super(in);
        this.items = in.createTypedArrayList(SheetItem.CREATOR);
        this.selectedItemId = in.readString();
        this.setControltype(SheetControl.Controltype.SPINNER);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeTypedList(this.items);
        dest.writeString(this.selectedItemId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public SheetUpdatedListener getSheetUpdatedListener() {
        return this.sheetUpdatedListener;
    }

    public void setSheetUpdatedListener(SheetUpdatedListener sheetUpdatedListener) {
        this.sheetUpdatedListener = sheetUpdatedListener;
    }

    public String getTitle() {
        return this.items.get(0).getTitle();
    }

    public void setTitle(@NonNull String title) {
        SheetItem sheetItem = new SheetItem.Builder().setId("").setTitle(title).setSheetItemType(this.items.get(0).getSheetItemType()).build();
        this.items.set(0, sheetItem);
    }

    public String getSelectedItemId() {
        return this.selectedItemId;
    }

    public void setSelectedItemId(@NonNull String id) {
        if (!this.existItem(id)) {
            throw new IllegalArgumentException("setSelectedItemId : There is no item associated with the ID.");
        }
        this.selectedItemId = id;
    }

    public List<SheetItem> getItems() {
        return this.items;
    }

    public void addItem(@NonNull String id, @NonNull String itemText) {
        this.addItem(this.items.size() - 1, id, itemText);
    }

    public void addItem(int location, @NonNull String id, @NonNull String itemText) {
        if (this.existItem(id)) {
            throw new IllegalArgumentException("addItem : same ID is used.");
        }
        if (location < 0 || location > this.items.size() - 1) {
            throw new IllegalArgumentException("addItem : location is abnormal.");
        }
        SheetItem SheetItem2 = new SheetItem.Builder().setId(id).setSValue(itemText).build();
        this.items.add(location + 1, SheetItem2);
    }

    public void removeItem(@NonNull String id) {
        int index = this.getIndex(1, id);
        if (index < 0) {
            throw new IllegalArgumentException("removeItem : There is no item associated with the ID.");
        }
        this.items.remove(index);
    }

    public void updateItem(@NonNull String id, @NonNull String text) {
        int foundIndex = this.getIndex(1, id);
        if (foundIndex > -1) {
            SheetItem sheetItem = new SheetItem.Builder().setId(id).setSValue(text).build();
            this.items.set(foundIndex, sheetItem);
            return;
        }
        throw new IllegalArgumentException("updateItem : There is no item associated with the ID.");
    }

    public boolean existItem(@NonNull String id) {
        return this.getIndex(1, id) > -1;
    }

    private int getIndex(int startIndex, @NonNull String id) {
        while (startIndex < this.items.size()) {
            if (id.equals(this.items.get(startIndex).getId())) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }
}

