/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.samsungpay.v2.service;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import com.samsung.android.sdk.samsungpay.v2.PartnerInfo;
import com.samsung.android.sdk.samsungpay.v2.PartnerRequest;
import com.samsung.android.sdk.samsungpay.v2.SpaySdk;
import com.samsung.android.sdk.samsungpay.v2.StubBase;
import com.samsung.android.sdk.samsungpay.v2.service.ISServiceManager;
import com.samsung.android.sdk.samsungpay.v2.service.ISUserInfoCallback;
import com.samsung.android.sdk.samsungpay.v2.service.RequestType;
import com.samsung.android.sdk.samsungpay.v2.service.UserInfoCollection;
import com.samsung.android.sdk.samsungpay.v2.service.UserInfoListener;
import com.samsung.android.sdk.samsungpay.v2.service.UserSignUpNotifyListener;

public final class ServiceManager
extends SpaySdk {
    private static final String TAG = "SPAYSDK:ServiceManager";
    private static final int OPT_GET_USER_INFO = 0;
    private static final int OPT_NOTIFY_USER_SIGNUP_RESULT = 1;
    private StubBase<ISServiceManager> mServiceManagerStub;

    public ServiceManager(Context context, PartnerInfo partnerInfo) {
        super(context, partnerInfo);
        this.mServiceManagerStub = new StubBase.Creator<ISServiceManager>().createStub(context, "com.samsung.android.spay.sdk.v2.service.SoAppService", ISServiceManager.Stub::asInterface);
    }

    @Deprecated
    public void getUserInfo(RequestType[] requiredTypes, @NonNull UserInfoListener listener) {
        this.assertNotNull(listener);
        RequestType[] cloneRequiredTypes = this.convertRequestAllType(requiredTypes);
        PartnerRequest partnerRequest = new PartnerRequest.Builder(this, 0, null).setName("getUserInfo").checkApiLevelFor((Object[])cloneRequiredTypes).checkDuplication(true).onExecute((stub, request) -> this.doGetUserInfo((ISServiceManager)stub, cloneRequiredTypes, listener)).onError((errorType, errorCode, errorExtra) -> listener.onFail(errorCode, errorExtra)).create();
        this.mServiceManagerStub.postRequest(partnerRequest, SpaySdk.SdkApiLevel.LEVEL_2_6);
    }

    @Deprecated
    public int notifyUserSignUpResult(String userName, boolean result, @NonNull UserSignUpNotifyListener listener) {
        PartnerRequest partnerRequest = new PartnerRequest.Builder(this, 1, null).setName("notifyUserSignUpResult").onExecute((stub, request) -> this.doNotifyUserSignUpResult((ISServiceManager)stub, userName, result, listener)).onError((errorType, errorCode, errorExtra) -> listener.onFail(errorCode, errorExtra)).create();
        this.mServiceManagerStub.postRequest(partnerRequest, SpaySdk.SdkApiLevel.LEVEL_2_6);
        return 0;
    }

    private void doGetUserInfo(@NonNull ISServiceManager stub, RequestType[] requiredTypes, final @NonNull UserInfoListener listener) throws RemoteException {
        stub.getUserInfo(this.partnerInfo, requiredTypes, new ISUserInfoCallback.Stub(){

            @Override
            public void onGetUserInfoInitiated(@NonNull Bundle nextOrder) {
                Log.d((String)ServiceManager.TAG, (String)"onGetUserInfoInitiated: ");
                String packageName = nextOrder.getString("packageName");
                String className = nextOrder.getString("className");
                ComponentName componentName = new ComponentName(packageName, className);
                ServiceManager.this.runOnMainThread(() -> ServiceManager.this.showUserInfoSheet(componentName, nextOrder, listener));
            }

            @Override
            public void onReceived(int errorCode, @NonNull Bundle data) {
                if (errorCode == 0) {
                    UserInfoCollection userInfoCollection = new UserInfoCollection(data);
                    ServiceManager.this.runOnMainThread(() -> listener.onSuccess(userInfoCollection));
                } else {
                    ServiceManager.this.runOnMainThread(() -> listener.onFail(errorCode, data));
                }
                ServiceManager.this.mServiceManagerStub.nextRequest();
            }
        });
    }

    private void doNotifyUserSignUpResult(@NonNull ISServiceManager stub, String userName, boolean result, final @NonNull UserSignUpNotifyListener listener) throws RemoteException {
        stub.notifyUserSignUpResult(this.partnerInfo, userName, result, new ISUserInfoCallback.Stub(){

            @Override
            public void onGetUserInfoInitiated(Bundle nextOrder) {
            }

            @Override
            public void onReceived(int errorCode, Bundle data) {
                if (errorCode == 0) {
                    ServiceManager.this.runOnMainThread(() -> listener.onSuccess());
                } else {
                    ServiceManager.this.runOnMainThread(() -> listener.onFail(errorCode, data));
                }
                ServiceManager.this.mServiceManagerStub.nextRequest();
            }
        });
    }

    private void showUserInfoSheet(ComponentName componentName, @NonNull Bundle nextOrder, @NonNull UserInfoListener listener) {
        Log.d((String)TAG, (String)"showUserInfoSheet()");
        try {
            Intent intent = new Intent();
            Context liveContext = (Context)this.contextRef.get();
            if (liveContext == null) {
                Log.e((String)TAG, (String)"Context is destroyed");
                return;
            }
            if (liveContext instanceof Activity) {
                Log.d((String)TAG, (String)"Context is an instance of Activity");
                intent.setFlags(0x20000000);
            } else {
                Log.d((String)TAG, (String)"Not Activity context");
                intent.setFlags(0x10000000);
            }
            intent.setComponent(componentName);
            int callerUid = nextOrder.getInt("callerUid");
            intent.putExtra("callerUid", callerUid);
            intent.putExtra("sdkVersion", 2);
            intent.putExtra("nextOrder", nextOrder);
            liveContext.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Log.e((String)TAG, (String)"activity not found and return error");
            listener.onFail(-1, null);
            this.mServiceManagerStub.nextRequest();
        }
    }
}

