/*
 * Decompiled with CFR 0.152.
 */
package com.giftsets.reactnative.nmaps;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.giftsets.reactnative.nmaps.RNNaverMapCircleOverlay;
import com.giftsets.reactnative.nmaps.ReactUtil;

public class RNNaverMapCircleOverlayManager
extends ViewGroupManager<RNNaverMapCircleOverlay> {
    private final DisplayMetrics metrics;

    public RNNaverMapCircleOverlayManager(ReactApplicationContext reactContext) {
        if (Build.VERSION.SDK_INT >= 17) {
            this.metrics = new DisplayMetrics();
            ((WindowManager)reactContext.getSystemService("window")).getDefaultDisplay().getRealMetrics(this.metrics);
        } else {
            this.metrics = reactContext.getResources().getDisplayMetrics();
        }
    }

    @NonNull
    public String getName() {
        return "RNNaverMapCircleOverlay";
    }

    @NonNull
    protected RNNaverMapCircleOverlay createViewInstance(@NonNull ThemedReactContext reactContext) {
        return new RNNaverMapCircleOverlay((Context)reactContext);
    }

    @ReactProp(name="coordinate")
    public void setCenter(RNNaverMapCircleOverlay view, ReadableMap map) {
        view.setCenter(ReactUtil.toNaverLatLng(map));
    }

    @ReactProp(name="radius", defaultDouble=100.0)
    public void setRadius(RNNaverMapCircleOverlay view, double radius) {
        view.setRadius(radius);
    }

    @ReactProp(name="color", defaultInt=-65536, customType="Color")
    public void setColor(RNNaverMapCircleOverlay view, int color) {
        view.setColor(color);
    }

    @ReactProp(name="outlineWidth", defaultInt=0)
    public void setOutlineWidth(RNNaverMapCircleOverlay view, int outlineWidth) {
        view.setOutlineWidth(outlineWidth);
    }

    @ReactProp(name="outlineColor", defaultInt=-16777216, customType="Color")
    public void setOutlineColor(RNNaverMapCircleOverlay view, int outlineColor) {
        view.setOutlineColor(outlineColor);
    }

    @ReactProp(name="zIndex", defaultInt=0)
    public void setZIndex(RNNaverMapCircleOverlay view, int zIndex) {
        view.setZIndex(zIndex);
    }
}

