/*
 * Decompiled with CFR 0.152.
 */
package com.giftsets.reactnative.nmaps;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.drawable.Animatable;
import android.net.Uri;
import android.util.Property;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import androidx.annotation.Nullable;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.DataSource;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerBuilder;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.view.DraweeHolder;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.giftsets.reactnative.nmaps.OverlayImages;
import com.giftsets.reactnative.nmaps.RNNaverMapFeature;
import com.giftsets.reactnative.nmaps.ReactUtil;
import com.naver.maps.geometry.LatLng;
import com.naver.maps.map.overlay.Marker;
import com.naver.maps.map.overlay.OverlayImage;

public class RNNaverMapMarker
extends RNNaverMapFeature<Marker> {
    private final DraweeHolder<GenericDraweeHierarchy> imageHolder;
    private boolean animated = false;
    private int duration = 500;
    private TimeInterpolator easingFunction;

    public RNNaverMapMarker(Context context) {
        super(context);
        this.feature = new Marker();
        this.imageHolder = DraweeHolder.create((DraweeHierarchy)this.createDraweeHierarchy(), (Context)context);
        this.imageHolder.onAttach();
    }

    private GenericDraweeHierarchy createDraweeHierarchy() {
        return new GenericDraweeHierarchyBuilder(this.getResources()).setActualImageScaleType(ScalingUtils.ScaleType.FIT_CENTER).setFadeDuration(0).build();
    }

    public void setCoordinate(LatLng latLng) {
        if (this.animated && this.duration > 0) {
            this.setCoordinateAnimated(latLng, this.duration);
        } else {
            ((Marker)this.feature).setPosition(latLng);
        }
    }

    public void setCoordinateAnimated(LatLng finalPosition, int duration) {
        if (Double.isNaN(((Marker)this.feature).getPosition().latitude)) {
            ((Marker)this.feature).setPosition(finalPosition);
        } else {
            Property property = Property.of(Marker.class, LatLng.class, (String)"position");
            ObjectAnimator animator = ObjectAnimator.ofObject((Object)this.feature, (Property)property, ReactUtil::interpolate, (Object[])new LatLng[]{finalPosition});
            animator.setDuration((long)duration);
            if (this.easingFunction != null) {
                animator.setInterpolator(this.easingFunction);
            }
            animator.start();
        }
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public void setEasing(Integer easing) {
        switch (easing) {
            case 0: {
                this.easingFunction = new LinearInterpolator();
                break;
            }
            case 1: {
                this.easingFunction = new AccelerateDecelerateInterpolator();
                break;
            }
            case 2: {
                this.easingFunction = new AccelerateInterpolator();
                break;
            }
            case 3: {
                this.easingFunction = new DecelerateInterpolator();
                break;
            }
            case 4: {
                this.easingFunction = new BounceInterpolator();
                break;
            }
            default: {
                this.easingFunction = null;
            }
        }
    }

    public void setDuration(Integer duration) {
        if (duration != null && duration >= 0) {
            this.duration = duration;
        }
    }

    public void setAlpha(float alpha) {
        ((Marker)this.feature).setAlpha(alpha);
    }

    public void setAnchor(float x, float y) {
        ((Marker)this.feature).setAnchor(new PointF(x, y));
    }

    public void setIconTintColor(int color) {
        ((Marker)this.feature).setIconTintColor(color);
    }

    public void setFlat(boolean flat) {
        ((Marker)this.feature).setFlat(flat);
    }

    public void setRotation(float rotation) {
        ((Marker)this.feature).setAngle(rotation);
    }

    public void setWidth(int width) {
        ((Marker)this.feature).setWidth(width);
    }

    public void setHeight(int height) {
        ((Marker)this.feature).setHeight(height);
    }

    public void setImage(final String uri) {
        if (uri != null) {
            OverlayImage overlayImage = OverlayImages.get(uri);
            if (overlayImage != null) {
                this.setOverlayImage(overlayImage);
            } else if (uri.startsWith("http://") || uri.startsWith("https://") || uri.startsWith("file://") || uri.startsWith("asset://")) {
                ImageRequest imageRequest = ImageRequestBuilder.newBuilderWithSource((Uri)Uri.parse((String)uri)).build();
                final DataSource dataSource = Fresco.getImagePipeline().fetchDecodedImage(imageRequest, (Object)this);
                AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setImageRequest((Object)imageRequest)).setControllerListener((ControllerListener)new BaseControllerListener<ImageInfo>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onFinalImageSet(String id, @Nullable ImageInfo imageInfo, @Nullable Animatable animatable) {
                        CloseableReference imageReference = null;
                        OverlayImage overlayImage = null;
                        try {
                            CloseableStaticBitmap closeableStaticBitmap;
                            Bitmap bitmap;
                            CloseableImage image;
                            imageReference = (CloseableReference)dataSource.getResult();
                            if (imageReference != null && (image = (CloseableImage)imageReference.get()) instanceof CloseableStaticBitmap && (bitmap = (closeableStaticBitmap = (CloseableStaticBitmap)image).getUnderlyingBitmap()) != null) {
                                bitmap = bitmap.copy(Bitmap.Config.ARGB_8888, true);
                                overlayImage = OverlayImage.fromBitmap((Bitmap)bitmap);
                                OverlayImages.put(uri, overlayImage);
                            }
                        }
                        finally {
                            dataSource.close();
                            if (imageReference != null) {
                                CloseableReference.closeSafely((CloseableReference)imageReference);
                            }
                        }
                        if (overlayImage != null) {
                            RNNaverMapMarker.this.setOverlayImage(overlayImage);
                        }
                    }
                })).setOldController(this.imageHolder.getController())).build();
                this.imageHolder.setController((DraweeController)controller);
            } else {
                int rid = this.getRidFromName(uri);
                OverlayImage overlayImage1 = OverlayImage.fromResource((int)rid);
                OverlayImages.put(uri, overlayImage1);
                this.setOverlayImage(overlayImage1);
            }
        }
    }

    private void setOverlayImage(OverlayImage image) {
        ((Marker)this.feature).setIcon(image);
    }

    private int getRidFromName(String name) {
        return this.getContext().getResources().getIdentifier(name, "drawable", this.getContext().getPackageName());
    }
}

