/*
 * Decompiled with CFR 0.152.
 */
package com.giftsets.reactnative.nmaps;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.giftsets.reactnative.nmaps.RNNaverMapMarker;
import com.giftsets.reactnative.nmaps.ReactUtil;

public class RNNaverMapMarkerManager
extends ViewGroupManager<RNNaverMapMarker> {
    private final DisplayMetrics metrics;

    public RNNaverMapMarkerManager(ReactApplicationContext reactContext) {
        if (Build.VERSION.SDK_INT >= 17) {
            this.metrics = new DisplayMetrics();
            ((WindowManager)reactContext.getSystemService("window")).getDefaultDisplay().getRealMetrics(this.metrics);
        } else {
            this.metrics = reactContext.getResources().getDisplayMetrics();
        }
    }

    @NonNull
    public String getName() {
        return "RNNaverMapMarker";
    }

    @NonNull
    protected RNNaverMapMarker createViewInstance(@NonNull ThemedReactContext reactContext) {
        return new RNNaverMapMarker((Context)reactContext);
    }

    @ReactProp(name="coordinate")
    public void setCoordinate(RNNaverMapMarker view, ReadableMap map) {
        view.setCoordinate(ReactUtil.toNaverLatLng(map));
    }

    @ReactProp(name="anchor")
    public void setAnchor(RNNaverMapMarker view, ReadableMap map) {
        float x = map != null && map.hasKey("x") ? (float)map.getDouble("x") : 0.5f;
        float y = map != null && map.hasKey("y") ? (float)map.getDouble("y") : 1.0f;
        view.setAnchor(x, y);
    }

    @ReactProp(name="image")
    public void setImage(RNNaverMapMarker view, @Nullable String source) {
        view.setImage(source);
    }

    @ReactProp(name="pinColor", defaultInt=-65536, customType="Color")
    public void setPinColor(RNNaverMapMarker view, int pinColor) {
        view.setIconTintColor(pinColor);
    }

    @ReactProp(name="rotation", defaultFloat=0.0f)
    public void setMarkerRotation(RNNaverMapMarker view, float rotation) {
        view.setRotation(rotation);
    }

    @ReactProp(name="flat", defaultBoolean=false)
    public void setFlat(RNNaverMapMarker view, boolean flat) {
        view.setFlat(flat);
    }

    @ReactProp(name="width", defaultFloat=64.0f)
    public void setWidth(RNNaverMapMarker view, float width) {
        int widthInScreenPx = Math.round(this.metrics.density * width);
        view.setWidth(widthInScreenPx);
    }

    @ReactProp(name="height", defaultFloat=64.0f)
    public void setHeight(RNNaverMapMarker view, float height) {
        int heightInScreenPx = Math.round(this.metrics.density * height);
        view.setHeight(heightInScreenPx);
    }

    @ReactProp(name="animated", defaultBoolean=false)
    public void setAnimated(RNNaverMapMarker view, boolean animated) {
        view.setAnimated(animated);
    }

    @ReactProp(name="easing", defaultInt=-1)
    public void setEasing(RNNaverMapMarker view, int easingFunction) {
        view.setEasing(easingFunction);
    }

    @ReactProp(name="duration", defaultInt=500)
    public void setDuration(RNNaverMapMarker view, int duration) {
        view.setDuration(duration);
    }

    @ReactProp(name="alpha", defaultFloat=1.0f)
    public void setAlpha(RNNaverMapMarker view, float alpha) {
        view.setAlpha(alpha);
    }
}

