/*
 * Decompiled with CFR 0.152.
 */
package com.giftsets.reactnative.nmaps;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Animatable;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.DataSource;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerBuilder;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.view.DraweeHolder;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.giftsets.reactnative.nmaps.OverlayImages;
import com.giftsets.reactnative.nmaps.RNNaverMapFeature;
import com.naver.maps.geometry.LatLng;
import com.naver.maps.map.overlay.OverlayImage;
import com.naver.maps.map.overlay.PathOverlay;
import java.util.List;

public class RNNaverMapPathOverlay
extends RNNaverMapFeature<PathOverlay> {
    private final DraweeHolder<GenericDraweeHierarchy> imageHolder;

    public RNNaverMapPathOverlay(Context context) {
        super(context);
        this.feature = new PathOverlay();
        this.imageHolder = DraweeHolder.create((DraweeHierarchy)this.createDraweeHierarchy(), (Context)context);
        this.imageHolder.onAttach();
    }

    private GenericDraweeHierarchy createDraweeHierarchy() {
        return new GenericDraweeHierarchyBuilder(this.getResources()).setActualImageScaleType(ScalingUtils.ScaleType.FIT_CENTER).setFadeDuration(0).build();
    }

    public void setCoords(List<LatLng> coords) {
        ((PathOverlay)this.feature).setCoords(coords);
    }

    public void setWidth(float widthInScreenPx) {
        ((PathOverlay)this.feature).setWidth(Math.round(widthInScreenPx));
    }

    public void setZIndex(int zIndex) {
        ((PathOverlay)this.feature).setZIndex(zIndex);
    }

    public void setProgress(float progress) {
        ((PathOverlay)this.feature).setProgress((double)progress);
    }

    public void setOutlineWidth(float widthInScreenPx) {
        ((PathOverlay)this.feature).setOutlineWidth(Math.round(widthInScreenPx));
    }

    public void setColor(int color) {
        ((PathOverlay)this.feature).setColor(color);
    }

    public void setPassedColor(int color) {
        ((PathOverlay)this.feature).setPassedColor(color);
    }

    public void setOutlineColor(int color) {
        ((PathOverlay)this.feature).setOutlineColor(color);
    }

    public void setPassedOutlineColor(int color) {
        ((PathOverlay)this.feature).setPassedOutlineColor(color);
    }

    public void setPatternInterval(int patternInterval) {
        ((PathOverlay)this.feature).setPatternInterval(patternInterval);
    }

    public void setPattern(final String uri) {
        if (uri != null) {
            OverlayImage overlayImage = OverlayImages.get(uri);
            if (overlayImage != null) {
                this.setOverlayImage(overlayImage);
            } else if (uri.startsWith("http://") || uri.startsWith("https://") || uri.startsWith("file://") || uri.startsWith("asset://")) {
                ImageRequest imageRequest = ImageRequestBuilder.newBuilderWithSource((Uri)Uri.parse((String)uri)).build();
                final DataSource dataSource = Fresco.getImagePipeline().fetchDecodedImage(imageRequest, (Object)this);
                AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setImageRequest((Object)imageRequest)).setControllerListener((ControllerListener)new BaseControllerListener<ImageInfo>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onFinalImageSet(String id, @Nullable ImageInfo imageInfo, @Nullable Animatable animatable) {
                        CloseableReference imageReference = null;
                        OverlayImage overlayImage = null;
                        try {
                            CloseableStaticBitmap closeableStaticBitmap;
                            Bitmap bitmap;
                            CloseableImage image;
                            imageReference = (CloseableReference)dataSource.getResult();
                            if (imageReference != null && (image = (CloseableImage)imageReference.get()) instanceof CloseableStaticBitmap && (bitmap = (closeableStaticBitmap = (CloseableStaticBitmap)image).getUnderlyingBitmap()) != null) {
                                bitmap = bitmap.copy(Bitmap.Config.ARGB_8888, true);
                                overlayImage = OverlayImage.fromBitmap((Bitmap)bitmap);
                                OverlayImages.put(uri, overlayImage);
                            }
                        }
                        finally {
                            dataSource.close();
                            if (imageReference != null) {
                                CloseableReference.closeSafely((CloseableReference)imageReference);
                            }
                        }
                        if (overlayImage != null) {
                            RNNaverMapPathOverlay.this.setOverlayImage(overlayImage);
                        }
                    }
                })).setOldController(this.imageHolder.getController())).build();
                this.imageHolder.setController((DraweeController)controller);
            } else {
                int rid = this.getRidFromName(uri);
                OverlayImage overlayImage1 = OverlayImage.fromResource((int)rid);
                OverlayImages.put(uri, overlayImage1);
                this.setOverlayImage(overlayImage1);
            }
        }
    }

    private void setOverlayImage(OverlayImage image) {
        ((PathOverlay)this.feature).setPatternImage(image);
    }

    private int getRidFromName(String name) {
        return this.getContext().getResources().getIdentifier(name, "drawable", this.getContext().getPackageName());
    }
}

