/*
 * Decompiled with CFR 0.152.
 */
package com.giftsets.reactnative.nmaps;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.giftsets.reactnative.nmaps.RNNaverMapPathOverlay;
import com.giftsets.reactnative.nmaps.ReactUtil;

public class RNNaverMapPathOverlayManager
extends ViewGroupManager<RNNaverMapPathOverlay> {
    private final DisplayMetrics metrics;

    public RNNaverMapPathOverlayManager(ReactApplicationContext reactContext) {
        if (Build.VERSION.SDK_INT >= 17) {
            this.metrics = new DisplayMetrics();
            ((WindowManager)reactContext.getSystemService("window")).getDefaultDisplay().getRealMetrics(this.metrics);
        } else {
            this.metrics = reactContext.getResources().getDisplayMetrics();
        }
    }

    @NonNull
    public String getName() {
        return "RNNaverMapPathOverlay";
    }

    @NonNull
    protected RNNaverMapPathOverlay createViewInstance(@NonNull ThemedReactContext reactContext) {
        return new RNNaverMapPathOverlay((Context)reactContext);
    }

    @ReactProp(name="coordinates")
    public void setCoordinate(RNNaverMapPathOverlay view, ReadableArray coordinates) {
        view.setCoords(ReactUtil.toLatLngList(coordinates));
    }

    @ReactProp(name="width", defaultFloat=1.0f)
    public void setStrokeWidth(RNNaverMapPathOverlay view, float widthInPoints) {
        float widthInScreenPx = this.metrics.density * widthInPoints;
        view.setWidth(widthInScreenPx);
    }

    @ReactProp(name="zIndex", defaultInt=0)
    public void setProgress(RNNaverMapPathOverlay view, int zIndex) {
        view.setZIndex(zIndex);
    }

    @ReactProp(name="color", defaultInt=-65536, customType="Color")
    public void setColor(RNNaverMapPathOverlay view, int color) {
        view.setColor(color);
    }

    @ReactProp(name="outlineWidth", defaultFloat=1.0f)
    public void setOutlineWidth(RNNaverMapPathOverlay view, float widthInPoints) {
        float widthInScreenPx = this.metrics.density * widthInPoints;
        view.setOutlineWidth(widthInScreenPx);
    }

    @ReactProp(name="passedColor", defaultInt=-65536, customType="Color")
    public void setPassedColor(RNNaverMapPathOverlay view, int color) {
        view.setPassedColor(color);
    }

    @ReactProp(name="outlineColor", defaultInt=-65536, customType="Color")
    public void setOutlineColor(RNNaverMapPathOverlay view, int color) {
        view.setOutlineColor(color);
    }

    @ReactProp(name="passedOutlineColor", defaultInt=-65536, customType="Color")
    public void setPassedOutlineColor(RNNaverMapPathOverlay view, int color) {
        view.setPassedOutlineColor(color);
    }

    @ReactProp(name="pattern")
    public void setPatternInterval(RNNaverMapPathOverlay view, String image) {
        view.setPattern(image);
    }

    @ReactProp(name="patternInterval", defaultFloat=1.0f)
    public void setPatternInterval(RNNaverMapPathOverlay view, float widthInPoints) {
        int widthInScreenPx = Math.round(this.metrics.density * widthInPoints);
        view.setPatternInterval(widthInScreenPx);
    }

    @ReactProp(name="progress", defaultFloat=0.0f)
    public void setProgress(RNNaverMapPathOverlay view, float progress) {
        view.setProgress(progress);
    }
}

