/*
 * Decompiled with CFR 0.152.
 */
package com.giftsets.reactnative.nmaps;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.giftsets.reactnative.nmaps.RNNaverMapPolylineOverlay;
import com.giftsets.reactnative.nmaps.ReactUtil;

public class RNNaverMapPolylineOverlayManager
extends ViewGroupManager<RNNaverMapPolylineOverlay> {
    private final DisplayMetrics metrics;

    public RNNaverMapPolylineOverlayManager(ReactApplicationContext reactContext) {
        if (Build.VERSION.SDK_INT >= 17) {
            this.metrics = new DisplayMetrics();
            ((WindowManager)reactContext.getSystemService("window")).getDefaultDisplay().getRealMetrics(this.metrics);
        } else {
            this.metrics = reactContext.getResources().getDisplayMetrics();
        }
    }

    @NonNull
    public String getName() {
        return "RNNaverMapPolylineOverlay";
    }

    @NonNull
    protected RNNaverMapPolylineOverlay createViewInstance(@NonNull ThemedReactContext reactContext) {
        return new RNNaverMapPolylineOverlay((Context)reactContext);
    }

    @ReactProp(name="coordinates")
    public void setCoordinate(RNNaverMapPolylineOverlay view, ReadableArray coordinates) {
        view.setCoords(ReactUtil.toLatLngList(coordinates));
    }

    @ReactProp(name="strokeWidth", defaultFloat=1.0f)
    public void setStrokeWidth(RNNaverMapPolylineOverlay view, float widthInPoints) {
        float widthInScreenPx = this.metrics.density * widthInPoints;
        view.setLineWidth(widthInScreenPx);
    }

    @ReactProp(name="strokeColor", defaultInt=-65536, customType="Color")
    public void setStrokeColor(RNNaverMapPolylineOverlay view, int color) {
        view.setLineColor(color);
    }
}

