/*
 * Decompiled with CFR 0.152.
 */
package com.giftsets.reactnative.nmaps;

import android.content.Context;
import android.graphics.PointF;
import android.util.Log;
import android.view.Choreographer;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.core.util.Pair;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.giftsets.reactnative.nmaps.RNNaverMapCircleOverlay;
import com.giftsets.reactnative.nmaps.RNNaverMapFeature;
import com.giftsets.reactnative.nmaps.RNNaverMapMarker;
import com.giftsets.reactnative.nmaps.RNNaverMapPathOverlay;
import com.giftsets.reactnative.nmaps.RNNaverMapPolylineOverlay;
import com.naver.maps.geometry.LatLng;
import com.naver.maps.geometry.LatLngBounds;
import com.naver.maps.map.CameraAnimation;
import com.naver.maps.map.CameraPosition;
import com.naver.maps.map.CameraUpdate;
import com.naver.maps.map.LocationSource;
import com.naver.maps.map.LocationTrackingMode;
import com.naver.maps.map.MapView;
import com.naver.maps.map.NaverMap;
import com.naver.maps.map.OnMapReadyCallback;
import com.naver.maps.map.overlay.CircleOverlay;
import com.naver.maps.map.overlay.InfoWindow;
import com.naver.maps.map.overlay.Marker;
import com.naver.maps.map.overlay.PathOverlay;
import com.naver.maps.map.overlay.PolylineOverlay;
import com.naver.maps.map.util.FusedLocationSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RNNaverMapView
extends MapView
implements OnMapReadyCallback,
NaverMap.OnCameraIdleListener,
NaverMap.OnMapClickListener {
    public static final String[] EVENT_NAMES = new String[]{"onInitialized", "onCameraChange", "onMapClick", "onTouch"};
    private ThemedReactContext themedReactContext;
    private FusedLocationSource locationSource;
    private LifecycleEventListener lifecycleListener;
    private NaverMap naverMap;
    private List<Marker> markers = new ArrayList<Marker>();
    private List<CircleOverlay> circleOverlays = new ArrayList<CircleOverlay>();
    private List<PolylineOverlay> polylineOverlays = new ArrayList<PolylineOverlay>();
    private Map<Integer, Pair<Marker, InfoWindow>> infoWindows = new HashMap<Integer, Pair<Marker, InfoWindow>>();
    private PathOverlay path;
    long lastTouch = 0L;
    private final List<RNNaverMapFeature> features = new ArrayList<RNNaverMapFeature>();
    private final Map<Marker, RNNaverMapMarker> markerMap = new HashMap<Marker, RNNaverMapMarker>();
    private final Map<PolylineOverlay, RNNaverMapPolylineOverlay> polylineMap = new HashMap<PolylineOverlay, RNNaverMapPolylineOverlay>();
    private final Map<CircleOverlay, RNNaverMapCircleOverlay> circleMap = new HashMap<CircleOverlay, RNNaverMapCircleOverlay>();
    private final Map<PathOverlay, RNNaverMapPathOverlay> pathOverlayMap = new HashMap<PathOverlay, RNNaverMapPathOverlay>();

    private static boolean contextHasBug(Context context) {
        return context == null || context.getResources() == null || context.getResources().getConfiguration() == null;
    }

    private static Context getNonBuggyContext(ThemedReactContext reactContext, ReactApplicationContext appContext) {
        ThemedReactContext superContext = reactContext;
        if (!RNNaverMapView.contextHasBug((Context)appContext.getCurrentActivity())) {
            superContext = appContext.getCurrentActivity();
        } else if (RNNaverMapView.contextHasBug((Context)superContext)) {
            if (!RNNaverMapView.contextHasBug((Context)reactContext.getCurrentActivity())) {
                superContext = reactContext.getCurrentActivity();
            } else if (!RNNaverMapView.contextHasBug(reactContext.getApplicationContext())) {
                superContext = reactContext.getApplicationContext();
            }
        }
        return superContext;
    }

    public RNNaverMapView(@NonNull ThemedReactContext themedReactContext, ReactApplicationContext appContext, FusedLocationSource locationSource) {
        super(RNNaverMapView.getNonBuggyContext(themedReactContext, appContext));
        this.themedReactContext = themedReactContext;
        this.locationSource = locationSource;
        super.onCreate(null);
        super.onStart();
        this.getMapAsync(this);
        Choreographer.getInstance().postFrameCallback(new Choreographer.FrameCallback(){

            public void doFrame(long frameTimeNanos) {
                RNNaverMapView.this.manuallyLayoutChildren();
                RNNaverMapView.this.getViewTreeObserver().dispatchOnGlobalLayout();
                Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
            }
        });
    }

    void manuallyLayoutChildren() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            child.measure(View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0x40000000));
            child.layout(0, 0, child.getMeasuredWidth(), child.getMeasuredHeight());
        }
    }

    public void onMapReady(@NonNull NaverMap naverMap) {
        this.naverMap = naverMap;
        this.naverMap.setLocationSource((LocationSource)this.locationSource);
        this.naverMap.setOnMapClickListener((NaverMap.OnMapClickListener)this);
        this.naverMap.addOnCameraChangeListener((reason, animated) -> {
            if (reason == -1 && System.currentTimeMillis() - this.lastTouch > 1000L) {
                this.emitEvent("onTouch", null);
                this.lastTouch = System.currentTimeMillis();
            }
        });
        this.onInitialized();
        Log.e((String)"RNNaverMapView.onMapReady", (String)"onMapReady");
        this.lifecycleListener = new LifecycleEventListener(){

            public void onHostResume() {
            }

            public void onHostPause() {
            }

            public void onHostDestroy() {
                if (RNNaverMapView.this.locationSource != null) {
                    RNNaverMapView.this.locationSource.deactivate();
                }
                RNNaverMapView.this.themedReactContext.removeLifecycleEventListener(RNNaverMapView.this.lifecycleListener);
                RNNaverMapView.this.themedReactContext = null;
            }
        };
        this.themedReactContext.addLifecycleEventListener(this.lifecycleListener);
    }

    public void setCenter(LatLng latLng) {
        this.getMapAsync(e -> {
            CameraUpdate cameraUpdate = CameraUpdate.scrollTo((LatLng)latLng).animate(CameraAnimation.Easing);
            this.naverMap.moveCamera(cameraUpdate);
        });
    }

    public void setCenter(LatLng latLng, Double zoom, Double tilt, Double bearing) {
        this.getMapAsync(e -> {
            if (zoom != null && tilt != null && bearing != null) {
                this.naverMap.moveCamera(CameraUpdate.toCameraPosition((CameraPosition)new CameraPosition(latLng, zoom.doubleValue(), tilt.doubleValue(), bearing.doubleValue())).animate(CameraAnimation.Easing));
            }
        });
    }

    public void zoomTo(LatLngBounds latLngBounds, int paddingInPx) {
        this.getMapAsync(e -> {
            CameraUpdate cameraUpdate = CameraUpdate.fitBounds((LatLngBounds)latLngBounds, (int)paddingInPx).animate(CameraAnimation.Easing);
            this.naverMap.moveCamera(cameraUpdate);
        });
    }

    public void setTilt(int tilt) {
        this.getMapAsync(e -> {
            CameraPosition cameraPosition = this.naverMap.getCameraPosition();
            this.naverMap.moveCamera(CameraUpdate.toCameraPosition((CameraPosition)new CameraPosition(cameraPosition.target, cameraPosition.zoom, (double)tilt, cameraPosition.bearing)));
        });
    }

    public void setBearing(int bearing) {
        this.getMapAsync(e -> {
            CameraPosition cameraPosition = this.naverMap.getCameraPosition();
            this.naverMap.moveCamera(CameraUpdate.toCameraPosition((CameraPosition)new CameraPosition(cameraPosition.target, cameraPosition.zoom, cameraPosition.tilt, (double)bearing)));
        });
    }

    public void setMapPadding(int left, int top, int right, int bottom) {
        this.getMapAsync(e -> this.naverMap.setContentPadding(left, top, right, bottom));
    }

    public void setMarkers(List<Marker> markersArray) {
        this.getMapAsync(e -> {
            for (Marker marker : this.markers) {
                marker.setMap(null);
            }
            this.markers.clear();
            if (markersArray != null && markersArray.size() > 0) {
                this.markers = markersArray;
                for (Marker marker : this.markers) {
                    marker.setMap(this.naverMap);
                }
            }
        });
    }

    public void setCircle(List<CircleOverlay> circleArray) {
        this.getMapAsync(e -> {
            for (CircleOverlay circleOverlay : this.circleOverlays) {
                circleOverlay.setMap(null);
            }
            this.circleOverlays.clear();
            if (circleArray != null && circleArray.size() > 0) {
                this.circleOverlays = circleArray;
                for (CircleOverlay circleOverlay : this.circleOverlays) {
                    circleOverlay.setMap(this.naverMap);
                }
            }
        });
    }

    public void setPolyLine(List<PolylineOverlay> polyLineArray) {
        this.getMapAsync(e -> {
            for (PolylineOverlay polylineOverlay : this.polylineOverlays) {
                polylineOverlay.setMap(null);
            }
            this.polylineOverlays.clear();
            if (polyLineArray != null && polyLineArray.size() > 0) {
                this.polylineOverlays = polyLineArray;
                for (PolylineOverlay polylineOverlay : this.polylineOverlays) {
                    polylineOverlay.setMap(this.naverMap);
                }
            }
        });
    }

    public void setPath(PathOverlay path) {
        this.getMapAsync(e -> {
            if (this.path != null) {
                this.path.setMap(null);
            }
            if (path != null) {
                this.path = path;
                this.path.setMap(this.naverMap);
            }
        });
    }

    public void onInitialized() {
        this.emitEvent("onInitialized", null);
    }

    public void watchCameraChange() {
        this.getMapAsync(e -> {
            this.naverMap.removeOnCameraIdleListener((NaverMap.OnCameraIdleListener)this);
            this.naverMap.addOnCameraIdleListener((NaverMap.OnCameraIdleListener)this);
        });
    }

    public void showsMyLocationButton(boolean show) {
        this.getMapAsync(e -> this.naverMap.getUiSettings().setLocationButtonEnabled(show));
    }

    public void setCompassEnabled(boolean show) {
        this.getMapAsync(e -> this.naverMap.getUiSettings().setCompassEnabled(show));
    }

    public void setScaleBarEnabled(boolean show) {
        this.getMapAsync(e -> this.naverMap.getUiSettings().setScaleBarEnabled(show));
    }

    public void setZoomControlEnabled(boolean show) {
        this.getMapAsync(e -> this.naverMap.getUiSettings().setZoomControlEnabled(show));
    }

    public void setLocationTrackingMode(int mode) {
        this.getMapAsync(e -> this.naverMap.setLocationTrackingMode(LocationTrackingMode.values()[mode]));
    }

    public void setMapType(NaverMap.MapType value) {
        this.getMapAsync(e -> this.naverMap.setMapType(value));
    }

    public void setBuildingHeight(float height) {
        this.getMapAsync(e -> this.naverMap.setBuildingHeight(height));
    }

    public void setLayerGroupEnabled(String layerGroup, boolean enable) {
        this.getMapAsync(e -> this.naverMap.setLayerGroupEnabled(layerGroup, enable));
    }

    public void setNightModeEnabled(boolean enable) {
        this.getMapAsync(e -> this.naverMap.setNightModeEnabled(enable));
    }

    public void setLogoMargin(int left, int top, int right, int bottom) {
        this.getMapAsync(e -> this.naverMap.getUiSettings().setLogoMargin(left, top, right, bottom));
    }

    public void setLogoGravity(int gravity) {
        this.getMapAsync(e -> this.naverMap.getUiSettings().setLogoGravity(gravity));
    }

    public void moveCameraFitBound(LatLngBounds bounds, int left, int top, int right, int bottom) {
        this.getMapAsync(e -> this.naverMap.moveCamera(CameraUpdate.fitBounds((LatLngBounds)bounds, (int)left, (int)top, (int)right, (int)bottom).animate(CameraAnimation.Fly, 500L)));
    }

    public void openInfoWindow(int id, LatLng at, final String string) {
        Pair<Marker, InfoWindow> oldInfoWindow = this.infoWindows.get(id);
        if (oldInfoWindow != null) {
            this.closeInfoWindow(id);
        }
        InfoWindow infoWindow = new InfoWindow();
        infoWindow.setAdapter((InfoWindow.Adapter)new InfoWindow.DefaultTextAdapter((Context)this.themedReactContext){

            @NonNull
            public CharSequence getText(@NonNull InfoWindow infoWindow) {
                return string;
            }
        });
        infoWindow.setPosition(at);
        infoWindow.open(this.naverMap);
        this.infoWindows.put(id, (Pair<Marker, InfoWindow>)Pair.create(null, (Object)infoWindow));
    }

    public void closeInfoWindow(int id) {
        Pair<Marker, InfoWindow> infoWindow = this.infoWindows.get(id);
        if (infoWindow != null) {
            if (infoWindow.first != null) {
                ((Marker)infoWindow.first).setMap(null);
            }
            ((InfoWindow)infoWindow.second).close();
            ((InfoWindow)infoWindow.second).setMap(null);
            this.infoWindows.remove(id);
        }
    }

    public void addFeature(View child, int index) {
        this.getMapAsync(e -> {
            if (child instanceof RNNaverMapMarker) {
                RNNaverMapMarker annotation = (RNNaverMapMarker)child;
                annotation.addToMap(this);
                this.features.add(index, annotation);
                this.markerMap.put((Marker)annotation.getFeature(), annotation);
            } else if (child instanceof RNNaverMapCircleOverlay) {
                RNNaverMapCircleOverlay annotation = (RNNaverMapCircleOverlay)child;
                annotation.addToMap(this);
                this.features.add(index, annotation);
                this.circleMap.put((CircleOverlay)annotation.getFeature(), annotation);
            } else if (child instanceof RNNaverMapPolylineOverlay) {
                RNNaverMapPolylineOverlay annotation = (RNNaverMapPolylineOverlay)child;
                annotation.addToMap(this);
                this.features.add(index, annotation);
                this.polylineMap.put((PolylineOverlay)annotation.getFeature(), annotation);
            } else if (child instanceof RNNaverMapPathOverlay) {
                RNNaverMapPathOverlay annotation = (RNNaverMapPathOverlay)child;
                annotation.addToMap(this);
                this.features.add(index, annotation);
                this.pathOverlayMap.put((PathOverlay)annotation.getFeature(), annotation);
            }
        });
    }

    public void removeFeatureAt(int index) {
        RNNaverMapFeature feature = this.features.remove(index);
        if (feature instanceof RNNaverMapMarker) {
            this.markerMap.remove(feature.getFeature());
        } else if (feature instanceof RNNaverMapCircleOverlay) {
            this.circleMap.remove(feature.getFeature());
        } else if (feature instanceof RNNaverMapPolylineOverlay) {
            this.polylineMap.remove(feature.getFeature());
        } else if (feature instanceof RNNaverMapPathOverlay) {
            this.pathOverlayMap.remove(feature.getFeature());
        }
        feature.removeFromMap();
    }

    public int getFeatureCount() {
        return this.features.size();
    }

    public View getFeatureAt(int index) {
        return (View)this.features.get(index);
    }

    public void onCameraIdle() {
        CameraPosition cameraPosition = this.naverMap.getCameraPosition();
        WritableMap param = Arguments.createMap();
        param.putDouble("latitude", cameraPosition.target.latitude);
        param.putDouble("longitude", cameraPosition.target.longitude);
        param.putDouble("zoom", cameraPosition.zoom);
        this.emitEvent("onCameraChange", param);
    }

    public void onMapClick(@NonNull PointF pointF, @NonNull LatLng latLng) {
        WritableMap param = Arguments.createMap();
        param.putDouble("x", (double)pointF.x);
        param.putDouble("y", (double)pointF.y);
        param.putDouble("latitude", latLng.latitude);
        param.putDouble("longitude", latLng.longitude);
        this.emitEvent("onMapClick", param);
    }

    private void emitEvent(String eventName, WritableMap param) {
        ((RCTEventEmitter)this.themedReactContext.getJSModule(RCTEventEmitter.class)).receiveEvent(this.getId(), eventName, param);
    }

    public NaverMap getMap() {
        return this.naverMap;
    }
}

