/*
 * Decompiled with CFR 0.152.
 */
package com.giftsets.reactnative.nmaps;

import android.app.Activity;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Consumer;
import com.airbnb.android.react.maps.SizeReportingShadowNode;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.giftsets.reactnative.nmaps.RNNaverMapView;
import com.giftsets.reactnative.nmaps.ReactUtil;
import com.naver.maps.geometry.LatLng;
import com.naver.maps.geometry.LatLngBounds;
import com.naver.maps.map.NaverMap;
import com.naver.maps.map.util.FusedLocationSource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class RNNaverMapViewManager
extends ViewGroupManager<RNNaverMapView> {
    private final ReactApplicationContext appContext;
    private static FusedLocationSource locationSource;
    private static final int ANIMATE_TO_REGION = 1;
    private static final int ANIMATE_TO_COORDINATE = 2;
    private static final int ANIMATE_TO_TWO_COORDINATES = 3;
    private static final int SET_LOCATION_TRACKING_MODE = 4;
    private static final int WATCH_CAMERA_CHANGE = 5;
    private static final int ANIMATE_TO_COORDINATES = 6;

    public RNNaverMapViewManager(ReactApplicationContext context) {
        this.appContext = context;
        locationSource = new FusedLocationSource(context.getCurrentActivity(), 4096);
    }

    public static void onCreate(Activity activity) {
        locationSource = new FusedLocationSource(activity, 4096);
    }

    public static boolean onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        return locationSource.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @NonNull
    public String getName() {
        return "RNNaverMapView";
    }

    @NonNull
    protected RNNaverMapView createViewInstance(@NonNull ThemedReactContext reactContext) {
        return new RNNaverMapView(reactContext, this.appContext, locationSource);
    }

    @ReactProp(name="center")
    public void setCenter(RNNaverMapView mapView, @Nullable ReadableMap option) {
        if (option != null) {
            if (option.hasKey("zoom") && option.hasKey("tilt") && option.hasKey("bearing")) {
                mapView.setCenter(ReactUtil.toNaverLatLng(option), option.getDouble("zoom"), option.getDouble("tilt"), option.getDouble("bearing"));
            } else {
                mapView.setCenter(ReactUtil.toNaverLatLng(option));
            }
        }
    }

    @ReactProp(name="showsMyLocationButton", defaultBoolean=false)
    public void showsMyLocationButton(RNNaverMapView mapView, boolean show) {
        mapView.showsMyLocationButton(show);
    }

    @ReactProp(name="compass", defaultBoolean=false)
    public void setCompassEnabled(RNNaverMapView mapView, boolean show) {
        mapView.setCompassEnabled(show);
    }

    @ReactProp(name="scaleBar", defaultBoolean=false)
    public void setScaleBarEnabled(RNNaverMapView mapView, boolean show) {
        mapView.setScaleBarEnabled(show);
    }

    @ReactProp(name="zoomControl", defaultBoolean=false)
    public void setZoomControlEnabled(RNNaverMapView mapView, boolean show) {
        mapView.setZoomControlEnabled(show);
    }

    @ReactProp(name="mapType", defaultInt=0)
    public void setMapType(RNNaverMapView mapView, int mapType) {
        mapView.setMapType(NaverMap.MapType.values()[mapType]);
    }

    @ReactProp(name="buildingHeight", defaultFloat=1.0f)
    public void setBuildingHeight(RNNaverMapView mapView, float height) {
        mapView.setBuildingHeight(height);
    }

    @ReactProp(name="locationTrackingMode", defaultInt=0)
    public void locationTrackingMode(RNNaverMapView mapView, int mode) {
        if (mode >= 0) {
            mapView.setLocationTrackingMode(mode);
        }
    }

    @ReactProp(name="tilt", defaultInt=0)
    public void setTilt(RNNaverMapView mapView, int tilt) {
        mapView.setTilt(tilt);
    }

    @ReactProp(name="bearing", defaultInt=0)
    public void setBearing(RNNaverMapView mapView, int bearing) {
        mapView.setBearing(bearing);
    }

    @ReactProp(name="layerGroup")
    public void setLayerGroupEnabled(RNNaverMapView mapView, @Nullable ReadableMap option) {
        List<String> layerGroups = Arrays.asList("building", "transit", "bike", "ctt", "landparcel", "mountain");
        if (option != null) {
            for (String layerGroup : layerGroups) {
                mapView.setLayerGroupEnabled(layerGroup, option.getBoolean(layerGroup));
            }
        } else {
            for (String layerGroup : layerGroups) {
                mapView.setLayerGroupEnabled(layerGroup, false);
            }
        }
    }

    @ReactProp(name="nightMode", defaultBoolean=false)
    public void setNightModeEnabled(RNNaverMapView mapView, boolean enable) {
        mapView.setNightModeEnabled(enable);
    }

    @ReactProp(name="mapPadding")
    public void setMapPadding(RNNaverMapView mapView, @Nullable ReadableMap padding) {
        Rect rect = this.getRect(padding, mapView.getResources().getDisplayMetrics().density);
        mapView.setMapPadding(rect.left, rect.top, rect.right, rect.bottom);
    }

    @ReactProp(name="logoMargin")
    public void setLogoMargin(RNNaverMapView mapView, @Nullable ReadableMap margin) {
        Rect rect = this.getRect(margin, mapView.getResources().getDisplayMetrics().density);
        mapView.setLogoMargin(rect.left, rect.top, rect.right, rect.bottom);
    }

    @ReactProp(name="logoGravity")
    public void setLogoGravity(RNNaverMapView mapView, int gravity) {
        mapView.setLogoGravity(gravity);
    }

    private Rect getRect(@Nullable ReadableMap padding, float density) {
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        if (padding != null) {
            if (padding.hasKey("left")) {
                left = Math.round((float)padding.getDouble("left") * density);
            }
            if (padding.hasKey("top")) {
                top = Math.round((float)padding.getDouble("top") * density);
            }
            if (padding.hasKey("right")) {
                right = Math.round((float)padding.getDouble("right") * density);
            }
            if (padding.hasKey("bottom")) {
                bottom = Math.round((float)padding.getDouble("bottom") * density);
            }
        }
        return new Rect(left, top, right, bottom);
    }

    public void receiveCommand(@NonNull RNNaverMapView mapView, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                ReadableMap region = args.getMap(0);
                double lat = region.getDouble("latitude");
                double lng = region.getDouble("longitude");
                double latDelta = region.getDouble("latitudeDelta");
                double lngDelta = region.getDouble("longitudeDelta");
                break;
            }
            case 3: {
                float density = mapView.getResources().getDisplayMetrics().density;
                ReadableMap region1 = args.getMap(0);
                ReadableMap region2 = args.getMap(1);
                int padding = args.size() == 3 ? args.getInt(2) : 56;
                double lat1 = region1.getDouble("latitude");
                double lng1 = region1.getDouble("longitude");
                double lat2 = region2.getDouble("latitude");
                double lng2 = region2.getDouble("longitude");
                mapView.zoomTo(new LatLngBounds(new LatLng(Math.max(lat1, lat2), Math.min(lng1, lng2)), new LatLng(Math.min(lat1, lat2), Math.max(lng1, lng2))), Math.round((float)padding * density));
                break;
            }
            case 6: {
                ReadableArray coordinatesArray = args.getArray(0);
                ReadableMap edgePadding = args.getMap(1);
                LatLngBounds.Builder builder = new LatLngBounds.Builder();
                for (int i = 0; i < coordinatesArray.size(); ++i) {
                    builder.include(ReactUtil.toNaverLatLng(coordinatesArray.getMap(i)));
                }
                int left = ReactUtil.getInt(edgePadding, "left", 0);
                int top = ReactUtil.getInt(edgePadding, "top", 0);
                int right = ReactUtil.getInt(edgePadding, "right", 0);
                int bottom = ReactUtil.getInt(edgePadding, "bottom", 0);
                mapView.moveCameraFitBound(builder.build(), left, top, right, bottom);
                break;
            }
            case 2: {
                mapView.setCenter(ReactUtil.toNaverLatLng(args.getMap(0)));
                break;
            }
            case 4: {
                mapView.setLocationTrackingMode(args.getInt(0));
                break;
            }
            case 5: {
                mapView.watchCameraChange();
            }
        }
    }

    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.builder().put((Object)"animateToRegion", (Object)1).put((Object)"animateToCoordinate", (Object)2).put((Object)"animateToTwoCoordinates", (Object)3).put((Object)"setLocationTrackingMode", (Object)4).put((Object)"watchCameraChange", (Object)5).put((Object)"animateToCoordinates", (Object)6).build();
    }

    public Map<String, Object> getExportedCustomBubblingEventTypeConstants() {
        MapBuilder.Builder builder = MapBuilder.builder();
        for (String eventName : RNNaverMapView.EVENT_NAMES) {
            builder.put((Object)eventName, this.bubbled(eventName));
        }
        return builder.build();
    }

    public LayoutShadowNode createShadowNodeInstance() {
        return new SizeReportingShadowNode();
    }

    public void addView(RNNaverMapView parent, View child, int index) {
        parent.addFeature(child, index);
    }

    public int getChildCount(RNNaverMapView view) {
        return view.getFeatureCount();
    }

    public View getChildAt(RNNaverMapView view, int index) {
        return view.getFeatureAt(index);
    }

    public void removeViewAt(RNNaverMapView parent, int index) {
        parent.removeFeatureAt(index);
    }

    public boolean needsCustomLayoutForChildren() {
        return true;
    }

    public void onDropViewInstance(RNNaverMapView view) {
        view.onStop();
        super.onDropViewInstance((View)view);
    }

    private Map<String, Object> bubbled(String callbackName) {
        return MapBuilder.of((Object)"phasedRegistrationNames", (Object)MapBuilder.of((Object)"bubbled", (Object)callbackName));
    }

    private void getDp(ReadableMap option, String key, Consumer<Integer> consumer) {
        ReactUtil.getInt(option, key, (Consumer<Integer>)((Consumer)number -> {
            float density = this.appContext.getResources().getDisplayMetrics().density;
            consumer.accept((Object)Math.round(density * (float)number.intValue()));
        }));
    }
}

