/*
 * Decompiled with CFR 0.152.
 */
package com.giftsets.reactnative.nmaps;

import android.graphics.PointF;
import androidx.annotation.Nullable;
import androidx.core.util.Consumer;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.naver.maps.geometry.LatLng;
import java.util.ArrayList;
import java.util.List;

public class ReactUtil {
    public static int parseColorString(String hex) {
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        } else if (hex.startsWith("0x")) {
            hex = hex.substring(2);
        }
        if (hex.length() == 6) {
            int rgb = Integer.valueOf(hex, 16);
            return 0xFF000000 | rgb;
        }
        if (hex.length() == 10) {
            int a = Integer.valueOf(hex.substring(0, 2), 16);
            int rgb = Integer.valueOf(hex.substring(2), 16);
            return a << 24 | rgb;
        }
        return -16777216;
    }

    public static LatLng toNaverLatLng(ReadableMap map) {
        double latitude = map.getDouble("latitude");
        double longitude = map.getDouble("longitude");
        return new LatLng(latitude, longitude);
    }

    public static List<LatLng> toLatLngList(ReadableArray array) {
        ArrayList<LatLng> coords = new ArrayList<LatLng>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            coords.add(ReactUtil.toNaverLatLng(array.getMap(i)));
        }
        return coords;
    }

    public static Integer getInt(@Nullable ReadableMap option, String key, Integer defaultValue) {
        if (option != null && option.hasKey(key)) {
            return option.getInt(key);
        }
        return defaultValue;
    }

    public static void getNumber(ReadableMap option, String key, Consumer<Double> consumer) {
        if (option.hasKey(key)) {
            consumer.accept((Object)option.getDouble(key));
        }
    }

    public static void getFloat(ReadableMap option, String key, Consumer<Float> consumer) {
        if (option.hasKey(key)) {
            consumer.accept((Object)Float.valueOf((float)option.getDouble(key)));
        }
    }

    public static void getInt(ReadableMap option, String key, Consumer<Integer> consumer) {
        if (option.hasKey(key)) {
            consumer.accept((Object)option.getInt(key));
        }
    }

    public static void getString(ReadableMap option, String key, Consumer<String> consumer) {
        if (option.hasKey(key)) {
            consumer.accept((Object)option.getString(key));
        }
    }

    public static void getBoolean(ReadableMap option, String key, Consumer<Boolean> consumer) {
        if (option.hasKey(key)) {
            consumer.accept((Object)option.getBoolean(key));
        }
    }

    public static void getHexColor(ReadableMap option, String key, Consumer<Integer> consumer) {
        ReactUtil.getString(option, key, (Consumer<String>)((Consumer)s -> consumer.accept((Object)ReactUtil.parseColorString(s))));
    }

    public static void getLatLng(ReadableMap option, String key, Consumer<LatLng> consumer) {
        if (option.hasKey(key) && option.hasKey("latitude") && option.hasKey("longitude")) {
            consumer.accept((Object)new LatLng(option.getDouble("latitude"), option.getDouble("longitude")));
        }
    }

    public static void getLatLngList(ReadableMap option, String key, Consumer<List<LatLng>> consumer) {
        if (option.hasKey(key)) {
            consumer.accept(ReactUtil.toLatLngList(option.getArray(key)));
        }
    }

    public static void getAnchor(ReadableMap option, Consumer<PointF> consumer) {
        if (option.hasKey("anchor")) {
            PointF anchor = new PointF(0.5f, 1.0f);
            ReadableArray anchorArray = option.getArray("anchor");
            anchor.x = (float)anchorArray.getDouble(0);
            anchor.y = (float)anchorArray.getDouble(1);
            consumer.accept((Object)anchor);
        }
    }

    public static LatLng interpolate(float fraction, LatLng a, LatLng b) {
        double lat = (b.latitude - a.latitude) * (double)fraction + a.latitude;
        double lng = (b.longitude - a.longitude) * (double)fraction + a.longitude;
        return new LatLng(lat, lng);
    }
}

