/*
 * Decompiled with CFR 0.152.
 */
package im.shimo.navigationbar;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;

public class NavigationbarObseverModule
extends ReactContextBaseJavaModule
implements LifecycleEventListener {
    private final int mNavigationBarHeight;
    protected boolean mNavigationbarShow;
    private boolean mRomNavigationbarShow;
    private boolean mRealNavigationbarShow;
    private View.OnLayoutChangeListener mOnlayoutChangeListener;

    public NavigationbarObseverModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.mNavigationBarHeight = this.getNavigationBarHeight((Context)reactContext);
        this.firstInit(reactContext);
        this.mOnlayoutChangeListener = (v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> {
            if (left != oldLeft && top != oldTop && right != oldRight && bottom != oldBottom) {
                this.sendEvent(right, bottom);
            }
        };
        reactContext.addLifecycleEventListener((LifecycleEventListener)this);
    }

    private void firstInit(ReactApplicationContext reactContext) {
        Activity activity = reactContext.getCurrentActivity();
        if (activity == null) {
            FLog.e((String)"ReactNative", (String)"firstInit,no activity to register receiver");
            return;
        }
        View rootView = activity.findViewById(0x1020002);
        if (rootView != null) {
            Rect visibleViewArea = new Rect();
            rootView.getWindowVisibleDisplayFrame(visibleViewArea);
            this.isRomNavigationBarShow(rootView.getContext(), visibleViewArea.bottom, visibleViewArea.right);
        }
    }

    private void sendEvent(int right, int bottom) {
        Activity activity = this.getReactApplicationContext().getCurrentActivity();
        if (activity == null) {
            FLog.e((String)"ReactNative", (String)"sendEvent,no activity to register receiver");
            return;
        }
        View rootView = activity.findViewById(0x1020002);
        if (rootView != null) {
            this.isRomNavigationBarShow(rootView.getContext(), bottom, right);
        }
        WritableMap params = Arguments.createMap();
        params.putInt("navigationbarSize", this.mNavigationBarHeight);
        params.putBoolean("navigationbarShow", this.mNavigationbarShow);
        params.putBoolean("romNavigationbarShow", this.mRomNavigationbarShow);
        params.putBoolean("realNavigationbarShow", this.mRealNavigationbarShow);
        ReactApplicationContext ctx = this.getReactApplicationContext();
        if (ctx.hasActiveCatalystInstance()) {
            ((DeviceEventManagerModule.RCTDeviceEventEmitter)ctx.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("navigationbarDidShowChange", (Object)params);
        }
    }

    public String getName() {
        return "NavigationbarObseverModule";
    }

    public void onHostResume() {
        Activity activity = this.getReactApplicationContext().getCurrentActivity();
        if (activity == null) {
            FLog.e((String)"ReactNative", (String)"onHostResume,no activity to register receiver");
            return;
        }
        View rootView = activity.findViewById(0x1020002);
        if (rootView != null) {
            rootView.addOnLayoutChangeListener(this.mOnlayoutChangeListener);
        }
    }

    public void onHostPause() {
        Activity activity = this.getReactApplicationContext().getCurrentActivity();
        if (activity == null) {
            return;
        }
        try {
            View rootView = activity.findViewById(0x1020002);
            if (rootView != null) {
                rootView.removeOnLayoutChangeListener(this.mOnlayoutChangeListener);
            }
        }
        catch (IllegalArgumentException e) {
            FLog.e((String)"ReactNative", (String)"onHostPause,receiver already unregistered", (Throwable)e);
        }
    }

    public void onHostDestroy() {
    }

    @ReactMethod
    public void getNavigationbarSize(Callback callback) {
        callback.invoke(new Object[]{this.mNavigationBarHeight});
    }

    @ReactMethod
    public void isNavigationbarShow(Callback callback) {
        callback.invoke(new Object[]{this.mNavigationbarShow});
    }

    @ReactMethod
    public void isRomNavigationbarShow(Callback callback) {
        callback.invoke(new Object[]{this.mRomNavigationbarShow});
    }

    @ReactMethod
    public void isRealNavigationbarShow(Callback callback) {
        callback.invoke(new Object[]{this.mRealNavigationbarShow});
    }

    protected void isRomNavigationBarShow(Context context, int viewHeight, int viewWidth) {
        if (Build.VERSION.SDK_INT >= 17) {
            WindowManager wm = (WindowManager)context.getSystemService("window");
            Display display = wm.getDefaultDisplay();
            Point size = new Point();
            Point realSize = new Point();
            display.getRealSize(realSize);
            if (viewHeight != 0) {
                if (viewHeight == realSize.y) {
                    this.mRomNavigationbarShow = false;
                    if (viewWidth == realSize.x) {
                        this.mNavigationbarShow = false;
                    } else if (viewWidth < realSize.x) {
                        this.mNavigationbarShow = true;
                    }
                } else if (viewHeight < realSize.y) {
                    this.mRomNavigationbarShow = true;
                    this.mNavigationbarShow = true;
                }
            }
            display.getSize(size);
            this.mRealNavigationbarShow = realSize.y != size.y;
        } else {
            boolean menu = ViewConfiguration.get((Context)context).hasPermanentMenuKey();
            boolean back = KeyCharacterMap.deviceHasKey((int)4);
            if (menu || back) {
                this.mNavigationbarShow = false;
                this.mRealNavigationbarShow = false;
                this.mRomNavigationbarShow = false;
            } else {
                this.mNavigationbarShow = true;
                this.mRealNavigationbarShow = true;
                this.mRomNavigationbarShow = true;
            }
        }
    }

    private int getNavigationBarHeight(Context context) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId <= 0) {
            return 0;
        }
        int height = resources.getDimensionPixelSize(resourceId);
        return height;
    }
}

