/*
 * Decompiled with CFR 0.152.
 */
package com.psykar.cookiemanager;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.network.ForwardingCookieHandler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CookieManagerModule
extends ReactContextBaseJavaModule {
    private ForwardingCookieHandler cookieHandler;

    public CookieManagerModule(ReactApplicationContext context) {
        super(context);
        this.cookieHandler = new ForwardingCookieHandler((ReactContext)context);
    }

    public String getName() {
        return "RNCookieManagerAndroid";
    }

    @ReactMethod
    public void set(ReadableMap cookie, Promise promise) throws Exception {
        throw new Exception("Cannot call on android, try setFromResponse");
    }

    @ReactMethod
    public void setFromResponse(String url, String value, Promise promise) throws URISyntaxException, IOException {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Set-cookie", Collections.singletonList(value));
        URI uri = new URI(url);
        this.cookieHandler.put(uri, headers);
        promise.resolve(null);
    }

    @ReactMethod
    public void getFromResponse(String url, Promise promise) throws URISyntaxException, IOException {
        promise.resolve((Object)url);
    }

    @ReactMethod
    public void getAll(Promise promise) throws Exception {
        throw new Exception("Cannot get all cookies on android, try getCookieHeader(url)");
    }

    @ReactMethod
    public void get(String url, Promise promise) throws URISyntaxException, IOException {
        URI uri = new URI(url);
        Map cookieMap = this.cookieHandler.get(uri, new HashMap());
        List cookieList = (List)cookieMap.get("Cookie");
        WritableMap map = Arguments.createMap();
        if (cookieList != null) {
            String[] cookies = ((String)cookieList.get(0)).split(";");
            for (int i = 0; i < cookies.length; ++i) {
                String[] cookie = cookies[i].split("=", 2);
                if (cookie.length <= 1) continue;
                map.putString(cookie[0].trim(), cookie[1]);
            }
        }
        promise.resolve((Object)map);
    }

    @ReactMethod
    public void clearAll(final Promise promise) {
        this.cookieHandler.clearCookies(new Callback(){

            public void invoke(Object ... args) {
                promise.resolve(null);
            }
        });
    }
}

